-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- c_proginfo
---@class c_proginfo
---@field rebuild_state integer
---@field rebuild_progress integer
---@field patrol_state integer
---@field patrol_progress integer
-- c_spare_block_info
---@class c_spare_block_info
---@field slc_value integer
---@field tlc_value integer
-- c_hw_defined_estimated_lifespan_info
---@class c_hw_defined_estimated_lifespan_info
---@field slc_pe_cycle integer
---@field tlc_pe_cycle integer
---@field slc_avg_ec integer
---@field tlc_avg_ec integer
---@field slc_poh integer
---@field tlc_poh integer
---@field hw_valid_flag integer
---@field slc_used_lifespan integer
---@field tlc_used_lifespan integer
-- c_vendor_estimated_lifespan_info
---@class c_vendor_estimated_lifespan_info
---@field remn_wearout integer
---@field power_on_hours integer
---@field vendor_valid_flag integer
-- c_writeamp
---@class c_writeamp
---@field update_support_flag integer
-- c_vendor_write_amp
---@class c_vendor_write_amp
---@field valid_flag integer
---@field nand_write integer
---@field host_write integer
-- c_hw_defined_write_amp
---@class c_hw_defined_write_amp
---@field valid_flag integer
---@field nand_write_l integer
---@field nand_write_h integer
---@field host_write_l integer
---@field host_write_h integer
-- c_pd_info
---@class c_pd_info
---@field identify_status integer
---@field device_id integer
---@field sequence_num integer
---@field health integer
---@field fde_capable integer
---@field fw_state integer
---@field power_state integer
---@field scsi_dev_type integer
---@field device_speed integer
---@field link_speed integer
---@field encl_device_id integer
---@field slot_num integer
---@field media_type integer
---@field interface_type integer
---@field temperature integer
---@field boot_priority integer
---@field sas_addr1 string
---@field sas_addr2 string
---@field serial_num string
---@field model string
---@field firmware_version string
---@field manufacturer string
---@field vendor_id integer
---@field coerced_size integer
---@field media_err_count integer
---@field other_err_count integer
---@field prefail_count integer
---@field hot_spare integer
---@field remnant_media_wearout integer
---@field rotation_speed integer
---@field proginfo c_proginfo
---@field form_factor integer
---@field dev_not_supported integer
---@field fw_state_raw integer
---@field is_foreign integer
---@field coerced_size_blk integer
---@field block_size integer
---@field power_on_hours integer
---@field halflife integer
---@field last_update_timestamp integer
---@field bootable integer
---@field last_prefail_event_seq_num integer
---@field spareblock c_spare_block_info
---@field hw_defined_estimated_lifespan c_hw_defined_estimated_lifespan_info
---@field vendor_estimated_lifespan c_vendor_estimated_lifespan_info
---@field writeamp c_writeamp
---@field hw_defined_write_amp c_hw_defined_write_amp
---@field vendor_write_amp c_vendor_write_amp
local c_pd_info = {}
c_pd_info.__index = c_pd_info

function c_pd_info.new(info)
    return setmetatable(info, c_pd_info)
end

return c_pd_info
