-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- ld_info
---@class t_ld_info
---@field last_update_timestamp integer
---@field ld_warnig_info_reported integer
---@field target_id integer
---@field name string
---@field drive_state integer
---@field raid_level integer
---@field default_read_policy integer
---@field default_write_policy integer
---@field default_cache_policy integer
---@field current_read_policy integer
---@field current_write_policy integer
---@field current_cache_policy integer
---@field access_policy integer
---@field disk_cache_policy integer
---@field init_state integer
---@field consistent_check integer
---@field span_depth integer
---@field num_drive_per_span integer
---@field bgi_enabled integer
---@field bootable integer
---@field is_sscd integer
---@field is_epd integer
---@field strip_size integer
---@field accelerator integer
---@field size integer
---@field max_resizeable_size integer
---@field boot_priority integer
---@field cache_line_size integer
---@field ref_array integer[]
---@field progress_info integer
---@field sscd_ld_list integer
---@field spare_pd_ids integer
---@field spare_pd_slots integer
---@field spare_pd_enclosure_ids integer
local c_ld_info = {}
c_ld_info.__index = c_ld_info

function c_ld_info.new(info)
    return setmetatable(info, c_ld_info)
end

return c_ld_info
