-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local mc_object_manager = require 'object_manager.mc_object_manager'
local c_factory = require 'object_manager.factory'
local singleton = require 'mc.singleton'
require 'object_manager.basic'

---@class c_object_manage: c_basic_class
---@field mc c_mc_object_manage
---@field factory c_factory
local c_object_manage = class()

function c_object_manage:ctor(bus)
    self.bus = bus
    self.mc = mc_object_manager.new(bus)
    self.factory = c_factory.new()
end

function c_object_manage:init()
    self.factory:install_mc_signal(self.mc)
end

---@class c_object_manage_singleton
---@field new fun(...): c_object_manage
---@field get_instance fun(...): c_object_manage
---@field destroy fun()

---@type c_object_manage_singleton
local obj_mgr = singleton(c_object_manage)

local old_destroy = obj_mgr.destroy
function obj_mgr.destroy()
    old_destroy()
    c_factory.get_instance():reset()
end

return obj_mgr
