-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local singleton = require 'mc.singleton'
local class = require 'mc.class'
local log = require 'mc.logging'
local c_vpd_connector = require 'nvme.vpd_connector'
local c_vpd_connector_collection = class()

function c_vpd_connector_collection:ctor()
    self.on_add_vpd_connector = c_vpd_connector.on_add_object
    self.on_del_vpd_connector = c_vpd_connector.on_delete_object
end

function c_vpd_connector_collection:init()
    self.on_add_vpd_connector:on(function(obj)
        log:notice('vpd connector %s add', obj.Slot)
    end)

    self.on_del_vpd_connector:on(function(obj)
        log:notice('vpd connector %s del', obj.Slot)
    end)
end

return singleton(c_vpd_connector_collection)
