/* Copyright (c) 2024 Huawei Technologies Co., Ltd.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
#ifndef L_SML_REGISTER_CTRL_OOB
#define L_SML_REGISTER_CTRL_OOB

#include <map>
#include <mutex>
#include <optional>

#include "luawrapper.h"
#include "platform.h"
#include "sata_log.h"
#include "sas_log.h"
#include "pd_log_process.h"
#include "sml.h"
#include "sml_errcodes.h"
#include "sml_public.h"
#include "diagnose_defs.h"
#include "io_deterioration_log_process.h"
#include "subhealthy_log_process.h"

namespace sml {
template <typename T>
void reset_zero(T *o)
{
    (void)memset_s(o, sizeof(T), 0, sizeof(T));
}

template <typename T>
int push_array(lua_State *L, T *arr, size_t n)
{
    auto t = luawrap::stack::new_table(L, n);
    for (size_t i = 0; i < n; ++i) {
        t.set(i + 1, arr[i]);
    }
    return 1;
}

}  // namespace sml

#endif