/* Copyright (c) 2024 Huawei Technologies Co., Ltd.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
#ifndef L_SML_LD
#define L_SML_LD

#include "l_sml.h"

namespace sml {
class l_ld {
public:
    static void register_to(lua_State *L, luawrap::stack_table &t);
    static void register_cache_to(lua_State *L, luawrap::stack_table &t);

private:
    static void def_properties(lua_State *L, luawrap::lua_class<SML_LD_BASIC_INFO_S> &cls);
    static void def_set_properties(lua_State *L, luawrap::lua_class<SML_LD_SET_PROPERTIES_S> &cls);
    static void def_target_properties(lua_State *L, luawrap::lua_class<SML_LD_TARGET_S> &cls);
    static void def_caching_enable(lua_State *L, luawrap::lua_class<SML_LD_SSCD_CACHING_ENABLE_S> &cls);
    static void def_cache_ld(lua_State *L, luawrap::lua_class<SML_SSCD_ASSOCIATED_LD_LIST_S> &cls);
    static void def_ld_cache(lua_State *L, luawrap::lua_class<SML_LD_ASSOCIATED_SSCD_LIST_S> &cls);
};

}  // namespace sml

#endif