/* Copyright (c) 2024 Huawei Technologies Co., Ltd.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
#ifndef L_SML_CTRL
#define L_SML_CTRL

#include "l_sml.h"

namespace sml {
class register_ctrl_oob : public SML_CTRL_OOB_INFO_S {
public:
    register_ctrl_oob();
    ~register_ctrl_oob();

    static void register_to(lua_State *L, luawrap::stack_table &t);

private:
    uint32_t register_controller(lua_State *L);
    uint32_t unregister_controller(lua_State *L);
    void register_sml_adapter_function(lua_State *L);

    void set_interface_type(lua_State *L, int interface_type);
    int  get_interface_type() const;

    void set_eid(uint8_t eid)
    {
        register_info.over_mctp.eid = eid;
    }

    uint8_t get_eid() const
    {
        return register_info.over_mctp.eid;
    }

    void set_phy_addr(uint16_t phy_addr)
    {
        register_info.over_mctp.phy_addr = phy_addr;
    }

    uint16_t get_phy_addr() const
    {
        return register_info.over_mctp.phy_addr;
    }
};

class l_ctrl {
public:
    static void register_to(lua_State *L, luawrap::stack_table &t);

private:
    static void def_basic_properties(lua_State *L, luawrap::lua_class<SML_CTRL_BASIC_INFO_S> &cls);
    static void def_raid_properties(lua_State *L, luawrap::lua_class<SML_CTRL_BASIC_INFO_S> &cls);
    static void def_other_properties(lua_State *L, luawrap::lua_class<SML_CTRL_BASIC_INFO_S> &cls);
};

}  // namespace sml

#endif