-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local VolumeManage = {}

---@class VolumeManage.DriveCachePolicyWritable
---@field DriveCachePolicyWritable boolean
local TDriveCachePolicyWritable = {}
TDriveCachePolicyWritable.__index = TDriveCachePolicyWritable
TDriveCachePolicyWritable.group = {}

local function TDriveCachePolicyWritable_from_obj(obj)
    return setmetatable(obj, TDriveCachePolicyWritable)
end

function TDriveCachePolicyWritable.new(DriveCachePolicyWritable)
    return TDriveCachePolicyWritable_from_obj({DriveCachePolicyWritable = DriveCachePolicyWritable})
end
---@param obj VolumeManage.DriveCachePolicyWritable
function TDriveCachePolicyWritable:init_from_obj(obj)
    self.DriveCachePolicyWritable = obj.DriveCachePolicyWritable
end

function TDriveCachePolicyWritable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDriveCachePolicyWritable.group)
end

TDriveCachePolicyWritable.from_obj = TDriveCachePolicyWritable_from_obj

TDriveCachePolicyWritable.proto_property = {'DriveCachePolicyWritable'}

TDriveCachePolicyWritable.default = {false}

TDriveCachePolicyWritable.struct = {{name = 'DriveCachePolicyWritable', is_array = false, struct = nil}}

function TDriveCachePolicyWritable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DriveCachePolicyWritable', self.DriveCachePolicyWritable, 'bool', true, errs,
        need_convert)

    TDriveCachePolicyWritable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDriveCachePolicyWritable.proto_property, errs, need_convert)
    return self
end

function TDriveCachePolicyWritable:unpack(_)
    return self.DriveCachePolicyWritable
end

VolumeManage.DriveCachePolicyWritable = TDriveCachePolicyWritable

---@class VolumeManage.DefaultDriveCachePolicy
---@field DefaultDriveCachePolicy string
local TDefaultDriveCachePolicy = {}
TDefaultDriveCachePolicy.__index = TDefaultDriveCachePolicy
TDefaultDriveCachePolicy.group = {}

local function TDefaultDriveCachePolicy_from_obj(obj)
    return setmetatable(obj, TDefaultDriveCachePolicy)
end

function TDefaultDriveCachePolicy.new(DefaultDriveCachePolicy)
    return TDefaultDriveCachePolicy_from_obj({DefaultDriveCachePolicy = DefaultDriveCachePolicy})
end
---@param obj VolumeManage.DefaultDriveCachePolicy
function TDefaultDriveCachePolicy:init_from_obj(obj)
    self.DefaultDriveCachePolicy = obj.DefaultDriveCachePolicy
end

function TDefaultDriveCachePolicy:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDefaultDriveCachePolicy.group)
end

TDefaultDriveCachePolicy.from_obj = TDefaultDriveCachePolicy_from_obj

TDefaultDriveCachePolicy.proto_property = {'DefaultDriveCachePolicy'}

TDefaultDriveCachePolicy.default = {''}

TDefaultDriveCachePolicy.struct = {{name = 'DefaultDriveCachePolicy', is_array = false, struct = nil}}

function TDefaultDriveCachePolicy:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DefaultDriveCachePolicy', self.DefaultDriveCachePolicy, 'string', true, errs,
        need_convert)

    TDefaultDriveCachePolicy:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDefaultDriveCachePolicy.proto_property, errs, need_convert)
    return self
end

function TDefaultDriveCachePolicy:unpack(_)
    return self.DefaultDriveCachePolicy
end

VolumeManage.DefaultDriveCachePolicy = TDefaultDriveCachePolicy

---@class VolumeManage.SupportedDriveCachePolicyList
---@field SupportedDriveCachePolicyList string[]
local TSupportedDriveCachePolicyList = {}
TSupportedDriveCachePolicyList.__index = TSupportedDriveCachePolicyList
TSupportedDriveCachePolicyList.group = {}

local function TSupportedDriveCachePolicyList_from_obj(obj)
    return setmetatable(obj, TSupportedDriveCachePolicyList)
end

function TSupportedDriveCachePolicyList.new(SupportedDriveCachePolicyList)
    return TSupportedDriveCachePolicyList_from_obj({SupportedDriveCachePolicyList = SupportedDriveCachePolicyList})
end
---@param obj VolumeManage.SupportedDriveCachePolicyList
function TSupportedDriveCachePolicyList:init_from_obj(obj)
    self.SupportedDriveCachePolicyList = obj.SupportedDriveCachePolicyList
end

function TSupportedDriveCachePolicyList:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSupportedDriveCachePolicyList.group)
end

TSupportedDriveCachePolicyList.from_obj = TSupportedDriveCachePolicyList_from_obj

TSupportedDriveCachePolicyList.proto_property = {'SupportedDriveCachePolicyList'}

TSupportedDriveCachePolicyList.default = {{}}

TSupportedDriveCachePolicyList.struct = {{name = 'SupportedDriveCachePolicyList', is_array = true, struct = nil}}

function TSupportedDriveCachePolicyList:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'SupportedDriveCachePolicyList', self.SupportedDriveCachePolicyList, 'string',
        true, errs, need_convert)

    TSupportedDriveCachePolicyList:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSupportedDriveCachePolicyList.proto_property, errs, need_convert)
    return self
end

function TSupportedDriveCachePolicyList:unpack(_)
    return self.SupportedDriveCachePolicyList
end

VolumeManage.SupportedDriveCachePolicyList = TSupportedDriveCachePolicyList

---@class VolumeManage.AccessPolicyWritable
---@field AccessPolicyWritable boolean
local TAccessPolicyWritable = {}
TAccessPolicyWritable.__index = TAccessPolicyWritable
TAccessPolicyWritable.group = {}

local function TAccessPolicyWritable_from_obj(obj)
    return setmetatable(obj, TAccessPolicyWritable)
end

function TAccessPolicyWritable.new(AccessPolicyWritable)
    return TAccessPolicyWritable_from_obj({AccessPolicyWritable = AccessPolicyWritable})
end
---@param obj VolumeManage.AccessPolicyWritable
function TAccessPolicyWritable:init_from_obj(obj)
    self.AccessPolicyWritable = obj.AccessPolicyWritable
end

function TAccessPolicyWritable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAccessPolicyWritable.group)
end

TAccessPolicyWritable.from_obj = TAccessPolicyWritable_from_obj

TAccessPolicyWritable.proto_property = {'AccessPolicyWritable'}

TAccessPolicyWritable.default = {false}

TAccessPolicyWritable.struct = {{name = 'AccessPolicyWritable', is_array = false, struct = nil}}

function TAccessPolicyWritable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AccessPolicyWritable', self.AccessPolicyWritable, 'bool', true, errs, need_convert)

    TAccessPolicyWritable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAccessPolicyWritable.proto_property, errs, need_convert)
    return self
end

function TAccessPolicyWritable:unpack(_)
    return self.AccessPolicyWritable
end

VolumeManage.AccessPolicyWritable = TAccessPolicyWritable

---@class VolumeManage.DefaultAccessPolicy
---@field DefaultAccessPolicy string
local TDefaultAccessPolicy = {}
TDefaultAccessPolicy.__index = TDefaultAccessPolicy
TDefaultAccessPolicy.group = {}

local function TDefaultAccessPolicy_from_obj(obj)
    return setmetatable(obj, TDefaultAccessPolicy)
end

function TDefaultAccessPolicy.new(DefaultAccessPolicy)
    return TDefaultAccessPolicy_from_obj({DefaultAccessPolicy = DefaultAccessPolicy})
end
---@param obj VolumeManage.DefaultAccessPolicy
function TDefaultAccessPolicy:init_from_obj(obj)
    self.DefaultAccessPolicy = obj.DefaultAccessPolicy
end

function TDefaultAccessPolicy:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDefaultAccessPolicy.group)
end

TDefaultAccessPolicy.from_obj = TDefaultAccessPolicy_from_obj

TDefaultAccessPolicy.proto_property = {'DefaultAccessPolicy'}

TDefaultAccessPolicy.default = {''}

TDefaultAccessPolicy.struct = {{name = 'DefaultAccessPolicy', is_array = false, struct = nil}}

function TDefaultAccessPolicy:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DefaultAccessPolicy', self.DefaultAccessPolicy, 'string', true, errs, need_convert)

    TDefaultAccessPolicy:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDefaultAccessPolicy.proto_property, errs, need_convert)
    return self
end

function TDefaultAccessPolicy:unpack(_)
    return self.DefaultAccessPolicy
end

VolumeManage.DefaultAccessPolicy = TDefaultAccessPolicy

---@class VolumeManage.SupportedAccessPolicyList
---@field SupportedAccessPolicyList string[]
local TSupportedAccessPolicyList = {}
TSupportedAccessPolicyList.__index = TSupportedAccessPolicyList
TSupportedAccessPolicyList.group = {}

local function TSupportedAccessPolicyList_from_obj(obj)
    return setmetatable(obj, TSupportedAccessPolicyList)
end

function TSupportedAccessPolicyList.new(SupportedAccessPolicyList)
    return TSupportedAccessPolicyList_from_obj({SupportedAccessPolicyList = SupportedAccessPolicyList})
end
---@param obj VolumeManage.SupportedAccessPolicyList
function TSupportedAccessPolicyList:init_from_obj(obj)
    self.SupportedAccessPolicyList = obj.SupportedAccessPolicyList
end

function TSupportedAccessPolicyList:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSupportedAccessPolicyList.group)
end

TSupportedAccessPolicyList.from_obj = TSupportedAccessPolicyList_from_obj

TSupportedAccessPolicyList.proto_property = {'SupportedAccessPolicyList'}

TSupportedAccessPolicyList.default = {{}}

TSupportedAccessPolicyList.struct = {{name = 'SupportedAccessPolicyList', is_array = true, struct = nil}}

function TSupportedAccessPolicyList:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'SupportedAccessPolicyList', self.SupportedAccessPolicyList, 'string', true, errs,
        need_convert)

    TSupportedAccessPolicyList:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSupportedAccessPolicyList.proto_property, errs, need_convert)
    return self
end

function TSupportedAccessPolicyList:unpack(_)
    return self.SupportedAccessPolicyList
end

VolumeManage.SupportedAccessPolicyList = TSupportedAccessPolicyList

---@class VolumeManage.IOPolicyWritable
---@field IOPolicyWritable boolean
local TIOPolicyWritable = {}
TIOPolicyWritable.__index = TIOPolicyWritable
TIOPolicyWritable.group = {}

local function TIOPolicyWritable_from_obj(obj)
    return setmetatable(obj, TIOPolicyWritable)
end

function TIOPolicyWritable.new(IOPolicyWritable)
    return TIOPolicyWritable_from_obj({IOPolicyWritable = IOPolicyWritable})
end
---@param obj VolumeManage.IOPolicyWritable
function TIOPolicyWritable:init_from_obj(obj)
    self.IOPolicyWritable = obj.IOPolicyWritable
end

function TIOPolicyWritable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIOPolicyWritable.group)
end

TIOPolicyWritable.from_obj = TIOPolicyWritable_from_obj

TIOPolicyWritable.proto_property = {'IOPolicyWritable'}

TIOPolicyWritable.default = {false}

TIOPolicyWritable.struct = {{name = 'IOPolicyWritable', is_array = false, struct = nil}}

function TIOPolicyWritable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IOPolicyWritable', self.IOPolicyWritable, 'bool', true, errs, need_convert)

    TIOPolicyWritable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIOPolicyWritable.proto_property, errs, need_convert)
    return self
end

function TIOPolicyWritable:unpack(_)
    return self.IOPolicyWritable
end

VolumeManage.IOPolicyWritable = TIOPolicyWritable

---@class VolumeManage.DefaultIOPolicy
---@field DefaultIOPolicy string
local TDefaultIOPolicy = {}
TDefaultIOPolicy.__index = TDefaultIOPolicy
TDefaultIOPolicy.group = {}

local function TDefaultIOPolicy_from_obj(obj)
    return setmetatable(obj, TDefaultIOPolicy)
end

function TDefaultIOPolicy.new(DefaultIOPolicy)
    return TDefaultIOPolicy_from_obj({DefaultIOPolicy = DefaultIOPolicy})
end
---@param obj VolumeManage.DefaultIOPolicy
function TDefaultIOPolicy:init_from_obj(obj)
    self.DefaultIOPolicy = obj.DefaultIOPolicy
end

function TDefaultIOPolicy:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDefaultIOPolicy.group)
end

TDefaultIOPolicy.from_obj = TDefaultIOPolicy_from_obj

TDefaultIOPolicy.proto_property = {'DefaultIOPolicy'}

TDefaultIOPolicy.default = {''}

TDefaultIOPolicy.struct = {{name = 'DefaultIOPolicy', is_array = false, struct = nil}}

function TDefaultIOPolicy:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DefaultIOPolicy', self.DefaultIOPolicy, 'string', true, errs, need_convert)

    TDefaultIOPolicy:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDefaultIOPolicy.proto_property, errs, need_convert)
    return self
end

function TDefaultIOPolicy:unpack(_)
    return self.DefaultIOPolicy
end

VolumeManage.DefaultIOPolicy = TDefaultIOPolicy

---@class VolumeManage.SupportedIOPolicyList
---@field SupportedIOPolicyList string[]
local TSupportedIOPolicyList = {}
TSupportedIOPolicyList.__index = TSupportedIOPolicyList
TSupportedIOPolicyList.group = {}

local function TSupportedIOPolicyList_from_obj(obj)
    return setmetatable(obj, TSupportedIOPolicyList)
end

function TSupportedIOPolicyList.new(SupportedIOPolicyList)
    return TSupportedIOPolicyList_from_obj({SupportedIOPolicyList = SupportedIOPolicyList})
end
---@param obj VolumeManage.SupportedIOPolicyList
function TSupportedIOPolicyList:init_from_obj(obj)
    self.SupportedIOPolicyList = obj.SupportedIOPolicyList
end

function TSupportedIOPolicyList:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSupportedIOPolicyList.group)
end

TSupportedIOPolicyList.from_obj = TSupportedIOPolicyList_from_obj

TSupportedIOPolicyList.proto_property = {'SupportedIOPolicyList'}

TSupportedIOPolicyList.default = {{}}

TSupportedIOPolicyList.struct = {{name = 'SupportedIOPolicyList', is_array = true, struct = nil}}

function TSupportedIOPolicyList:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'SupportedIOPolicyList', self.SupportedIOPolicyList, 'string', true, errs,
        need_convert)

    TSupportedIOPolicyList:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSupportedIOPolicyList.proto_property, errs, need_convert)
    return self
end

function TSupportedIOPolicyList:unpack(_)
    return self.SupportedIOPolicyList
end

VolumeManage.SupportedIOPolicyList = TSupportedIOPolicyList

---@class VolumeManage.WritePolicyWritable
---@field WritePolicyWritable boolean
local TWritePolicyWritable = {}
TWritePolicyWritable.__index = TWritePolicyWritable
TWritePolicyWritable.group = {}

local function TWritePolicyWritable_from_obj(obj)
    return setmetatable(obj, TWritePolicyWritable)
end

function TWritePolicyWritable.new(WritePolicyWritable)
    return TWritePolicyWritable_from_obj({WritePolicyWritable = WritePolicyWritable})
end
---@param obj VolumeManage.WritePolicyWritable
function TWritePolicyWritable:init_from_obj(obj)
    self.WritePolicyWritable = obj.WritePolicyWritable
end

function TWritePolicyWritable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWritePolicyWritable.group)
end

TWritePolicyWritable.from_obj = TWritePolicyWritable_from_obj

TWritePolicyWritable.proto_property = {'WritePolicyWritable'}

TWritePolicyWritable.default = {false}

TWritePolicyWritable.struct = {{name = 'WritePolicyWritable', is_array = false, struct = nil}}

function TWritePolicyWritable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'WritePolicyWritable', self.WritePolicyWritable, 'bool', true, errs, need_convert)

    TWritePolicyWritable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWritePolicyWritable.proto_property, errs, need_convert)
    return self
end

function TWritePolicyWritable:unpack(_)
    return self.WritePolicyWritable
end

VolumeManage.WritePolicyWritable = TWritePolicyWritable

---@class VolumeManage.DefaultWritePolicy
---@field DefaultWritePolicy string
local TDefaultWritePolicy = {}
TDefaultWritePolicy.__index = TDefaultWritePolicy
TDefaultWritePolicy.group = {}

local function TDefaultWritePolicy_from_obj(obj)
    return setmetatable(obj, TDefaultWritePolicy)
end

function TDefaultWritePolicy.new(DefaultWritePolicy)
    return TDefaultWritePolicy_from_obj({DefaultWritePolicy = DefaultWritePolicy})
end
---@param obj VolumeManage.DefaultWritePolicy
function TDefaultWritePolicy:init_from_obj(obj)
    self.DefaultWritePolicy = obj.DefaultWritePolicy
end

function TDefaultWritePolicy:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDefaultWritePolicy.group)
end

TDefaultWritePolicy.from_obj = TDefaultWritePolicy_from_obj

TDefaultWritePolicy.proto_property = {'DefaultWritePolicy'}

TDefaultWritePolicy.default = {''}

TDefaultWritePolicy.struct = {{name = 'DefaultWritePolicy', is_array = false, struct = nil}}

function TDefaultWritePolicy:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DefaultWritePolicy', self.DefaultWritePolicy, 'string', true, errs, need_convert)

    TDefaultWritePolicy:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDefaultWritePolicy.proto_property, errs, need_convert)
    return self
end

function TDefaultWritePolicy:unpack(_)
    return self.DefaultWritePolicy
end

VolumeManage.DefaultWritePolicy = TDefaultWritePolicy

---@class VolumeManage.SupportedWritePolicyList
---@field SupportedWritePolicyList string[]
local TSupportedWritePolicyList = {}
TSupportedWritePolicyList.__index = TSupportedWritePolicyList
TSupportedWritePolicyList.group = {}

local function TSupportedWritePolicyList_from_obj(obj)
    return setmetatable(obj, TSupportedWritePolicyList)
end

function TSupportedWritePolicyList.new(SupportedWritePolicyList)
    return TSupportedWritePolicyList_from_obj({SupportedWritePolicyList = SupportedWritePolicyList})
end
---@param obj VolumeManage.SupportedWritePolicyList
function TSupportedWritePolicyList:init_from_obj(obj)
    self.SupportedWritePolicyList = obj.SupportedWritePolicyList
end

function TSupportedWritePolicyList:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSupportedWritePolicyList.group)
end

TSupportedWritePolicyList.from_obj = TSupportedWritePolicyList_from_obj

TSupportedWritePolicyList.proto_property = {'SupportedWritePolicyList'}

TSupportedWritePolicyList.default = {{}}

TSupportedWritePolicyList.struct = {{name = 'SupportedWritePolicyList', is_array = true, struct = nil}}

function TSupportedWritePolicyList:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'SupportedWritePolicyList', self.SupportedWritePolicyList, 'string', true, errs,
        need_convert)

    TSupportedWritePolicyList:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSupportedWritePolicyList.proto_property, errs, need_convert)
    return self
end

function TSupportedWritePolicyList:unpack(_)
    return self.SupportedWritePolicyList
end

VolumeManage.SupportedWritePolicyList = TSupportedWritePolicyList

---@class VolumeManage.ReadPolicyWritable
---@field ReadPolicyWritable boolean
local TReadPolicyWritable = {}
TReadPolicyWritable.__index = TReadPolicyWritable
TReadPolicyWritable.group = {}

local function TReadPolicyWritable_from_obj(obj)
    return setmetatable(obj, TReadPolicyWritable)
end

function TReadPolicyWritable.new(ReadPolicyWritable)
    return TReadPolicyWritable_from_obj({ReadPolicyWritable = ReadPolicyWritable})
end
---@param obj VolumeManage.ReadPolicyWritable
function TReadPolicyWritable:init_from_obj(obj)
    self.ReadPolicyWritable = obj.ReadPolicyWritable
end

function TReadPolicyWritable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadPolicyWritable.group)
end

TReadPolicyWritable.from_obj = TReadPolicyWritable_from_obj

TReadPolicyWritable.proto_property = {'ReadPolicyWritable'}

TReadPolicyWritable.default = {false}

TReadPolicyWritable.struct = {{name = 'ReadPolicyWritable', is_array = false, struct = nil}}

function TReadPolicyWritable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReadPolicyWritable', self.ReadPolicyWritable, 'bool', true, errs, need_convert)

    TReadPolicyWritable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadPolicyWritable.proto_property, errs, need_convert)
    return self
end

function TReadPolicyWritable:unpack(_)
    return self.ReadPolicyWritable
end

VolumeManage.ReadPolicyWritable = TReadPolicyWritable

---@class VolumeManage.DefaultReadPolicy
---@field DefaultReadPolicy string
local TDefaultReadPolicy = {}
TDefaultReadPolicy.__index = TDefaultReadPolicy
TDefaultReadPolicy.group = {}

local function TDefaultReadPolicy_from_obj(obj)
    return setmetatable(obj, TDefaultReadPolicy)
end

function TDefaultReadPolicy.new(DefaultReadPolicy)
    return TDefaultReadPolicy_from_obj({DefaultReadPolicy = DefaultReadPolicy})
end
---@param obj VolumeManage.DefaultReadPolicy
function TDefaultReadPolicy:init_from_obj(obj)
    self.DefaultReadPolicy = obj.DefaultReadPolicy
end

function TDefaultReadPolicy:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDefaultReadPolicy.group)
end

TDefaultReadPolicy.from_obj = TDefaultReadPolicy_from_obj

TDefaultReadPolicy.proto_property = {'DefaultReadPolicy'}

TDefaultReadPolicy.default = {''}

TDefaultReadPolicy.struct = {{name = 'DefaultReadPolicy', is_array = false, struct = nil}}

function TDefaultReadPolicy:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DefaultReadPolicy', self.DefaultReadPolicy, 'string', true, errs, need_convert)

    TDefaultReadPolicy:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDefaultReadPolicy.proto_property, errs, need_convert)
    return self
end

function TDefaultReadPolicy:unpack(_)
    return self.DefaultReadPolicy
end

VolumeManage.DefaultReadPolicy = TDefaultReadPolicy

---@class VolumeManage.SupportedReadPolicyList
---@field SupportedReadPolicyList string[]
local TSupportedReadPolicyList = {}
TSupportedReadPolicyList.__index = TSupportedReadPolicyList
TSupportedReadPolicyList.group = {}

local function TSupportedReadPolicyList_from_obj(obj)
    return setmetatable(obj, TSupportedReadPolicyList)
end

function TSupportedReadPolicyList.new(SupportedReadPolicyList)
    return TSupportedReadPolicyList_from_obj({SupportedReadPolicyList = SupportedReadPolicyList})
end
---@param obj VolumeManage.SupportedReadPolicyList
function TSupportedReadPolicyList:init_from_obj(obj)
    self.SupportedReadPolicyList = obj.SupportedReadPolicyList
end

function TSupportedReadPolicyList:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSupportedReadPolicyList.group)
end

TSupportedReadPolicyList.from_obj = TSupportedReadPolicyList_from_obj

TSupportedReadPolicyList.proto_property = {'SupportedReadPolicyList'}

TSupportedReadPolicyList.default = {{}}

TSupportedReadPolicyList.struct = {{name = 'SupportedReadPolicyList', is_array = true, struct = nil}}

function TSupportedReadPolicyList:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'SupportedReadPolicyList', self.SupportedReadPolicyList, 'string', true, errs,
        need_convert)

    TSupportedReadPolicyList:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSupportedReadPolicyList.proto_property, errs, need_convert)
    return self
end

function TSupportedReadPolicyList:unpack(_)
    return self.SupportedReadPolicyList
end

VolumeManage.SupportedReadPolicyList = TSupportedReadPolicyList

---@class VolumeManage.CreateVolumeSupported
---@field CreateVolumeSupported boolean
local TCreateVolumeSupported = {}
TCreateVolumeSupported.__index = TCreateVolumeSupported
TCreateVolumeSupported.group = {}

local function TCreateVolumeSupported_from_obj(obj)
    return setmetatable(obj, TCreateVolumeSupported)
end

function TCreateVolumeSupported.new(CreateVolumeSupported)
    return TCreateVolumeSupported_from_obj({CreateVolumeSupported = CreateVolumeSupported})
end
---@param obj VolumeManage.CreateVolumeSupported
function TCreateVolumeSupported:init_from_obj(obj)
    self.CreateVolumeSupported = obj.CreateVolumeSupported
end

function TCreateVolumeSupported:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCreateVolumeSupported.group)
end

TCreateVolumeSupported.from_obj = TCreateVolumeSupported_from_obj

TCreateVolumeSupported.proto_property = {'CreateVolumeSupported'}

TCreateVolumeSupported.default = {false}

TCreateVolumeSupported.struct = {{name = 'CreateVolumeSupported', is_array = false, struct = nil}}

function TCreateVolumeSupported:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CreateVolumeSupported', self.CreateVolumeSupported, 'bool', true, errs, need_convert)

    TCreateVolumeSupported:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCreateVolumeSupported.proto_property, errs, need_convert)
    return self
end

function TCreateVolumeSupported:unpack(_)
    return self.CreateVolumeSupported
end

VolumeManage.CreateVolumeSupported = TCreateVolumeSupported

---@class VolumeManage.CreateCachecadeVolumeRsp
---@field TaskId integer
local TCreateCachecadeVolumeRsp = {}
TCreateCachecadeVolumeRsp.__index = TCreateCachecadeVolumeRsp
TCreateCachecadeVolumeRsp.group = {}

local function TCreateCachecadeVolumeRsp_from_obj(obj)
    return setmetatable(obj, TCreateCachecadeVolumeRsp)
end

function TCreateCachecadeVolumeRsp.new(TaskId)
    return TCreateCachecadeVolumeRsp_from_obj({TaskId = TaskId})
end
---@param obj VolumeManage.CreateCachecadeVolumeRsp
function TCreateCachecadeVolumeRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TCreateCachecadeVolumeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCreateCachecadeVolumeRsp.group)
end

TCreateCachecadeVolumeRsp.from_obj = TCreateCachecadeVolumeRsp_from_obj

TCreateCachecadeVolumeRsp.proto_property = {'TaskId'}

TCreateCachecadeVolumeRsp.default = {0}

TCreateCachecadeVolumeRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TCreateCachecadeVolumeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TCreateCachecadeVolumeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCreateCachecadeVolumeRsp.proto_property, errs, need_convert)
    return self
end

function TCreateCachecadeVolumeRsp:unpack(_)
    return self.TaskId
end

VolumeManage.CreateCachecadeVolumeRsp = TCreateCachecadeVolumeRsp

---@class VolumeManage.CreateCachecadeVolumeReq
---@field DriveLists integer[]
---@field RaidType integer
---@field Name string
---@field WritePolicy integer
---@field ArrayId integer
---@field Capacity integer
---@field CapacityUnit integer
---@field AssociateLd integer
---@field CacheLineSize integer
local TCreateCachecadeVolumeReq = {}
TCreateCachecadeVolumeReq.__index = TCreateCachecadeVolumeReq
TCreateCachecadeVolumeReq.group = {}

local function TCreateCachecadeVolumeReq_from_obj(obj)
    return setmetatable(obj, TCreateCachecadeVolumeReq)
end

function TCreateCachecadeVolumeReq.new(DriveLists, RaidType, Name, WritePolicy, ArrayId, Capacity, CapacityUnit,
    AssociateLd, CacheLineSize)
    return TCreateCachecadeVolumeReq_from_obj({
        DriveLists = DriveLists,
        RaidType = RaidType,
        Name = Name,
        WritePolicy = WritePolicy,
        ArrayId = ArrayId,
        Capacity = Capacity,
        CapacityUnit = CapacityUnit,
        AssociateLd = AssociateLd,
        CacheLineSize = CacheLineSize
    })
end
---@param obj VolumeManage.CreateCachecadeVolumeReq
function TCreateCachecadeVolumeReq:init_from_obj(obj)
    self.DriveLists = obj.DriveLists
    self.RaidType = obj.RaidType
    self.Name = obj.Name
    self.WritePolicy = obj.WritePolicy
    self.ArrayId = obj.ArrayId
    self.Capacity = obj.Capacity
    self.CapacityUnit = obj.CapacityUnit
    self.AssociateLd = obj.AssociateLd
    self.CacheLineSize = obj.CacheLineSize
end

function TCreateCachecadeVolumeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCreateCachecadeVolumeReq.group)
end

TCreateCachecadeVolumeReq.from_obj = TCreateCachecadeVolumeReq_from_obj

TCreateCachecadeVolumeReq.proto_property = {
    'DriveLists', 'RaidType', 'Name', 'WritePolicy', 'ArrayId', 'Capacity', 'CapacityUnit', 'AssociateLd',
    'CacheLineSize'
}

TCreateCachecadeVolumeReq.default = {{}, 0, '', 0, 0, 0, 0, 0, 0}

TCreateCachecadeVolumeReq.struct = {
    {name = 'DriveLists', is_array = true, struct = nil}, {name = 'RaidType', is_array = false, struct = nil},
    {name = 'Name', is_array = false, struct = nil}, {name = 'WritePolicy', is_array = false, struct = nil},
    {name = 'ArrayId', is_array = false, struct = nil}, {name = 'Capacity', is_array = false, struct = nil},
    {name = 'CapacityUnit', is_array = false, struct = nil}, {name = 'AssociateLd', is_array = false, struct = nil},
    {name = 'CacheLineSize', is_array = false, struct = nil}
}

function TCreateCachecadeVolumeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'DriveLists', self.DriveLists, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RaidType', self.RaidType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Name', self.Name, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'WritePolicy', self.WritePolicy, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ArrayId', self.ArrayId, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Capacity', self.Capacity, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'CapacityUnit', self.CapacityUnit, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AssociateLd', self.AssociateLd, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'CacheLineSize', self.CacheLineSize, 'uint8', false, errs, need_convert)

    TCreateCachecadeVolumeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCreateCachecadeVolumeReq.proto_property, errs, need_convert)
    return self
end

function TCreateCachecadeVolumeReq:unpack(_)
    return self.DriveLists, self.RaidType, self.Name, self.WritePolicy, self.ArrayId, self.Capacity, self.CapacityUnit,
        self.AssociateLd, self.CacheLineSize
end

VolumeManage.CreateCachecadeVolumeReq = TCreateCachecadeVolumeReq

---@class VolumeManage.CreateVolumeInExisingtArrayRsp
---@field TaskId integer
local TCreateVolumeInExisingtArrayRsp = {}
TCreateVolumeInExisingtArrayRsp.__index = TCreateVolumeInExisingtArrayRsp
TCreateVolumeInExisingtArrayRsp.group = {}

local function TCreateVolumeInExisingtArrayRsp_from_obj(obj)
    return setmetatable(obj, TCreateVolumeInExisingtArrayRsp)
end

function TCreateVolumeInExisingtArrayRsp.new(TaskId)
    return TCreateVolumeInExisingtArrayRsp_from_obj({TaskId = TaskId})
end
---@param obj VolumeManage.CreateVolumeInExisingtArrayRsp
function TCreateVolumeInExisingtArrayRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TCreateVolumeInExisingtArrayRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCreateVolumeInExisingtArrayRsp.group)
end

TCreateVolumeInExisingtArrayRsp.from_obj = TCreateVolumeInExisingtArrayRsp_from_obj

TCreateVolumeInExisingtArrayRsp.proto_property = {'TaskId'}

TCreateVolumeInExisingtArrayRsp.default = {0}

TCreateVolumeInExisingtArrayRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TCreateVolumeInExisingtArrayRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TCreateVolumeInExisingtArrayRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCreateVolumeInExisingtArrayRsp.proto_property, errs, need_convert)
    return self
end

function TCreateVolumeInExisingtArrayRsp:unpack(_)
    return self.TaskId
end

VolumeManage.CreateVolumeInExisingtArrayRsp = TCreateVolumeInExisingtArrayRsp

---@class VolumeManage.CreateVolumeInExisingtArrayReq
---@field ArrayId integer
---@field BlockIndex integer
---@field RaidType integer
---@field SpanDepth integer
---@field Name string
---@field Capacity integer
---@field CapacityUnit integer
---@field StripSize integer
---@field ReadPolicy integer
---@field WritePolicy integer
---@field IOPolicy integer
---@field AccessPolicy integer
---@field DiskCachePolicy integer
---@field InitType integer
---@field Accelerator integer
local TCreateVolumeInExisingtArrayReq = {}
TCreateVolumeInExisingtArrayReq.__index = TCreateVolumeInExisingtArrayReq
TCreateVolumeInExisingtArrayReq.group = {}

local function TCreateVolumeInExisingtArrayReq_from_obj(obj)
    return setmetatable(obj, TCreateVolumeInExisingtArrayReq)
end

function TCreateVolumeInExisingtArrayReq.new(ArrayId, BlockIndex, RaidType, SpanDepth, Name, Capacity, CapacityUnit,
    StripSize, ReadPolicy, WritePolicy, IOPolicy, AccessPolicy, DiskCachePolicy, InitType, Accelerator)
    return TCreateVolumeInExisingtArrayReq_from_obj({
        ArrayId = ArrayId,
        BlockIndex = BlockIndex,
        RaidType = RaidType,
        SpanDepth = SpanDepth,
        Name = Name,
        Capacity = Capacity,
        CapacityUnit = CapacityUnit,
        StripSize = StripSize,
        ReadPolicy = ReadPolicy,
        WritePolicy = WritePolicy,
        IOPolicy = IOPolicy,
        AccessPolicy = AccessPolicy,
        DiskCachePolicy = DiskCachePolicy,
        InitType = InitType,
        Accelerator = Accelerator
    })
end
---@param obj VolumeManage.CreateVolumeInExisingtArrayReq
function TCreateVolumeInExisingtArrayReq:init_from_obj(obj)
    self.ArrayId = obj.ArrayId
    self.BlockIndex = obj.BlockIndex
    self.RaidType = obj.RaidType
    self.SpanDepth = obj.SpanDepth
    self.Name = obj.Name
    self.Capacity = obj.Capacity
    self.CapacityUnit = obj.CapacityUnit
    self.StripSize = obj.StripSize
    self.ReadPolicy = obj.ReadPolicy
    self.WritePolicy = obj.WritePolicy
    self.IOPolicy = obj.IOPolicy
    self.AccessPolicy = obj.AccessPolicy
    self.DiskCachePolicy = obj.DiskCachePolicy
    self.InitType = obj.InitType
    self.Accelerator = obj.Accelerator
end

function TCreateVolumeInExisingtArrayReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCreateVolumeInExisingtArrayReq.group)
end

TCreateVolumeInExisingtArrayReq.from_obj = TCreateVolumeInExisingtArrayReq_from_obj

TCreateVolumeInExisingtArrayReq.proto_property = {
    'ArrayId', 'BlockIndex', 'RaidType', 'SpanDepth', 'Name', 'Capacity', 'CapacityUnit', 'StripSize', 'ReadPolicy',
    'WritePolicy', 'IOPolicy', 'AccessPolicy', 'DiskCachePolicy', 'InitType', 'Accelerator'
}

TCreateVolumeInExisingtArrayReq.default = {0, 0, 0, 0, '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}

TCreateVolumeInExisingtArrayReq.struct = {
    {name = 'ArrayId', is_array = false, struct = nil}, {name = 'BlockIndex', is_array = false, struct = nil},
    {name = 'RaidType', is_array = false, struct = nil}, {name = 'SpanDepth', is_array = false, struct = nil},
    {name = 'Name', is_array = false, struct = nil}, {name = 'Capacity', is_array = false, struct = nil},
    {name = 'CapacityUnit', is_array = false, struct = nil}, {name = 'StripSize', is_array = false, struct = nil},
    {name = 'ReadPolicy', is_array = false, struct = nil}, {name = 'WritePolicy', is_array = false, struct = nil},
    {name = 'IOPolicy', is_array = false, struct = nil}, {name = 'AccessPolicy', is_array = false, struct = nil},
    {name = 'DiskCachePolicy', is_array = false, struct = nil}, {name = 'InitType', is_array = false, struct = nil},
    {name = 'Accelerator', is_array = false, struct = nil}
}

function TCreateVolumeInExisingtArrayReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ArrayId', self.ArrayId, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'BlockIndex', self.BlockIndex, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RaidType', self.RaidType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SpanDepth', self.SpanDepth, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Name', self.Name, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Capacity', self.Capacity, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'CapacityUnit', self.CapacityUnit, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'StripSize', self.StripSize, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadPolicy', self.ReadPolicy, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'WritePolicy', self.WritePolicy, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'IOPolicy', self.IOPolicy, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AccessPolicy', self.AccessPolicy, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DiskCachePolicy', self.DiskCachePolicy, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'InitType', self.InitType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Accelerator', self.Accelerator, 'uint8', false, errs, need_convert)

    TCreateVolumeInExisingtArrayReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCreateVolumeInExisingtArrayReq.proto_property, errs, need_convert)
    return self
end

function TCreateVolumeInExisingtArrayReq:unpack(_)
    return self.ArrayId, self.BlockIndex, self.RaidType, self.SpanDepth, self.Name, self.Capacity, self.CapacityUnit,
        self.StripSize, self.ReadPolicy, self.WritePolicy, self.IOPolicy, self.AccessPolicy, self.DiskCachePolicy,
        self.InitType, self.Accelerator
end

VolumeManage.CreateVolumeInExisingtArrayReq = TCreateVolumeInExisingtArrayReq

---@class VolumeManage.DeleteVolumeRsp
---@field TaskId integer
local TDeleteVolumeRsp = {}
TDeleteVolumeRsp.__index = TDeleteVolumeRsp
TDeleteVolumeRsp.group = {}

local function TDeleteVolumeRsp_from_obj(obj)
    return setmetatable(obj, TDeleteVolumeRsp)
end

function TDeleteVolumeRsp.new(TaskId)
    return TDeleteVolumeRsp_from_obj({TaskId = TaskId})
end
---@param obj VolumeManage.DeleteVolumeRsp
function TDeleteVolumeRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TDeleteVolumeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteVolumeRsp.group)
end

TDeleteVolumeRsp.from_obj = TDeleteVolumeRsp_from_obj

TDeleteVolumeRsp.proto_property = {'TaskId'}

TDeleteVolumeRsp.default = {0}

TDeleteVolumeRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TDeleteVolumeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TDeleteVolumeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteVolumeRsp.proto_property, errs, need_convert)
    return self
end

function TDeleteVolumeRsp:unpack(_)
    return self.TaskId
end

VolumeManage.DeleteVolumeRsp = TDeleteVolumeRsp

---@class VolumeManage.DeleteVolumeReq
---@field VolumeId integer
local TDeleteVolumeReq = {}
TDeleteVolumeReq.__index = TDeleteVolumeReq
TDeleteVolumeReq.group = {}

local function TDeleteVolumeReq_from_obj(obj)
    return setmetatable(obj, TDeleteVolumeReq)
end

function TDeleteVolumeReq.new(VolumeId)
    return TDeleteVolumeReq_from_obj({VolumeId = VolumeId})
end
---@param obj VolumeManage.DeleteVolumeReq
function TDeleteVolumeReq:init_from_obj(obj)
    self.VolumeId = obj.VolumeId
end

function TDeleteVolumeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteVolumeReq.group)
end

TDeleteVolumeReq.from_obj = TDeleteVolumeReq_from_obj

TDeleteVolumeReq.proto_property = {'VolumeId'}

TDeleteVolumeReq.default = {0}

TDeleteVolumeReq.struct = {{name = 'VolumeId', is_array = false, struct = nil}}

function TDeleteVolumeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VolumeId', self.VolumeId, 'uint16', false, errs, need_convert)

    TDeleteVolumeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteVolumeReq.proto_property, errs, need_convert)
    return self
end

function TDeleteVolumeReq:unpack(_)
    return self.VolumeId
end

VolumeManage.DeleteVolumeReq = TDeleteVolumeReq

---@class VolumeManage.CreateVolumeInNewArrayRsp
---@field TaskId integer
local TCreateVolumeInNewArrayRsp = {}
TCreateVolumeInNewArrayRsp.__index = TCreateVolumeInNewArrayRsp
TCreateVolumeInNewArrayRsp.group = {}

local function TCreateVolumeInNewArrayRsp_from_obj(obj)
    return setmetatable(obj, TCreateVolumeInNewArrayRsp)
end

function TCreateVolumeInNewArrayRsp.new(TaskId)
    return TCreateVolumeInNewArrayRsp_from_obj({TaskId = TaskId})
end
---@param obj VolumeManage.CreateVolumeInNewArrayRsp
function TCreateVolumeInNewArrayRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TCreateVolumeInNewArrayRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCreateVolumeInNewArrayRsp.group)
end

TCreateVolumeInNewArrayRsp.from_obj = TCreateVolumeInNewArrayRsp_from_obj

TCreateVolumeInNewArrayRsp.proto_property = {'TaskId'}

TCreateVolumeInNewArrayRsp.default = {0}

TCreateVolumeInNewArrayRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TCreateVolumeInNewArrayRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TCreateVolumeInNewArrayRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCreateVolumeInNewArrayRsp.proto_property, errs, need_convert)
    return self
end

function TCreateVolumeInNewArrayRsp:unpack(_)
    return self.TaskId
end

VolumeManage.CreateVolumeInNewArrayRsp = TCreateVolumeInNewArrayRsp

---@class VolumeManage.CreateVolumeInNewArrayReq
---@field DriveLists integer[]
---@field RaidType integer
---@field SpanDepth integer
---@field Name string
---@field Capacity integer
---@field CapacityUnit integer
---@field StripSize integer
---@field ReadPolicy integer
---@field WritePolicy integer
---@field IOPolicy integer
---@field AccessPolicy integer
---@field DiskCachePolicy integer
---@field InitType integer
---@field Accelerator integer
local TCreateVolumeInNewArrayReq = {}
TCreateVolumeInNewArrayReq.__index = TCreateVolumeInNewArrayReq
TCreateVolumeInNewArrayReq.group = {}

local function TCreateVolumeInNewArrayReq_from_obj(obj)
    return setmetatable(obj, TCreateVolumeInNewArrayReq)
end

function TCreateVolumeInNewArrayReq.new(DriveLists, RaidType, SpanDepth, Name, Capacity, CapacityUnit, StripSize,
    ReadPolicy, WritePolicy, IOPolicy, AccessPolicy, DiskCachePolicy, InitType, Accelerator)
    return TCreateVolumeInNewArrayReq_from_obj({
        DriveLists = DriveLists,
        RaidType = RaidType,
        SpanDepth = SpanDepth,
        Name = Name,
        Capacity = Capacity,
        CapacityUnit = CapacityUnit,
        StripSize = StripSize,
        ReadPolicy = ReadPolicy,
        WritePolicy = WritePolicy,
        IOPolicy = IOPolicy,
        AccessPolicy = AccessPolicy,
        DiskCachePolicy = DiskCachePolicy,
        InitType = InitType,
        Accelerator = Accelerator
    })
end
---@param obj VolumeManage.CreateVolumeInNewArrayReq
function TCreateVolumeInNewArrayReq:init_from_obj(obj)
    self.DriveLists = obj.DriveLists
    self.RaidType = obj.RaidType
    self.SpanDepth = obj.SpanDepth
    self.Name = obj.Name
    self.Capacity = obj.Capacity
    self.CapacityUnit = obj.CapacityUnit
    self.StripSize = obj.StripSize
    self.ReadPolicy = obj.ReadPolicy
    self.WritePolicy = obj.WritePolicy
    self.IOPolicy = obj.IOPolicy
    self.AccessPolicy = obj.AccessPolicy
    self.DiskCachePolicy = obj.DiskCachePolicy
    self.InitType = obj.InitType
    self.Accelerator = obj.Accelerator
end

function TCreateVolumeInNewArrayReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCreateVolumeInNewArrayReq.group)
end

TCreateVolumeInNewArrayReq.from_obj = TCreateVolumeInNewArrayReq_from_obj

TCreateVolumeInNewArrayReq.proto_property = {
    'DriveLists', 'RaidType', 'SpanDepth', 'Name', 'Capacity', 'CapacityUnit', 'StripSize', 'ReadPolicy', 'WritePolicy',
    'IOPolicy', 'AccessPolicy', 'DiskCachePolicy', 'InitType', 'Accelerator'
}

TCreateVolumeInNewArrayReq.default = {{}, 0, 0, '', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}

TCreateVolumeInNewArrayReq.struct = {
    {name = 'DriveLists', is_array = true, struct = nil}, {name = 'RaidType', is_array = false, struct = nil},
    {name = 'SpanDepth', is_array = false, struct = nil}, {name = 'Name', is_array = false, struct = nil},
    {name = 'Capacity', is_array = false, struct = nil}, {name = 'CapacityUnit', is_array = false, struct = nil},
    {name = 'StripSize', is_array = false, struct = nil}, {name = 'ReadPolicy', is_array = false, struct = nil},
    {name = 'WritePolicy', is_array = false, struct = nil}, {name = 'IOPolicy', is_array = false, struct = nil},
    {name = 'AccessPolicy', is_array = false, struct = nil}, {name = 'DiskCachePolicy', is_array = false, struct = nil},
    {name = 'InitType', is_array = false, struct = nil}, {name = 'Accelerator', is_array = false, struct = nil}
}

function TCreateVolumeInNewArrayReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'DriveLists', self.DriveLists, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RaidType', self.RaidType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SpanDepth', self.SpanDepth, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Name', self.Name, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Capacity', self.Capacity, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'CapacityUnit', self.CapacityUnit, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'StripSize', self.StripSize, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadPolicy', self.ReadPolicy, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'WritePolicy', self.WritePolicy, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'IOPolicy', self.IOPolicy, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AccessPolicy', self.AccessPolicy, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DiskCachePolicy', self.DiskCachePolicy, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'InitType', self.InitType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Accelerator', self.Accelerator, 'uint8', false, errs, need_convert)

    TCreateVolumeInNewArrayReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCreateVolumeInNewArrayReq.proto_property, errs, need_convert)
    return self
end

function TCreateVolumeInNewArrayReq:unpack(_)
    return self.DriveLists, self.RaidType, self.SpanDepth, self.Name, self.Capacity, self.CapacityUnit, self.StripSize,
        self.ReadPolicy, self.WritePolicy, self.IOPolicy, self.AccessPolicy, self.DiskCachePolicy, self.InitType,
        self.Accelerator
end

VolumeManage.CreateVolumeInNewArrayReq = TCreateVolumeInNewArrayReq

VolumeManage.interface = mdb.register_interface('bmc.kepler.Systems.Storage.Controller.VolumeManage', {
    CreateVolumeSupported = {'b', nil, true, nil, false},
    SupportedReadPolicyList = {'as', nil, true, nil, false},
    DefaultReadPolicy = {'s', nil, true, nil, false},
    ReadPolicyWritable = {'b', nil, true, nil, false},
    SupportedWritePolicyList = {'as', nil, true, nil, false},
    DefaultWritePolicy = {'s', nil, true, nil, false},
    WritePolicyWritable = {'b', nil, true, nil, false},
    SupportedIOPolicyList = {'as', nil, true, nil, false},
    DefaultIOPolicy = {'s', nil, true, nil, false},
    IOPolicyWritable = {'b', nil, true, nil, false},
    SupportedAccessPolicyList = {'as', nil, true, nil, false},
    DefaultAccessPolicy = {'s', nil, true, nil, false},
    AccessPolicyWritable = {'b', nil, true, nil, false},
    SupportedDriveCachePolicyList = {'as', nil, true, nil, false},
    DefaultDriveCachePolicy = {'s', nil, true, nil, false},
    DriveCachePolicyWritable = {'b', nil, true, nil, false}
}, {
    CreateVolumeInNewArray = {'a{ss}ayyysuyyyyyyyyy', 'u', TCreateVolumeInNewArrayReq, TCreateVolumeInNewArrayRsp},
    DeleteVolume = {'a{ss}q', 'u', TDeleteVolumeReq, TDeleteVolumeRsp},
    CreateVolumeInExisingtArray = {
        'a{ss}qyyysuyyyyyyyyy', 'u', TCreateVolumeInExisingtArrayReq, TCreateVolumeInExisingtArrayRsp
    },
    CreateCachecadeVolume = {'a{ss}ayysyquyqy', 'u', TCreateCachecadeVolumeReq, TCreateCachecadeVolumeRsp}
}, {})

return VolumeManage
