-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local SystemsStorageController = {}

---@class SystemsStorageController.CryptoEraseSupported
---@field CryptoEraseSupported boolean
local TCryptoEraseSupported = {}
TCryptoEraseSupported.__index = TCryptoEraseSupported
TCryptoEraseSupported.group = {}

local function TCryptoEraseSupported_from_obj(obj)
    return setmetatable(obj, TCryptoEraseSupported)
end

function TCryptoEraseSupported.new(CryptoEraseSupported)
    return TCryptoEraseSupported_from_obj({CryptoEraseSupported = CryptoEraseSupported})
end
---@param obj SystemsStorageController.CryptoEraseSupported
function TCryptoEraseSupported:init_from_obj(obj)
    self.CryptoEraseSupported = obj.CryptoEraseSupported
end

function TCryptoEraseSupported:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCryptoEraseSupported.group)
end

TCryptoEraseSupported.from_obj = TCryptoEraseSupported_from_obj

TCryptoEraseSupported.proto_property = {'CryptoEraseSupported'}

TCryptoEraseSupported.default = {false}

TCryptoEraseSupported.struct = {{name = 'CryptoEraseSupported', is_array = false, struct = nil}}

function TCryptoEraseSupported:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CryptoEraseSupported', self.CryptoEraseSupported, 'bool', true, errs, need_convert)

    TCryptoEraseSupported:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCryptoEraseSupported.proto_property, errs, need_convert)
    return self
end

function TCryptoEraseSupported:unpack(_)
    return self.CryptoEraseSupported
end

SystemsStorageController.CryptoEraseSupported = TCryptoEraseSupported

---@class SystemsStorageController.BOMNumber
---@field BOMNumber string
local TBOMNumber = {}
TBOMNumber.__index = TBOMNumber
TBOMNumber.group = {}

local function TBOMNumber_from_obj(obj)
    return setmetatable(obj, TBOMNumber)
end

function TBOMNumber.new(BOMNumber)
    return TBOMNumber_from_obj({BOMNumber = BOMNumber})
end
---@param obj SystemsStorageController.BOMNumber
function TBOMNumber:init_from_obj(obj)
    self.BOMNumber = obj.BOMNumber
end

function TBOMNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBOMNumber.group)
end

TBOMNumber.from_obj = TBOMNumber_from_obj

TBOMNumber.proto_property = {'BOMNumber'}

TBOMNumber.default = {''}

TBOMNumber.struct = {{name = 'BOMNumber', is_array = false, struct = nil}}

function TBOMNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BOMNumber', self.BOMNumber, 'string', true, errs, need_convert)

    TBOMNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBOMNumber.proto_property, errs, need_convert)
    return self
end

function TBOMNumber:unpack(_)
    return self.BOMNumber
end

SystemsStorageController.BOMNumber = TBOMNumber

---@class SystemsStorageController.RefDrives
---@field RefDrives string[]
local TRefDrives = {}
TRefDrives.__index = TRefDrives
TRefDrives.group = {}

local function TRefDrives_from_obj(obj)
    return setmetatable(obj, TRefDrives)
end

function TRefDrives.new(RefDrives)
    return TRefDrives_from_obj({RefDrives = RefDrives})
end
---@param obj SystemsStorageController.RefDrives
function TRefDrives:init_from_obj(obj)
    self.RefDrives = obj.RefDrives
end

function TRefDrives:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefDrives.group)
end

TRefDrives.from_obj = TRefDrives_from_obj

TRefDrives.proto_property = {'RefDrives'}

TRefDrives.default = {{}}

TRefDrives.struct = {{name = 'RefDrives', is_array = true, struct = nil}}

function TRefDrives:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefDrives', self.RefDrives, 'string', true, errs, need_convert)

    TRefDrives:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefDrives.proto_property, errs, need_convert)
    return self
end

function TRefDrives:unpack(_)
    return self.RefDrives
end

SystemsStorageController.RefDrives = TRefDrives

---@class SystemsStorageController.WorkMode
---@field WorkMode string
local TWorkMode = {}
TWorkMode.__index = TWorkMode
TWorkMode.group = {}

local function TWorkMode_from_obj(obj)
    return setmetatable(obj, TWorkMode)
end

function TWorkMode.new(WorkMode)
    return TWorkMode_from_obj({WorkMode = WorkMode})
end
---@param obj SystemsStorageController.WorkMode
function TWorkMode:init_from_obj(obj)
    self.WorkMode = obj.WorkMode
end

function TWorkMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWorkMode.group)
end

TWorkMode.from_obj = TWorkMode_from_obj

TWorkMode.proto_property = {'WorkMode'}

TWorkMode.default = {''}

TWorkMode.struct = {{name = 'WorkMode', is_array = false, struct = nil}}

function TWorkMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'WorkMode', self.WorkMode, 'string', true, errs, need_convert)

    TWorkMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWorkMode.proto_property, errs, need_convert)
    return self
end

function TWorkMode:unpack(_)
    return self.WorkMode
end

SystemsStorageController.WorkMode = TWorkMode

---@class SystemsStorageController.DDREccCount
---@field DDREccCount integer
local TDDREccCount = {}
TDDREccCount.__index = TDDREccCount
TDDREccCount.group = {}

local function TDDREccCount_from_obj(obj)
    return setmetatable(obj, TDDREccCount)
end

function TDDREccCount.new(DDREccCount)
    return TDDREccCount_from_obj({DDREccCount = DDREccCount})
end
---@param obj SystemsStorageController.DDREccCount
function TDDREccCount:init_from_obj(obj)
    self.DDREccCount = obj.DDREccCount
end

function TDDREccCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDDREccCount.group)
end

TDDREccCount.from_obj = TDDREccCount_from_obj

TDDREccCount.proto_property = {'DDREccCount'}

TDDREccCount.default = {0}

TDDREccCount.struct = {{name = 'DDREccCount', is_array = false, struct = nil}}

function TDDREccCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DDREccCount', self.DDREccCount, 'uint16', true, errs, need_convert)

    TDDREccCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDDREccCount.proto_property, errs, need_convert)
    return self
end

function TDDREccCount:unpack(_)
    return self.DDREccCount
end

SystemsStorageController.DDREccCount = TDDREccCount

---@class SystemsStorageController.CachePinnedState
---@field CachePinnedState integer
local TCachePinnedState = {}
TCachePinnedState.__index = TCachePinnedState
TCachePinnedState.group = {}

local function TCachePinnedState_from_obj(obj)
    return setmetatable(obj, TCachePinnedState)
end

function TCachePinnedState.new(CachePinnedState)
    return TCachePinnedState_from_obj({CachePinnedState = CachePinnedState})
end
---@param obj SystemsStorageController.CachePinnedState
function TCachePinnedState:init_from_obj(obj)
    self.CachePinnedState = obj.CachePinnedState
end

function TCachePinnedState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCachePinnedState.group)
end

TCachePinnedState.from_obj = TCachePinnedState_from_obj

TCachePinnedState.proto_property = {'CachePinnedState'}

TCachePinnedState.default = {0}

TCachePinnedState.struct = {{name = 'CachePinnedState', is_array = false, struct = nil}}

function TCachePinnedState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CachePinnedState', self.CachePinnedState, 'uint8', true, errs, need_convert)

    TCachePinnedState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCachePinnedState.proto_property, errs, need_convert)
    return self
end

function TCachePinnedState:unpack(_)
    return self.CachePinnedState
end

SystemsStorageController.CachePinnedState = TCachePinnedState

---@class SystemsStorageController.JBODState
---@field JBODState integer
local TJBODState = {}
TJBODState.__index = TJBODState
TJBODState.group = {}

local function TJBODState_from_obj(obj)
    return setmetatable(obj, TJBODState)
end

function TJBODState.new(JBODState)
    return TJBODState_from_obj({JBODState = JBODState})
end
---@param obj SystemsStorageController.JBODState
function TJBODState:init_from_obj(obj)
    self.JBODState = obj.JBODState
end

function TJBODState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TJBODState.group)
end

TJBODState.from_obj = TJBODState_from_obj

TJBODState.proto_property = {'JBODState'}

TJBODState.default = {0}

TJBODState.struct = {{name = 'JBODState', is_array = false, struct = nil}}

function TJBODState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'JBODState', self.JBODState, 'uint8', true, errs, need_convert)

    TJBODState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TJBODState.proto_property, errs, need_convert)
    return self
end

function TJBODState:unpack(_)
    return self.JBODState
end

SystemsStorageController.JBODState = TJBODState

---@class SystemsStorageController.ReadCachePercent
---@field ReadCachePercent integer
local TReadCachePercent = {}
TReadCachePercent.__index = TReadCachePercent
TReadCachePercent.group = {}

local function TReadCachePercent_from_obj(obj)
    return setmetatable(obj, TReadCachePercent)
end

function TReadCachePercent.new(ReadCachePercent)
    return TReadCachePercent_from_obj({ReadCachePercent = ReadCachePercent or 255})
end
---@param obj SystemsStorageController.ReadCachePercent
function TReadCachePercent:init_from_obj(obj)
    self.ReadCachePercent = obj.ReadCachePercent or 255
end

function TReadCachePercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadCachePercent.group)
end

TReadCachePercent.from_obj = TReadCachePercent_from_obj

TReadCachePercent.proto_property = {'ReadCachePercent'}

TReadCachePercent.default = {0}

TReadCachePercent.struct = {{name = 'ReadCachePercent', is_array = false, struct = nil}}

function TReadCachePercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReadCachePercent', self.ReadCachePercent, 'uint8', true, errs, need_convert)

    TReadCachePercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadCachePercent.proto_property, errs, need_convert)
    return self
end

function TReadCachePercent:unpack(_)
    return self.ReadCachePercent
end

SystemsStorageController.ReadCachePercent = TReadCachePercent

---@class SystemsStorageController.NoBatteryWriteCacheEnabled
---@field NoBatteryWriteCacheEnabled integer
local TNoBatteryWriteCacheEnabled = {}
TNoBatteryWriteCacheEnabled.__index = TNoBatteryWriteCacheEnabled
TNoBatteryWriteCacheEnabled.group = {}

local function TNoBatteryWriteCacheEnabled_from_obj(obj)
    return setmetatable(obj, TNoBatteryWriteCacheEnabled)
end

function TNoBatteryWriteCacheEnabled.new(NoBatteryWriteCacheEnabled)
    return TNoBatteryWriteCacheEnabled_from_obj({NoBatteryWriteCacheEnabled = NoBatteryWriteCacheEnabled or 255})
end
---@param obj SystemsStorageController.NoBatteryWriteCacheEnabled
function TNoBatteryWriteCacheEnabled:init_from_obj(obj)
    self.NoBatteryWriteCacheEnabled = obj.NoBatteryWriteCacheEnabled or 255
end

function TNoBatteryWriteCacheEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNoBatteryWriteCacheEnabled.group)
end

TNoBatteryWriteCacheEnabled.from_obj = TNoBatteryWriteCacheEnabled_from_obj

TNoBatteryWriteCacheEnabled.proto_property = {'NoBatteryWriteCacheEnabled'}

TNoBatteryWriteCacheEnabled.default = {0}

TNoBatteryWriteCacheEnabled.struct = {{name = 'NoBatteryWriteCacheEnabled', is_array = false, struct = nil}}

function TNoBatteryWriteCacheEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NoBatteryWriteCacheEnabled', self.NoBatteryWriteCacheEnabled, 'uint8', true, errs,
        need_convert)

    TNoBatteryWriteCacheEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNoBatteryWriteCacheEnabled.proto_property, errs, need_convert)
    return self
end

function TNoBatteryWriteCacheEnabled:unpack(_)
    return self.NoBatteryWriteCacheEnabled
end

SystemsStorageController.NoBatteryWriteCacheEnabled = TNoBatteryWriteCacheEnabled

---@class SystemsStorageController.HotSpareActivationMode
---@field HotSpareActivationMode string
local THotSpareActivationMode = {}
THotSpareActivationMode.__index = THotSpareActivationMode
THotSpareActivationMode.group = {}

local function THotSpareActivationMode_from_obj(obj)
    return setmetatable(obj, THotSpareActivationMode)
end

function THotSpareActivationMode.new(HotSpareActivationMode)
    return THotSpareActivationMode_from_obj({HotSpareActivationMode = HotSpareActivationMode})
end
---@param obj SystemsStorageController.HotSpareActivationMode
function THotSpareActivationMode:init_from_obj(obj)
    self.HotSpareActivationMode = obj.HotSpareActivationMode
end

function THotSpareActivationMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THotSpareActivationMode.group)
end

THotSpareActivationMode.from_obj = THotSpareActivationMode_from_obj

THotSpareActivationMode.proto_property = {'HotSpareActivationMode'}

THotSpareActivationMode.default = {''}

THotSpareActivationMode.struct = {{name = 'HotSpareActivationMode', is_array = false, struct = nil}}

function THotSpareActivationMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HotSpareActivationMode', self.HotSpareActivationMode, 'string', true, errs,
        need_convert)

    THotSpareActivationMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THotSpareActivationMode.proto_property, errs, need_convert)
    return self
end

function THotSpareActivationMode:unpack(_)
    return self.HotSpareActivationMode
end

SystemsStorageController.HotSpareActivationMode = THotSpareActivationMode

---@class SystemsStorageController.HardwareRevision
---@field HardwareRevision string
local THardwareRevision = {}
THardwareRevision.__index = THardwareRevision
THardwareRevision.group = {}

local function THardwareRevision_from_obj(obj)
    return setmetatable(obj, THardwareRevision)
end

function THardwareRevision.new(HardwareRevision)
    return THardwareRevision_from_obj({HardwareRevision = HardwareRevision})
end
---@param obj SystemsStorageController.HardwareRevision
function THardwareRevision:init_from_obj(obj)
    self.HardwareRevision = obj.HardwareRevision
end

function THardwareRevision:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THardwareRevision.group)
end

THardwareRevision.from_obj = THardwareRevision_from_obj

THardwareRevision.proto_property = {'HardwareRevision'}

THardwareRevision.default = {''}

THardwareRevision.struct = {{name = 'HardwareRevision', is_array = false, struct = nil}}

function THardwareRevision:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HardwareRevision', self.HardwareRevision, 'string', true, errs, need_convert)

    THardwareRevision:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THardwareRevision.proto_property, errs, need_convert)
    return self
end

function THardwareRevision:unpack(_)
    return self.HardwareRevision
end

SystemsStorageController.HardwareRevision = THardwareRevision

---@class SystemsStorageController.BootDevices
---@field BootDevices string[]
local TBootDevices = {}
TBootDevices.__index = TBootDevices
TBootDevices.group = {}

local function TBootDevices_from_obj(obj)
    return setmetatable(obj, TBootDevices)
end

function TBootDevices.new(BootDevices)
    return TBootDevices_from_obj({BootDevices = BootDevices})
end
---@param obj SystemsStorageController.BootDevices
function TBootDevices:init_from_obj(obj)
    self.BootDevices = obj.BootDevices
end

function TBootDevices:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBootDevices.group)
end

TBootDevices.from_obj = TBootDevices_from_obj

TBootDevices.proto_property = {'BootDevices'}

TBootDevices.default = {{}}

TBootDevices.struct = {{name = 'BootDevices', is_array = true, struct = nil}}

function TBootDevices:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'BootDevices', self.BootDevices, 'string', true, errs, need_convert)

    TBootDevices:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBootDevices.proto_property, errs, need_convert)
    return self
end

function TBootDevices:unpack(_)
    return self.BootDevices
end

SystemsStorageController.BootDevices = TBootDevices

---@class SystemsStorageController.CopyBackState
---@field CopyBackState integer
local TCopyBackState = {}
TCopyBackState.__index = TCopyBackState
TCopyBackState.group = {}

local function TCopyBackState_from_obj(obj)
    return setmetatable(obj, TCopyBackState)
end

function TCopyBackState.new(CopyBackState)
    return TCopyBackState_from_obj({CopyBackState = CopyBackState})
end
---@param obj SystemsStorageController.CopyBackState
function TCopyBackState:init_from_obj(obj)
    self.CopyBackState = obj.CopyBackState
end

function TCopyBackState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCopyBackState.group)
end

TCopyBackState.from_obj = TCopyBackState_from_obj

TCopyBackState.proto_property = {'CopyBackState'}

TCopyBackState.default = {0}

TCopyBackState.struct = {{name = 'CopyBackState', is_array = false, struct = nil}}

function TCopyBackState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CopyBackState', self.CopyBackState, 'uint8', true, errs, need_convert)

    TCopyBackState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCopyBackState.proto_property, errs, need_convert)
    return self
end

function TCopyBackState:unpack(_)
    return self.CopyBackState
end

SystemsStorageController.CopyBackState = TCopyBackState

---@class SystemsStorageController.SmarterCopyBackState
---@field SmarterCopyBackState integer
local TSmarterCopyBackState = {}
TSmarterCopyBackState.__index = TSmarterCopyBackState
TSmarterCopyBackState.group = {}

local function TSmarterCopyBackState_from_obj(obj)
    return setmetatable(obj, TSmarterCopyBackState)
end

function TSmarterCopyBackState.new(SmarterCopyBackState)
    return TSmarterCopyBackState_from_obj({SmarterCopyBackState = SmarterCopyBackState})
end
---@param obj SystemsStorageController.SmarterCopyBackState
function TSmarterCopyBackState:init_from_obj(obj)
    self.SmarterCopyBackState = obj.SmarterCopyBackState
end

function TSmarterCopyBackState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSmarterCopyBackState.group)
end

TSmarterCopyBackState.from_obj = TSmarterCopyBackState_from_obj

TSmarterCopyBackState.proto_property = {'SmarterCopyBackState'}

TSmarterCopyBackState.default = {0}

TSmarterCopyBackState.struct = {{name = 'SmarterCopyBackState', is_array = false, struct = nil}}

function TSmarterCopyBackState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SmarterCopyBackState', self.SmarterCopyBackState, 'uint8', true, errs, need_convert)

    TSmarterCopyBackState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSmarterCopyBackState.proto_property, errs, need_convert)
    return self
end

function TSmarterCopyBackState:unpack(_)
    return self.SmarterCopyBackState
end

SystemsStorageController.SmarterCopyBackState = TSmarterCopyBackState

---@class SystemsStorageController.SupportedRAIDTypes
---@field SupportedRAIDTypes string[]
local TSupportedRAIDTypes = {}
TSupportedRAIDTypes.__index = TSupportedRAIDTypes
TSupportedRAIDTypes.group = {}

local function TSupportedRAIDTypes_from_obj(obj)
    return setmetatable(obj, TSupportedRAIDTypes)
end

function TSupportedRAIDTypes.new(SupportedRAIDTypes)
    return TSupportedRAIDTypes_from_obj({SupportedRAIDTypes = SupportedRAIDTypes})
end
---@param obj SystemsStorageController.SupportedRAIDTypes
function TSupportedRAIDTypes:init_from_obj(obj)
    self.SupportedRAIDTypes = obj.SupportedRAIDTypes
end

function TSupportedRAIDTypes:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSupportedRAIDTypes.group)
end

TSupportedRAIDTypes.from_obj = TSupportedRAIDTypes_from_obj

TSupportedRAIDTypes.proto_property = {'SupportedRAIDTypes'}

TSupportedRAIDTypes.default = {{}}

TSupportedRAIDTypes.struct = {{name = 'SupportedRAIDTypes', is_array = true, struct = nil}}

function TSupportedRAIDTypes:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'SupportedRAIDTypes', self.SupportedRAIDTypes, 'string', true, errs, need_convert)

    TSupportedRAIDTypes:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSupportedRAIDTypes.proto_property, errs, need_convert)
    return self
end

function TSupportedRAIDTypes:unpack(_)
    return self.SupportedRAIDTypes
end

SystemsStorageController.SupportedRAIDTypes = TSupportedRAIDTypes

---@class SystemsStorageController.ConfiguredDriveWriteCachePolicy
---@field ConfiguredDriveWriteCachePolicy string
local TConfiguredDriveWriteCachePolicy = {}
TConfiguredDriveWriteCachePolicy.__index = TConfiguredDriveWriteCachePolicy
TConfiguredDriveWriteCachePolicy.group = {}

local function TConfiguredDriveWriteCachePolicy_from_obj(obj)
    return setmetatable(obj, TConfiguredDriveWriteCachePolicy)
end

function TConfiguredDriveWriteCachePolicy.new(ConfiguredDriveWriteCachePolicy)
    return
        TConfiguredDriveWriteCachePolicy_from_obj({ConfiguredDriveWriteCachePolicy = ConfiguredDriveWriteCachePolicy})
end
---@param obj SystemsStorageController.ConfiguredDriveWriteCachePolicy
function TConfiguredDriveWriteCachePolicy:init_from_obj(obj)
    self.ConfiguredDriveWriteCachePolicy = obj.ConfiguredDriveWriteCachePolicy
end

function TConfiguredDriveWriteCachePolicy:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConfiguredDriveWriteCachePolicy.group)
end

TConfiguredDriveWriteCachePolicy.from_obj = TConfiguredDriveWriteCachePolicy_from_obj

TConfiguredDriveWriteCachePolicy.proto_property = {'ConfiguredDriveWriteCachePolicy'}

TConfiguredDriveWriteCachePolicy.default = {''}

TConfiguredDriveWriteCachePolicy.struct = {{name = 'ConfiguredDriveWriteCachePolicy', is_array = false, struct = nil}}

function TConfiguredDriveWriteCachePolicy:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ConfiguredDriveWriteCachePolicy', self.ConfiguredDriveWriteCachePolicy, 'string', true,
        errs, need_convert)

    TConfiguredDriveWriteCachePolicy:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConfiguredDriveWriteCachePolicy.proto_property, errs, need_convert)
    return self
end

function TConfiguredDriveWriteCachePolicy:unpack(_)
    return self.ConfiguredDriveWriteCachePolicy
end

SystemsStorageController.ConfiguredDriveWriteCachePolicy = TConfiguredDriveWriteCachePolicy

---@class SystemsStorageController.HBADriveWriteCachePolicy
---@field HBADriveWriteCachePolicy string
local THBADriveWriteCachePolicy = {}
THBADriveWriteCachePolicy.__index = THBADriveWriteCachePolicy
THBADriveWriteCachePolicy.group = {}

local function THBADriveWriteCachePolicy_from_obj(obj)
    return setmetatable(obj, THBADriveWriteCachePolicy)
end

function THBADriveWriteCachePolicy.new(HBADriveWriteCachePolicy)
    return THBADriveWriteCachePolicy_from_obj({HBADriveWriteCachePolicy = HBADriveWriteCachePolicy})
end
---@param obj SystemsStorageController.HBADriveWriteCachePolicy
function THBADriveWriteCachePolicy:init_from_obj(obj)
    self.HBADriveWriteCachePolicy = obj.HBADriveWriteCachePolicy
end

function THBADriveWriteCachePolicy:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THBADriveWriteCachePolicy.group)
end

THBADriveWriteCachePolicy.from_obj = THBADriveWriteCachePolicy_from_obj

THBADriveWriteCachePolicy.proto_property = {'HBADriveWriteCachePolicy'}

THBADriveWriteCachePolicy.default = {''}

THBADriveWriteCachePolicy.struct = {{name = 'HBADriveWriteCachePolicy', is_array = false, struct = nil}}

function THBADriveWriteCachePolicy:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HBADriveWriteCachePolicy', self.HBADriveWriteCachePolicy, 'string', true, errs,
        need_convert)

    THBADriveWriteCachePolicy:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THBADriveWriteCachePolicy.proto_property, errs, need_convert)
    return self
end

function THBADriveWriteCachePolicy:unpack(_)
    return self.HBADriveWriteCachePolicy
end

SystemsStorageController.HBADriveWriteCachePolicy = THBADriveWriteCachePolicy

---@class SystemsStorageController.UnconfiguredDriveWriteCachePolicy
---@field UnconfiguredDriveWriteCachePolicy string
local TUnconfiguredDriveWriteCachePolicy = {}
TUnconfiguredDriveWriteCachePolicy.__index = TUnconfiguredDriveWriteCachePolicy
TUnconfiguredDriveWriteCachePolicy.group = {}

local function TUnconfiguredDriveWriteCachePolicy_from_obj(obj)
    return setmetatable(obj, TUnconfiguredDriveWriteCachePolicy)
end

function TUnconfiguredDriveWriteCachePolicy.new(UnconfiguredDriveWriteCachePolicy)
    return TUnconfiguredDriveWriteCachePolicy_from_obj({
        UnconfiguredDriveWriteCachePolicy = UnconfiguredDriveWriteCachePolicy
    })
end
---@param obj SystemsStorageController.UnconfiguredDriveWriteCachePolicy
function TUnconfiguredDriveWriteCachePolicy:init_from_obj(obj)
    self.UnconfiguredDriveWriteCachePolicy = obj.UnconfiguredDriveWriteCachePolicy
end

function TUnconfiguredDriveWriteCachePolicy:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUnconfiguredDriveWriteCachePolicy.group)
end

TUnconfiguredDriveWriteCachePolicy.from_obj = TUnconfiguredDriveWriteCachePolicy_from_obj

TUnconfiguredDriveWriteCachePolicy.proto_property = {'UnconfiguredDriveWriteCachePolicy'}

TUnconfiguredDriveWriteCachePolicy.default = {''}

TUnconfiguredDriveWriteCachePolicy.struct = {
    {name = 'UnconfiguredDriveWriteCachePolicy', is_array = false, struct = nil}
}

function TUnconfiguredDriveWriteCachePolicy:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UnconfiguredDriveWriteCachePolicy', self.UnconfiguredDriveWriteCachePolicy, 'string',
        true, errs, need_convert)

    TUnconfiguredDriveWriteCachePolicy:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUnconfiguredDriveWriteCachePolicy.proto_property, errs, need_convert)
    return self
end

function TUnconfiguredDriveWriteCachePolicy:unpack(_)
    return self.UnconfiguredDriveWriteCachePolicy
end

SystemsStorageController.UnconfiguredDriveWriteCachePolicy = TUnconfiguredDriveWriteCachePolicy

---@class SystemsStorageController.PCIeLinkWidth
---@field PCIeLinkWidth string
local TPCIeLinkWidth = {}
TPCIeLinkWidth.__index = TPCIeLinkWidth
TPCIeLinkWidth.group = {}

local function TPCIeLinkWidth_from_obj(obj)
    return setmetatable(obj, TPCIeLinkWidth)
end

function TPCIeLinkWidth.new(PCIeLinkWidth)
    return TPCIeLinkWidth_from_obj({PCIeLinkWidth = PCIeLinkWidth})
end
---@param obj SystemsStorageController.PCIeLinkWidth
function TPCIeLinkWidth:init_from_obj(obj)
    self.PCIeLinkWidth = obj.PCIeLinkWidth
end

function TPCIeLinkWidth:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPCIeLinkWidth.group)
end

TPCIeLinkWidth.from_obj = TPCIeLinkWidth_from_obj

TPCIeLinkWidth.proto_property = {'PCIeLinkWidth'}

TPCIeLinkWidth.default = {''}

TPCIeLinkWidth.struct = {{name = 'PCIeLinkWidth', is_array = false, struct = nil}}

function TPCIeLinkWidth:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PCIeLinkWidth', self.PCIeLinkWidth, 'string', true, errs, need_convert)

    TPCIeLinkWidth:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPCIeLinkWidth.proto_property, errs, need_convert)
    return self
end

function TPCIeLinkWidth:unpack(_)
    return self.PCIeLinkWidth
end

SystemsStorageController.PCIeLinkWidth = TPCIeLinkWidth

---@class SystemsStorageController.MaintainPDFailHistrory
---@field MaintainPDFailHistrory integer
local TMaintainPDFailHistrory = {}
TMaintainPDFailHistrory.__index = TMaintainPDFailHistrory
TMaintainPDFailHistrory.group = {}

local function TMaintainPDFailHistrory_from_obj(obj)
    return setmetatable(obj, TMaintainPDFailHistrory)
end

function TMaintainPDFailHistrory.new(MaintainPDFailHistrory)
    return TMaintainPDFailHistrory_from_obj({MaintainPDFailHistrory = MaintainPDFailHistrory})
end
---@param obj SystemsStorageController.MaintainPDFailHistrory
function TMaintainPDFailHistrory:init_from_obj(obj)
    self.MaintainPDFailHistrory = obj.MaintainPDFailHistrory
end

function TMaintainPDFailHistrory:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaintainPDFailHistrory.group)
end

TMaintainPDFailHistrory.from_obj = TMaintainPDFailHistrory_from_obj

TMaintainPDFailHistrory.proto_property = {'MaintainPDFailHistrory'}

TMaintainPDFailHistrory.default = {0}

TMaintainPDFailHistrory.struct = {{name = 'MaintainPDFailHistrory', is_array = false, struct = nil}}

function TMaintainPDFailHistrory:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaintainPDFailHistrory', self.MaintainPDFailHistrory, 'uint8', true, errs, need_convert)

    TMaintainPDFailHistrory:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaintainPDFailHistrory.proto_property, errs, need_convert)
    return self
end

function TMaintainPDFailHistrory:unpack(_)
    return self.MaintainPDFailHistrory
end

SystemsStorageController.MaintainPDFailHistrory = TMaintainPDFailHistrory

---@class SystemsStorageController.NVDataVersion
---@field NVDataVersion string
local TNVDataVersion = {}
TNVDataVersion.__index = TNVDataVersion
TNVDataVersion.group = {}

local function TNVDataVersion_from_obj(obj)
    return setmetatable(obj, TNVDataVersion)
end

function TNVDataVersion.new(NVDataVersion)
    return TNVDataVersion_from_obj({NVDataVersion = NVDataVersion})
end
---@param obj SystemsStorageController.NVDataVersion
function TNVDataVersion:init_from_obj(obj)
    self.NVDataVersion = obj.NVDataVersion
end

function TNVDataVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNVDataVersion.group)
end

TNVDataVersion.from_obj = TNVDataVersion_from_obj

TNVDataVersion.proto_property = {'NVDataVersion'}

TNVDataVersion.default = {''}

TNVDataVersion.struct = {{name = 'NVDataVersion', is_array = false, struct = nil}}

function TNVDataVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NVDataVersion', self.NVDataVersion, 'string', true, errs, need_convert)

    TNVDataVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNVDataVersion.proto_property, errs, need_convert)
    return self
end

function TNVDataVersion:unpack(_)
    return self.NVDataVersion
end

SystemsStorageController.NVDataVersion = TNVDataVersion

---@class SystemsStorageController.MinStripSizeBytes
---@field MinStripSizeBytes integer
local TMinStripSizeBytes = {}
TMinStripSizeBytes.__index = TMinStripSizeBytes
TMinStripSizeBytes.group = {}

local function TMinStripSizeBytes_from_obj(obj)
    return setmetatable(obj, TMinStripSizeBytes)
end

function TMinStripSizeBytes.new(MinStripSizeBytes)
    return TMinStripSizeBytes_from_obj({MinStripSizeBytes = MinStripSizeBytes})
end
---@param obj SystemsStorageController.MinStripSizeBytes
function TMinStripSizeBytes:init_from_obj(obj)
    self.MinStripSizeBytes = obj.MinStripSizeBytes
end

function TMinStripSizeBytes:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMinStripSizeBytes.group)
end

TMinStripSizeBytes.from_obj = TMinStripSizeBytes_from_obj

TMinStripSizeBytes.proto_property = {'MinStripSizeBytes'}

TMinStripSizeBytes.default = {0}

TMinStripSizeBytes.struct = {{name = 'MinStripSizeBytes', is_array = false, struct = nil}}

function TMinStripSizeBytes:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MinStripSizeBytes', self.MinStripSizeBytes, 'uint32', true, errs, need_convert)

    TMinStripSizeBytes:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMinStripSizeBytes.proto_property, errs, need_convert)
    return self
end

function TMinStripSizeBytes:unpack(_)
    return self.MinStripSizeBytes
end

SystemsStorageController.MinStripSizeBytes = TMinStripSizeBytes

---@class SystemsStorageController.MaxStripSizeBytes
---@field MaxStripSizeBytes integer
local TMaxStripSizeBytes = {}
TMaxStripSizeBytes.__index = TMaxStripSizeBytes
TMaxStripSizeBytes.group = {}

local function TMaxStripSizeBytes_from_obj(obj)
    return setmetatable(obj, TMaxStripSizeBytes)
end

function TMaxStripSizeBytes.new(MaxStripSizeBytes)
    return TMaxStripSizeBytes_from_obj({MaxStripSizeBytes = MaxStripSizeBytes})
end
---@param obj SystemsStorageController.MaxStripSizeBytes
function TMaxStripSizeBytes:init_from_obj(obj)
    self.MaxStripSizeBytes = obj.MaxStripSizeBytes
end

function TMaxStripSizeBytes:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaxStripSizeBytes.group)
end

TMaxStripSizeBytes.from_obj = TMaxStripSizeBytes_from_obj

TMaxStripSizeBytes.proto_property = {'MaxStripSizeBytes'}

TMaxStripSizeBytes.default = {0}

TMaxStripSizeBytes.struct = {{name = 'MaxStripSizeBytes', is_array = false, struct = nil}}

function TMaxStripSizeBytes:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxStripSizeBytes', self.MaxStripSizeBytes, 'uint32', true, errs, need_convert)

    TMaxStripSizeBytes:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaxStripSizeBytes.proto_property, errs, need_convert)
    return self
end

function TMaxStripSizeBytes:unpack(_)
    return self.MaxStripSizeBytes
end

SystemsStorageController.MaxStripSizeBytes = TMaxStripSizeBytes

---@class SystemsStorageController.SerialNumber
---@field SerialNumber string
local TSerialNumber = {}
TSerialNumber.__index = TSerialNumber
TSerialNumber.group = {}

local function TSerialNumber_from_obj(obj)
    return setmetatable(obj, TSerialNumber)
end

function TSerialNumber.new(SerialNumber)
    return TSerialNumber_from_obj({SerialNumber = SerialNumber})
end
---@param obj SystemsStorageController.SerialNumber
function TSerialNumber:init_from_obj(obj)
    self.SerialNumber = obj.SerialNumber
end

function TSerialNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSerialNumber.group)
end

TSerialNumber.from_obj = TSerialNumber_from_obj

TSerialNumber.proto_property = {'SerialNumber'}

TSerialNumber.default = {''}

TSerialNumber.struct = {{name = 'SerialNumber', is_array = false, struct = nil}}

function TSerialNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SerialNumber', self.SerialNumber, 'string', true, errs, need_convert)

    TSerialNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSerialNumber.proto_property, errs, need_convert)
    return self
end

function TSerialNumber:unpack(_)
    return self.SerialNumber
end

SystemsStorageController.SerialNumber = TSerialNumber

---@class SystemsStorageController.SASAddr
---@field SASAddr string
local TSASAddr = {}
TSASAddr.__index = TSASAddr
TSASAddr.group = {}

local function TSASAddr_from_obj(obj)
    return setmetatable(obj, TSASAddr)
end

function TSASAddr.new(SASAddr)
    return TSASAddr_from_obj({SASAddr = SASAddr})
end
---@param obj SystemsStorageController.SASAddr
function TSASAddr:init_from_obj(obj)
    self.SASAddr = obj.SASAddr
end

function TSASAddr:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSASAddr.group)
end

TSASAddr.from_obj = TSASAddr_from_obj

TSASAddr.proto_property = {'SASAddr'}

TSASAddr.default = {''}

TSASAddr.struct = {{name = 'SASAddr', is_array = false, struct = nil}}

function TSASAddr:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SASAddr', self.SASAddr, 'string', true, errs, need_convert)

    TSASAddr:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSASAddr.proto_property, errs, need_convert)
    return self
end

function TSASAddr:unpack(_)
    return self.SASAddr
end

SystemsStorageController.SASAddr = TSASAddr

---@class SystemsStorageController.DeviceInterface
---@field DeviceInterface string
local TDeviceInterface = {}
TDeviceInterface.__index = TDeviceInterface
TDeviceInterface.group = {}

local function TDeviceInterface_from_obj(obj)
    return setmetatable(obj, TDeviceInterface)
end

function TDeviceInterface.new(DeviceInterface)
    return TDeviceInterface_from_obj({DeviceInterface = DeviceInterface})
end
---@param obj SystemsStorageController.DeviceInterface
function TDeviceInterface:init_from_obj(obj)
    self.DeviceInterface = obj.DeviceInterface
end

function TDeviceInterface:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceInterface.group)
end

TDeviceInterface.from_obj = TDeviceInterface_from_obj

TDeviceInterface.proto_property = {'DeviceInterface'}

TDeviceInterface.default = {''}

TDeviceInterface.struct = {{name = 'DeviceInterface', is_array = false, struct = nil}}

function TDeviceInterface:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeviceInterface', self.DeviceInterface, 'string', true, errs, need_convert)

    TDeviceInterface:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceInterface.proto_property, errs, need_convert)
    return self
end

function TDeviceInterface:unpack(_)
    return self.DeviceInterface
end

SystemsStorageController.DeviceInterface = TDeviceInterface

---@class SystemsStorageController.MemorySizeMiB
---@field MemorySizeMiB integer
local TMemorySizeMiB = {}
TMemorySizeMiB.__index = TMemorySizeMiB
TMemorySizeMiB.group = {}

local function TMemorySizeMiB_from_obj(obj)
    return setmetatable(obj, TMemorySizeMiB)
end

function TMemorySizeMiB.new(MemorySizeMiB)
    return TMemorySizeMiB_from_obj({MemorySizeMiB = MemorySizeMiB})
end
---@param obj SystemsStorageController.MemorySizeMiB
function TMemorySizeMiB:init_from_obj(obj)
    self.MemorySizeMiB = obj.MemorySizeMiB
end

function TMemorySizeMiB:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMemorySizeMiB.group)
end

TMemorySizeMiB.from_obj = TMemorySizeMiB_from_obj

TMemorySizeMiB.proto_property = {'MemorySizeMiB'}

TMemorySizeMiB.default = {0}

TMemorySizeMiB.struct = {{name = 'MemorySizeMiB', is_array = false, struct = nil}}

function TMemorySizeMiB:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MemorySizeMiB', self.MemorySizeMiB, 'uint16', true, errs, need_convert)

    TMemorySizeMiB:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMemorySizeMiB.proto_property, errs, need_convert)
    return self
end

function TMemorySizeMiB:unpack(_)
    return self.MemorySizeMiB
end

SystemsStorageController.MemorySizeMiB = TMemorySizeMiB

---@class SystemsStorageController.SupportedMode
---@field SupportedMode string[]
local TSupportedMode = {}
TSupportedMode.__index = TSupportedMode
TSupportedMode.group = {}

local function TSupportedMode_from_obj(obj)
    return setmetatable(obj, TSupportedMode)
end

function TSupportedMode.new(SupportedMode)
    return TSupportedMode_from_obj({SupportedMode = SupportedMode})
end
---@param obj SystemsStorageController.SupportedMode
function TSupportedMode:init_from_obj(obj)
    self.SupportedMode = obj.SupportedMode
end

function TSupportedMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSupportedMode.group)
end

TSupportedMode.from_obj = TSupportedMode_from_obj

TSupportedMode.proto_property = {'SupportedMode'}

TSupportedMode.default = {{}}

TSupportedMode.struct = {{name = 'SupportedMode', is_array = true, struct = nil}}

function TSupportedMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'SupportedMode', self.SupportedMode, 'string', true, errs, need_convert)

    TSupportedMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSupportedMode.proto_property, errs, need_convert)
    return self
end

function TSupportedMode:unpack(_)
    return self.SupportedMode
end

SystemsStorageController.SupportedMode = TSupportedMode

---@class SystemsStorageController.FirmwareVersion
---@field FirmwareVersion string
local TFirmwareVersion = {}
TFirmwareVersion.__index = TFirmwareVersion
TFirmwareVersion.group = {}

local function TFirmwareVersion_from_obj(obj)
    return setmetatable(obj, TFirmwareVersion)
end

function TFirmwareVersion.new(FirmwareVersion)
    return TFirmwareVersion_from_obj({FirmwareVersion = FirmwareVersion})
end
---@param obj SystemsStorageController.FirmwareVersion
function TFirmwareVersion:init_from_obj(obj)
    self.FirmwareVersion = obj.FirmwareVersion
end

function TFirmwareVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFirmwareVersion.group)
end

TFirmwareVersion.from_obj = TFirmwareVersion_from_obj

TFirmwareVersion.proto_property = {'FirmwareVersion'}

TFirmwareVersion.default = {''}

TFirmwareVersion.struct = {{name = 'FirmwareVersion', is_array = false, struct = nil}}

function TFirmwareVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FirmwareVersion', self.FirmwareVersion, 'string', true, errs, need_convert)

    TFirmwareVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFirmwareVersion.proto_property, errs, need_convert)
    return self
end

function TFirmwareVersion:unpack(_)
    return self.FirmwareVersion
end

SystemsStorageController.FirmwareVersion = TFirmwareVersion

---@class SystemsStorageController.OOBSupport
---@field OOBSupport integer
local TOOBSupport = {}
TOOBSupport.__index = TOOBSupport
TOOBSupport.group = {}

local function TOOBSupport_from_obj(obj)
    return setmetatable(obj, TOOBSupport)
end

function TOOBSupport.new(OOBSupport)
    return TOOBSupport_from_obj({OOBSupport = OOBSupport})
end
---@param obj SystemsStorageController.OOBSupport
function TOOBSupport:init_from_obj(obj)
    self.OOBSupport = obj.OOBSupport
end

function TOOBSupport:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOOBSupport.group)
end

TOOBSupport.from_obj = TOOBSupport_from_obj

TOOBSupport.proto_property = {'OOBSupport'}

TOOBSupport.default = {0}

TOOBSupport.struct = {{name = 'OOBSupport', is_array = false, struct = nil}}

function TOOBSupport:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OOBSupport', self.OOBSupport, 'uint8', true, errs, need_convert)

    TOOBSupport:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOOBSupport.proto_property, errs, need_convert)
    return self
end

function TOOBSupport:unpack(_)
    return self.OOBSupport
end

SystemsStorageController.OOBSupport = TOOBSupport

---@class SystemsStorageController.Name
---@field Name string
local TName = {}
TName.__index = TName
TName.group = {}

local function TName_from_obj(obj)
    return setmetatable(obj, TName)
end

function TName.new(Name)
    return TName_from_obj({Name = Name})
end
---@param obj SystemsStorageController.Name
function TName:init_from_obj(obj)
    self.Name = obj.Name
end

function TName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TName.group)
end

TName.from_obj = TName_from_obj

TName.proto_property = {'Name'}

TName.default = {''}

TName.struct = {{name = 'Name', is_array = false, struct = nil}}

function TName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Name', self.Name, 'string', true, errs, need_convert)

    TName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TName.proto_property, errs, need_convert)
    return self
end

function TName:unpack(_)
    return self.Name
end

SystemsStorageController.Name = TName

---@class SystemsStorageController.TemperatureAbnormal
---@field TemperatureAbnormal integer
local TTemperatureAbnormal = {}
TTemperatureAbnormal.__index = TTemperatureAbnormal
TTemperatureAbnormal.group = {}

local function TTemperatureAbnormal_from_obj(obj)
    return setmetatable(obj, TTemperatureAbnormal)
end

function TTemperatureAbnormal.new(TemperatureAbnormal)
    return TTemperatureAbnormal_from_obj({TemperatureAbnormal = TemperatureAbnormal})
end
---@param obj SystemsStorageController.TemperatureAbnormal
function TTemperatureAbnormal:init_from_obj(obj)
    self.TemperatureAbnormal = obj.TemperatureAbnormal
end

function TTemperatureAbnormal:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTemperatureAbnormal.group)
end

TTemperatureAbnormal.from_obj = TTemperatureAbnormal_from_obj

TTemperatureAbnormal.proto_property = {'TemperatureAbnormal'}

TTemperatureAbnormal.default = {0}

TTemperatureAbnormal.struct = {{name = 'TemperatureAbnormal', is_array = false, struct = nil}}

function TTemperatureAbnormal:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TemperatureAbnormal', self.TemperatureAbnormal, 'uint8', true, errs, need_convert)

    TTemperatureAbnormal:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTemperatureAbnormal.proto_property, errs, need_convert)
    return self
end

function TTemperatureAbnormal:unpack(_)
    return self.TemperatureAbnormal
end

SystemsStorageController.TemperatureAbnormal = TTemperatureAbnormal

---@class SystemsStorageController.TemperatureCelsius
---@field TemperatureCelsius integer
local TTemperatureCelsius = {}
TTemperatureCelsius.__index = TTemperatureCelsius
TTemperatureCelsius.group = {}

local function TTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TTemperatureCelsius)
end

function TTemperatureCelsius.new(TemperatureCelsius)
    return TTemperatureCelsius_from_obj({TemperatureCelsius = TemperatureCelsius})
end
---@param obj SystemsStorageController.TemperatureCelsius
function TTemperatureCelsius:init_from_obj(obj)
    self.TemperatureCelsius = obj.TemperatureCelsius
end

function TTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTemperatureCelsius.group)
end

TTemperatureCelsius.from_obj = TTemperatureCelsius_from_obj

TTemperatureCelsius.proto_property = {'TemperatureCelsius'}

TTemperatureCelsius.default = {0}

TTemperatureCelsius.struct = {{name = 'TemperatureCelsius', is_array = false, struct = nil}}

function TTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TemperatureCelsius', self.TemperatureCelsius, 'int16', true, errs, need_convert)

    TTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TTemperatureCelsius:unpack(_)
    return self.TemperatureCelsius
end

SystemsStorageController.TemperatureCelsius = TTemperatureCelsius

---@class SystemsStorageController.Position
---@field Position string
local TPosition = {}
TPosition.__index = TPosition
TPosition.group = {}

local function TPosition_from_obj(obj)
    return setmetatable(obj, TPosition)
end

function TPosition.new(Position)
    return TPosition_from_obj({Position = Position})
end
---@param obj SystemsStorageController.Position
function TPosition:init_from_obj(obj)
    self.Position = obj.Position
end

function TPosition:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPosition.group)
end

TPosition.from_obj = TPosition_from_obj

TPosition.proto_property = {'Position'}

TPosition.default = {''}

TPosition.struct = {{name = 'Position', is_array = false, struct = nil}}

function TPosition:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Position', self.Position, 'string', true, errs, need_convert)

    TPosition:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPosition.proto_property, errs, need_convert)
    return self
end

function TPosition:unpack(_)
    return self.Position
end

SystemsStorageController.Position = TPosition

---@class SystemsStorageController.DeviceName
---@field DeviceName string
local TDeviceName = {}
TDeviceName.__index = TDeviceName
TDeviceName.group = {}

local function TDeviceName_from_obj(obj)
    return setmetatable(obj, TDeviceName)
end

function TDeviceName.new(DeviceName)
    return TDeviceName_from_obj({DeviceName = DeviceName})
end
---@param obj SystemsStorageController.DeviceName
function TDeviceName:init_from_obj(obj)
    self.DeviceName = obj.DeviceName
end

function TDeviceName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceName.group)
end

TDeviceName.from_obj = TDeviceName_from_obj

TDeviceName.proto_property = {'DeviceName'}

TDeviceName.default = {''}

TDeviceName.struct = {{name = 'DeviceName', is_array = false, struct = nil}}

function TDeviceName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'DeviceName', self.DeviceName, 'string', true, errs, need_convert)

    TDeviceName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceName.proto_property, errs, need_convert)
    return self
end

function TDeviceName:unpack(_)
    return self.DeviceName
end

SystemsStorageController.DeviceName = TDeviceName

---@class SystemsStorageController.TypeId
---@field TypeId integer
local TTypeId = {}
TTypeId.__index = TTypeId
TTypeId.group = {}

local function TTypeId_from_obj(obj)
    return setmetatable(obj, TTypeId)
end

function TTypeId.new(TypeId)
    return TTypeId_from_obj({TypeId = TypeId})
end
---@param obj SystemsStorageController.TypeId
function TTypeId:init_from_obj(obj)
    self.TypeId = obj.TypeId
end

function TTypeId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTypeId.group)
end

TTypeId.from_obj = TTypeId_from_obj

TTypeId.proto_property = {'TypeId'}

TTypeId.default = {0}

TTypeId.struct = {{name = 'TypeId', is_array = false, struct = nil}}

function TTypeId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TypeId', self.TypeId, 'uint8', true, errs, need_convert)

    TTypeId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTypeId.proto_property, errs, need_convert)
    return self
end

function TTypeId:unpack(_)
    return self.TypeId
end

SystemsStorageController.TypeId = TTypeId

---@class SystemsStorageController.Type
---@field Type string
local TType = {}
TType.__index = TType
TType.group = {}

local function TType_from_obj(obj)
    return setmetatable(obj, TType)
end

function TType.new(Type)
    return TType_from_obj({Type = Type})
end
---@param obj SystemsStorageController.Type
function TType:init_from_obj(obj)
    self.Type = obj.Type
end

function TType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TType.group)
end

TType.from_obj = TType_from_obj

TType.proto_property = {'Type'}

TType.default = {''}

TType.struct = {{name = 'Type', is_array = false, struct = nil}}

function TType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'string', true, errs, need_convert)

    TType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TType.proto_property, errs, need_convert)
    return self
end

function TType:unpack(_)
    return self.Type
end

SystemsStorageController.Type = TType

---@class SystemsStorageController.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id or 255})
end
---@param obj SystemsStorageController.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id or 255
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Id', self.Id, 'uint8', true, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

SystemsStorageController.Id = TId

---@class SystemsStorageController.SetWriteCachePolicyRsp
local TSetWriteCachePolicyRsp = {}
TSetWriteCachePolicyRsp.__index = TSetWriteCachePolicyRsp
TSetWriteCachePolicyRsp.group = {}

local function TSetWriteCachePolicyRsp_from_obj(obj)
    return setmetatable(obj, TSetWriteCachePolicyRsp)
end

function TSetWriteCachePolicyRsp.new()
    return TSetWriteCachePolicyRsp_from_obj({})
end
---@param obj SystemsStorageController.SetWriteCachePolicyRsp
function TSetWriteCachePolicyRsp:init_from_obj(obj)

end

function TSetWriteCachePolicyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetWriteCachePolicyRsp.group)
end

TSetWriteCachePolicyRsp.from_obj = TSetWriteCachePolicyRsp_from_obj

TSetWriteCachePolicyRsp.proto_property = {}

TSetWriteCachePolicyRsp.default = {}

TSetWriteCachePolicyRsp.struct = {}

function TSetWriteCachePolicyRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetWriteCachePolicyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetWriteCachePolicyRsp.proto_property, errs, need_convert)
    return self
end

function TSetWriteCachePolicyRsp:unpack(_)
end

SystemsStorageController.SetWriteCachePolicyRsp = TSetWriteCachePolicyRsp

---@class SystemsStorageController.SetWriteCachePolicyReq
---@field Type string
---@field WriteCachePolicy string
local TSetWriteCachePolicyReq = {}
TSetWriteCachePolicyReq.__index = TSetWriteCachePolicyReq
TSetWriteCachePolicyReq.group = {}

local function TSetWriteCachePolicyReq_from_obj(obj)
    return setmetatable(obj, TSetWriteCachePolicyReq)
end

function TSetWriteCachePolicyReq.new(Type, WriteCachePolicy)
    return TSetWriteCachePolicyReq_from_obj({Type = Type, WriteCachePolicy = WriteCachePolicy})
end
---@param obj SystemsStorageController.SetWriteCachePolicyReq
function TSetWriteCachePolicyReq:init_from_obj(obj)
    self.Type = obj.Type
    self.WriteCachePolicy = obj.WriteCachePolicy
end

function TSetWriteCachePolicyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetWriteCachePolicyReq.group)
end

TSetWriteCachePolicyReq.from_obj = TSetWriteCachePolicyReq_from_obj

TSetWriteCachePolicyReq.proto_property = {'Type', 'WriteCachePolicy'}

TSetWriteCachePolicyReq.default = {'', ''}

TSetWriteCachePolicyReq.struct = {
    {name = 'Type', is_array = false, struct = nil}, {name = 'WriteCachePolicy', is_array = false, struct = nil}
}

function TSetWriteCachePolicyReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'WriteCachePolicy', self.WriteCachePolicy, 'string', false, errs, need_convert)

    if self.Type ~= nil then
        validate.Enum(prefix .. 'Type', self.Type, '', {
            'ConfiguredDriveWriteCachePolicy', 'UnconfiguredDriveWriteCachePolicy', 'HBADriveWriteCachePolicy'
        }, errs, need_convert)
    end

    TSetWriteCachePolicyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetWriteCachePolicyReq.proto_property, errs, need_convert)
    return self
end

function TSetWriteCachePolicyReq:unpack(_)
    return self.Type, self.WriteCachePolicy
end

SystemsStorageController.SetWriteCachePolicyReq = TSetWriteCachePolicyReq

---@class SystemsStorageController.SetReadCachePercentRsp
local TSetReadCachePercentRsp = {}
TSetReadCachePercentRsp.__index = TSetReadCachePercentRsp
TSetReadCachePercentRsp.group = {}

local function TSetReadCachePercentRsp_from_obj(obj)
    return setmetatable(obj, TSetReadCachePercentRsp)
end

function TSetReadCachePercentRsp.new()
    return TSetReadCachePercentRsp_from_obj({})
end
---@param obj SystemsStorageController.SetReadCachePercentRsp
function TSetReadCachePercentRsp:init_from_obj(obj)

end

function TSetReadCachePercentRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetReadCachePercentRsp.group)
end

TSetReadCachePercentRsp.from_obj = TSetReadCachePercentRsp_from_obj

TSetReadCachePercentRsp.proto_property = {}

TSetReadCachePercentRsp.default = {}

TSetReadCachePercentRsp.struct = {}

function TSetReadCachePercentRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetReadCachePercentRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetReadCachePercentRsp.proto_property, errs, need_convert)
    return self
end

function TSetReadCachePercentRsp:unpack(_)
end

SystemsStorageController.SetReadCachePercentRsp = TSetReadCachePercentRsp

---@class SystemsStorageController.SetReadCachePercentReq
---@field ReadCachePercent integer
local TSetReadCachePercentReq = {}
TSetReadCachePercentReq.__index = TSetReadCachePercentReq
TSetReadCachePercentReq.group = {}

local function TSetReadCachePercentReq_from_obj(obj)
    return setmetatable(obj, TSetReadCachePercentReq)
end

function TSetReadCachePercentReq.new(ReadCachePercent)
    return TSetReadCachePercentReq_from_obj({ReadCachePercent = ReadCachePercent})
end
---@param obj SystemsStorageController.SetReadCachePercentReq
function TSetReadCachePercentReq:init_from_obj(obj)
    self.ReadCachePercent = obj.ReadCachePercent
end

function TSetReadCachePercentReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetReadCachePercentReq.group)
end

TSetReadCachePercentReq.from_obj = TSetReadCachePercentReq_from_obj

TSetReadCachePercentReq.proto_property = {'ReadCachePercent'}

TSetReadCachePercentReq.default = {0}

TSetReadCachePercentReq.struct = {{name = 'ReadCachePercent', is_array = false, struct = nil}}

function TSetReadCachePercentReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReadCachePercent', self.ReadCachePercent, 'uint8', false, errs, need_convert)

    TSetReadCachePercentReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetReadCachePercentReq.proto_property, errs, need_convert)
    return self
end

function TSetReadCachePercentReq:unpack(_)
    return self.ReadCachePercent
end

SystemsStorageController.SetReadCachePercentReq = TSetReadCachePercentReq

---@class SystemsStorageController.SetNoBatteryWriteCacheRsp
local TSetNoBatteryWriteCacheRsp = {}
TSetNoBatteryWriteCacheRsp.__index = TSetNoBatteryWriteCacheRsp
TSetNoBatteryWriteCacheRsp.group = {}

local function TSetNoBatteryWriteCacheRsp_from_obj(obj)
    return setmetatable(obj, TSetNoBatteryWriteCacheRsp)
end

function TSetNoBatteryWriteCacheRsp.new()
    return TSetNoBatteryWriteCacheRsp_from_obj({})
end
---@param obj SystemsStorageController.SetNoBatteryWriteCacheRsp
function TSetNoBatteryWriteCacheRsp:init_from_obj(obj)

end

function TSetNoBatteryWriteCacheRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetNoBatteryWriteCacheRsp.group)
end

TSetNoBatteryWriteCacheRsp.from_obj = TSetNoBatteryWriteCacheRsp_from_obj

TSetNoBatteryWriteCacheRsp.proto_property = {}

TSetNoBatteryWriteCacheRsp.default = {}

TSetNoBatteryWriteCacheRsp.struct = {}

function TSetNoBatteryWriteCacheRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetNoBatteryWriteCacheRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetNoBatteryWriteCacheRsp.proto_property, errs, need_convert)
    return self
end

function TSetNoBatteryWriteCacheRsp:unpack(_)
end

SystemsStorageController.SetNoBatteryWriteCacheRsp = TSetNoBatteryWriteCacheRsp

---@class SystemsStorageController.SetNoBatteryWriteCacheReq
---@field NoBatteryWriteCacheEnabled integer
local TSetNoBatteryWriteCacheReq = {}
TSetNoBatteryWriteCacheReq.__index = TSetNoBatteryWriteCacheReq
TSetNoBatteryWriteCacheReq.group = {}

local function TSetNoBatteryWriteCacheReq_from_obj(obj)
    return setmetatable(obj, TSetNoBatteryWriteCacheReq)
end

function TSetNoBatteryWriteCacheReq.new(NoBatteryWriteCacheEnabled)
    return TSetNoBatteryWriteCacheReq_from_obj({NoBatteryWriteCacheEnabled = NoBatteryWriteCacheEnabled})
end
---@param obj SystemsStorageController.SetNoBatteryWriteCacheReq
function TSetNoBatteryWriteCacheReq:init_from_obj(obj)
    self.NoBatteryWriteCacheEnabled = obj.NoBatteryWriteCacheEnabled
end

function TSetNoBatteryWriteCacheReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetNoBatteryWriteCacheReq.group)
end

TSetNoBatteryWriteCacheReq.from_obj = TSetNoBatteryWriteCacheReq_from_obj

TSetNoBatteryWriteCacheReq.proto_property = {'NoBatteryWriteCacheEnabled'}

TSetNoBatteryWriteCacheReq.default = {0}

TSetNoBatteryWriteCacheReq.struct = {{name = 'NoBatteryWriteCacheEnabled', is_array = false, struct = nil}}

function TSetNoBatteryWriteCacheReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NoBatteryWriteCacheEnabled', self.NoBatteryWriteCacheEnabled, 'uint8', false, errs,
        need_convert)

    TSetNoBatteryWriteCacheReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetNoBatteryWriteCacheReq.proto_property, errs, need_convert)
    return self
end

function TSetNoBatteryWriteCacheReq:unpack(_)
    return self.NoBatteryWriteCacheEnabled
end

SystemsStorageController.SetNoBatteryWriteCacheReq = TSetNoBatteryWriteCacheReq

---@class SystemsStorageController.ClearForeignConfigRsp
local TClearForeignConfigRsp = {}
TClearForeignConfigRsp.__index = TClearForeignConfigRsp
TClearForeignConfigRsp.group = {}

local function TClearForeignConfigRsp_from_obj(obj)
    return setmetatable(obj, TClearForeignConfigRsp)
end

function TClearForeignConfigRsp.new()
    return TClearForeignConfigRsp_from_obj({})
end
---@param obj SystemsStorageController.ClearForeignConfigRsp
function TClearForeignConfigRsp:init_from_obj(obj)

end

function TClearForeignConfigRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TClearForeignConfigRsp.group)
end

TClearForeignConfigRsp.from_obj = TClearForeignConfigRsp_from_obj

TClearForeignConfigRsp.proto_property = {}

TClearForeignConfigRsp.default = {}

TClearForeignConfigRsp.struct = {}

function TClearForeignConfigRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TClearForeignConfigRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TClearForeignConfigRsp.proto_property, errs, need_convert)
    return self
end

function TClearForeignConfigRsp:unpack(_)
end

SystemsStorageController.ClearForeignConfigRsp = TClearForeignConfigRsp

---@class SystemsStorageController.ClearForeignConfigReq
local TClearForeignConfigReq = {}
TClearForeignConfigReq.__index = TClearForeignConfigReq
TClearForeignConfigReq.group = {}

local function TClearForeignConfigReq_from_obj(obj)
    return setmetatable(obj, TClearForeignConfigReq)
end

function TClearForeignConfigReq.new()
    return TClearForeignConfigReq_from_obj({})
end
---@param obj SystemsStorageController.ClearForeignConfigReq
function TClearForeignConfigReq:init_from_obj(obj)

end

function TClearForeignConfigReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TClearForeignConfigReq.group)
end

TClearForeignConfigReq.from_obj = TClearForeignConfigReq_from_obj

TClearForeignConfigReq.proto_property = {}

TClearForeignConfigReq.default = {}

TClearForeignConfigReq.struct = {}

function TClearForeignConfigReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TClearForeignConfigReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TClearForeignConfigReq.proto_property, errs, need_convert)
    return self
end

function TClearForeignConfigReq:unpack(_)
end

SystemsStorageController.ClearForeignConfigReq = TClearForeignConfigReq

---@class SystemsStorageController.DumpLogRsp
---@field TaskId integer
local TDumpLogRsp = {}
TDumpLogRsp.__index = TDumpLogRsp
TDumpLogRsp.group = {}

local function TDumpLogRsp_from_obj(obj)
    return setmetatable(obj, TDumpLogRsp)
end

function TDumpLogRsp.new(TaskId)
    return TDumpLogRsp_from_obj({TaskId = TaskId})
end
---@param obj SystemsStorageController.DumpLogRsp
function TDumpLogRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TDumpLogRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDumpLogRsp.group)
end

TDumpLogRsp.from_obj = TDumpLogRsp_from_obj

TDumpLogRsp.proto_property = {'TaskId'}

TDumpLogRsp.default = {0}

TDumpLogRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TDumpLogRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TDumpLogRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDumpLogRsp.proto_property, errs, need_convert)
    return self
end

function TDumpLogRsp:unpack(_)
    return self.TaskId
end

SystemsStorageController.DumpLogRsp = TDumpLogRsp

---@class SystemsStorageController.DumpLogReq
local TDumpLogReq = {}
TDumpLogReq.__index = TDumpLogReq
TDumpLogReq.group = {}

local function TDumpLogReq_from_obj(obj)
    return setmetatable(obj, TDumpLogReq)
end

function TDumpLogReq.new()
    return TDumpLogReq_from_obj({})
end
---@param obj SystemsStorageController.DumpLogReq
function TDumpLogReq:init_from_obj(obj)

end

function TDumpLogReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDumpLogReq.group)
end

TDumpLogReq.from_obj = TDumpLogReq_from_obj

TDumpLogReq.proto_property = {}

TDumpLogReq.default = {}

TDumpLogReq.struct = {}

function TDumpLogReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TDumpLogReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDumpLogReq.proto_property, errs, need_convert)
    return self
end

function TDumpLogReq:unpack(_)
end

SystemsStorageController.DumpLogReq = TDumpLogReq

---@class SystemsStorageController.ImportForeignConfigRsp
local TImportForeignConfigRsp = {}
TImportForeignConfigRsp.__index = TImportForeignConfigRsp
TImportForeignConfigRsp.group = {}

local function TImportForeignConfigRsp_from_obj(obj)
    return setmetatable(obj, TImportForeignConfigRsp)
end

function TImportForeignConfigRsp.new()
    return TImportForeignConfigRsp_from_obj({})
end
---@param obj SystemsStorageController.ImportForeignConfigRsp
function TImportForeignConfigRsp:init_from_obj(obj)

end

function TImportForeignConfigRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportForeignConfigRsp.group)
end

TImportForeignConfigRsp.from_obj = TImportForeignConfigRsp_from_obj

TImportForeignConfigRsp.proto_property = {}

TImportForeignConfigRsp.default = {}

TImportForeignConfigRsp.struct = {}

function TImportForeignConfigRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TImportForeignConfigRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportForeignConfigRsp.proto_property, errs, need_convert)
    return self
end

function TImportForeignConfigRsp:unpack(_)
end

SystemsStorageController.ImportForeignConfigRsp = TImportForeignConfigRsp

---@class SystemsStorageController.ImportForeignConfigReq
local TImportForeignConfigReq = {}
TImportForeignConfigReq.__index = TImportForeignConfigReq
TImportForeignConfigReq.group = {}

local function TImportForeignConfigReq_from_obj(obj)
    return setmetatable(obj, TImportForeignConfigReq)
end

function TImportForeignConfigReq.new()
    return TImportForeignConfigReq_from_obj({})
end
---@param obj SystemsStorageController.ImportForeignConfigReq
function TImportForeignConfigReq:init_from_obj(obj)

end

function TImportForeignConfigReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportForeignConfigReq.group)
end

TImportForeignConfigReq.from_obj = TImportForeignConfigReq_from_obj

TImportForeignConfigReq.proto_property = {}

TImportForeignConfigReq.default = {}

TImportForeignConfigReq.struct = {}

function TImportForeignConfigReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TImportForeignConfigReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportForeignConfigReq.proto_property, errs, need_convert)
    return self
end

function TImportForeignConfigReq:unpack(_)
end

SystemsStorageController.ImportForeignConfigReq = TImportForeignConfigReq

---@class SystemsStorageController.SetWorkModeRsp
local TSetWorkModeRsp = {}
TSetWorkModeRsp.__index = TSetWorkModeRsp
TSetWorkModeRsp.group = {}

local function TSetWorkModeRsp_from_obj(obj)
    return setmetatable(obj, TSetWorkModeRsp)
end

function TSetWorkModeRsp.new()
    return TSetWorkModeRsp_from_obj({})
end
---@param obj SystemsStorageController.SetWorkModeRsp
function TSetWorkModeRsp:init_from_obj(obj)

end

function TSetWorkModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetWorkModeRsp.group)
end

TSetWorkModeRsp.from_obj = TSetWorkModeRsp_from_obj

TSetWorkModeRsp.proto_property = {}

TSetWorkModeRsp.default = {}

TSetWorkModeRsp.struct = {}

function TSetWorkModeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetWorkModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetWorkModeRsp.proto_property, errs, need_convert)
    return self
end

function TSetWorkModeRsp:unpack(_)
end

SystemsStorageController.SetWorkModeRsp = TSetWorkModeRsp

---@class SystemsStorageController.SetWorkModeReq
---@field Mode integer
---@field ProfileId integer
local TSetWorkModeReq = {}
TSetWorkModeReq.__index = TSetWorkModeReq
TSetWorkModeReq.group = {}

local function TSetWorkModeReq_from_obj(obj)
    return setmetatable(obj, TSetWorkModeReq)
end

function TSetWorkModeReq.new(Mode, ProfileId)
    return TSetWorkModeReq_from_obj({Mode = Mode, ProfileId = ProfileId})
end
---@param obj SystemsStorageController.SetWorkModeReq
function TSetWorkModeReq:init_from_obj(obj)
    self.Mode = obj.Mode
    self.ProfileId = obj.ProfileId
end

function TSetWorkModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetWorkModeReq.group)
end

TSetWorkModeReq.from_obj = TSetWorkModeReq_from_obj

TSetWorkModeReq.proto_property = {'Mode', 'ProfileId'}

TSetWorkModeReq.default = {0, 0}

TSetWorkModeReq.struct = {
    {name = 'Mode', is_array = false, struct = nil}, {name = 'ProfileId', is_array = false, struct = nil}
}

function TSetWorkModeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Mode', self.Mode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ProfileId', self.ProfileId, 'uint8', false, errs, need_convert)

    TSetWorkModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetWorkModeReq.proto_property, errs, need_convert)
    return self
end

function TSetWorkModeReq:unpack(_)
    return self.Mode, self.ProfileId
end

SystemsStorageController.SetWorkModeReq = TSetWorkModeReq

---@class SystemsStorageController.SetCopybackStateRsp
local TSetCopybackStateRsp = {}
TSetCopybackStateRsp.__index = TSetCopybackStateRsp
TSetCopybackStateRsp.group = {}

local function TSetCopybackStateRsp_from_obj(obj)
    return setmetatable(obj, TSetCopybackStateRsp)
end

function TSetCopybackStateRsp.new()
    return TSetCopybackStateRsp_from_obj({})
end
---@param obj SystemsStorageController.SetCopybackStateRsp
function TSetCopybackStateRsp:init_from_obj(obj)

end

function TSetCopybackStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCopybackStateRsp.group)
end

TSetCopybackStateRsp.from_obj = TSetCopybackStateRsp_from_obj

TSetCopybackStateRsp.proto_property = {}

TSetCopybackStateRsp.default = {}

TSetCopybackStateRsp.struct = {}

function TSetCopybackStateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetCopybackStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCopybackStateRsp.proto_property, errs, need_convert)
    return self
end

function TSetCopybackStateRsp:unpack(_)
end

SystemsStorageController.SetCopybackStateRsp = TSetCopybackStateRsp

---@class SystemsStorageController.SetCopybackStateReq
---@field State integer
local TSetCopybackStateReq = {}
TSetCopybackStateReq.__index = TSetCopybackStateReq
TSetCopybackStateReq.group = {}

local function TSetCopybackStateReq_from_obj(obj)
    return setmetatable(obj, TSetCopybackStateReq)
end

function TSetCopybackStateReq.new(State)
    return TSetCopybackStateReq_from_obj({State = State})
end
---@param obj SystemsStorageController.SetCopybackStateReq
function TSetCopybackStateReq:init_from_obj(obj)
    self.State = obj.State
end

function TSetCopybackStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCopybackStateReq.group)
end

TSetCopybackStateReq.from_obj = TSetCopybackStateReq_from_obj

TSetCopybackStateReq.proto_property = {'State'}

TSetCopybackStateReq.default = {0}

TSetCopybackStateReq.struct = {{name = 'State', is_array = false, struct = nil}}

function TSetCopybackStateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'State', self.State, 'uint8', false, errs, need_convert)

    TSetCopybackStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCopybackStateReq.proto_property, errs, need_convert)
    return self
end

function TSetCopybackStateReq:unpack(_)
    return self.State
end

SystemsStorageController.SetCopybackStateReq = TSetCopybackStateReq

---@class SystemsStorageController.RestoreDefaultSettingsRsp
local TRestoreDefaultSettingsRsp = {}
TRestoreDefaultSettingsRsp.__index = TRestoreDefaultSettingsRsp
TRestoreDefaultSettingsRsp.group = {}

local function TRestoreDefaultSettingsRsp_from_obj(obj)
    return setmetatable(obj, TRestoreDefaultSettingsRsp)
end

function TRestoreDefaultSettingsRsp.new()
    return TRestoreDefaultSettingsRsp_from_obj({})
end
---@param obj SystemsStorageController.RestoreDefaultSettingsRsp
function TRestoreDefaultSettingsRsp:init_from_obj(obj)

end

function TRestoreDefaultSettingsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRestoreDefaultSettingsRsp.group)
end

TRestoreDefaultSettingsRsp.from_obj = TRestoreDefaultSettingsRsp_from_obj

TRestoreDefaultSettingsRsp.proto_property = {}

TRestoreDefaultSettingsRsp.default = {}

TRestoreDefaultSettingsRsp.struct = {}

function TRestoreDefaultSettingsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TRestoreDefaultSettingsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRestoreDefaultSettingsRsp.proto_property, errs, need_convert)
    return self
end

function TRestoreDefaultSettingsRsp:unpack(_)
end

SystemsStorageController.RestoreDefaultSettingsRsp = TRestoreDefaultSettingsRsp

---@class SystemsStorageController.RestoreDefaultSettingsReq
local TRestoreDefaultSettingsReq = {}
TRestoreDefaultSettingsReq.__index = TRestoreDefaultSettingsReq
TRestoreDefaultSettingsReq.group = {}

local function TRestoreDefaultSettingsReq_from_obj(obj)
    return setmetatable(obj, TRestoreDefaultSettingsReq)
end

function TRestoreDefaultSettingsReq.new()
    return TRestoreDefaultSettingsReq_from_obj({})
end
---@param obj SystemsStorageController.RestoreDefaultSettingsReq
function TRestoreDefaultSettingsReq:init_from_obj(obj)

end

function TRestoreDefaultSettingsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRestoreDefaultSettingsReq.group)
end

TRestoreDefaultSettingsReq.from_obj = TRestoreDefaultSettingsReq_from_obj

TRestoreDefaultSettingsReq.proto_property = {}

TRestoreDefaultSettingsReq.default = {}

TRestoreDefaultSettingsReq.struct = {}

function TRestoreDefaultSettingsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TRestoreDefaultSettingsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRestoreDefaultSettingsReq.proto_property, errs, need_convert)
    return self
end

function TRestoreDefaultSettingsReq:unpack(_)
end

SystemsStorageController.RestoreDefaultSettingsReq = TRestoreDefaultSettingsReq

---@class SystemsStorageController.SetSmarterCopyBackStateRsp
local TSetSmarterCopyBackStateRsp = {}
TSetSmarterCopyBackStateRsp.__index = TSetSmarterCopyBackStateRsp
TSetSmarterCopyBackStateRsp.group = {}

local function TSetSmarterCopyBackStateRsp_from_obj(obj)
    return setmetatable(obj, TSetSmarterCopyBackStateRsp)
end

function TSetSmarterCopyBackStateRsp.new()
    return TSetSmarterCopyBackStateRsp_from_obj({})
end
---@param obj SystemsStorageController.SetSmarterCopyBackStateRsp
function TSetSmarterCopyBackStateRsp:init_from_obj(obj)

end

function TSetSmarterCopyBackStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSmarterCopyBackStateRsp.group)
end

TSetSmarterCopyBackStateRsp.from_obj = TSetSmarterCopyBackStateRsp_from_obj

TSetSmarterCopyBackStateRsp.proto_property = {}

TSetSmarterCopyBackStateRsp.default = {}

TSetSmarterCopyBackStateRsp.struct = {}

function TSetSmarterCopyBackStateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetSmarterCopyBackStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSmarterCopyBackStateRsp.proto_property, errs, need_convert)
    return self
end

function TSetSmarterCopyBackStateRsp:unpack(_)
end

SystemsStorageController.SetSmarterCopyBackStateRsp = TSetSmarterCopyBackStateRsp

---@class SystemsStorageController.SetSmarterCopyBackStateReq
---@field State integer
local TSetSmarterCopyBackStateReq = {}
TSetSmarterCopyBackStateReq.__index = TSetSmarterCopyBackStateReq
TSetSmarterCopyBackStateReq.group = {}

local function TSetSmarterCopyBackStateReq_from_obj(obj)
    return setmetatable(obj, TSetSmarterCopyBackStateReq)
end

function TSetSmarterCopyBackStateReq.new(State)
    return TSetSmarterCopyBackStateReq_from_obj({State = State})
end
---@param obj SystemsStorageController.SetSmarterCopyBackStateReq
function TSetSmarterCopyBackStateReq:init_from_obj(obj)
    self.State = obj.State
end

function TSetSmarterCopyBackStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSmarterCopyBackStateReq.group)
end

TSetSmarterCopyBackStateReq.from_obj = TSetSmarterCopyBackStateReq_from_obj

TSetSmarterCopyBackStateReq.proto_property = {'State'}

TSetSmarterCopyBackStateReq.default = {0}

TSetSmarterCopyBackStateReq.struct = {{name = 'State', is_array = false, struct = nil}}

function TSetSmarterCopyBackStateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'State', self.State, 'uint8', false, errs, need_convert)

    TSetSmarterCopyBackStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSmarterCopyBackStateReq.proto_property, errs, need_convert)
    return self
end

function TSetSmarterCopyBackStateReq:unpack(_)
    return self.State
end

SystemsStorageController.SetSmarterCopyBackStateReq = TSetSmarterCopyBackStateReq

---@class SystemsStorageController.SetJBODStateRsp
local TSetJBODStateRsp = {}
TSetJBODStateRsp.__index = TSetJBODStateRsp
TSetJBODStateRsp.group = {}

local function TSetJBODStateRsp_from_obj(obj)
    return setmetatable(obj, TSetJBODStateRsp)
end

function TSetJBODStateRsp.new()
    return TSetJBODStateRsp_from_obj({})
end
---@param obj SystemsStorageController.SetJBODStateRsp
function TSetJBODStateRsp:init_from_obj(obj)

end

function TSetJBODStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetJBODStateRsp.group)
end

TSetJBODStateRsp.from_obj = TSetJBODStateRsp_from_obj

TSetJBODStateRsp.proto_property = {}

TSetJBODStateRsp.default = {}

TSetJBODStateRsp.struct = {}

function TSetJBODStateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetJBODStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetJBODStateRsp.proto_property, errs, need_convert)
    return self
end

function TSetJBODStateRsp:unpack(_)
end

SystemsStorageController.SetJBODStateRsp = TSetJBODStateRsp

---@class SystemsStorageController.SetJBODStateReq
---@field State integer
local TSetJBODStateReq = {}
TSetJBODStateReq.__index = TSetJBODStateReq
TSetJBODStateReq.group = {}

local function TSetJBODStateReq_from_obj(obj)
    return setmetatable(obj, TSetJBODStateReq)
end

function TSetJBODStateReq.new(State)
    return TSetJBODStateReq_from_obj({State = State})
end
---@param obj SystemsStorageController.SetJBODStateReq
function TSetJBODStateReq:init_from_obj(obj)
    self.State = obj.State
end

function TSetJBODStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetJBODStateReq.group)
end

TSetJBODStateReq.from_obj = TSetJBODStateReq_from_obj

TSetJBODStateReq.proto_property = {'State'}

TSetJBODStateReq.default = {0}

TSetJBODStateReq.struct = {{name = 'State', is_array = false, struct = nil}}

function TSetJBODStateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'State', self.State, 'uint8', false, errs, need_convert)

    TSetJBODStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetJBODStateReq.proto_property, errs, need_convert)
    return self
end

function TSetJBODStateReq:unpack(_)
    return self.State
end

SystemsStorageController.SetJBODStateReq = TSetJBODStateReq

---@class SystemsStorageController.SetBootDevicesRsp
local TSetBootDevicesRsp = {}
TSetBootDevicesRsp.__index = TSetBootDevicesRsp
TSetBootDevicesRsp.group = {}

local function TSetBootDevicesRsp_from_obj(obj)
    return setmetatable(obj, TSetBootDevicesRsp)
end

function TSetBootDevicesRsp.new()
    return TSetBootDevicesRsp_from_obj({})
end
---@param obj SystemsStorageController.SetBootDevicesRsp
function TSetBootDevicesRsp:init_from_obj(obj)

end

function TSetBootDevicesRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootDevicesRsp.group)
end

TSetBootDevicesRsp.from_obj = TSetBootDevicesRsp_from_obj

TSetBootDevicesRsp.proto_property = {}

TSetBootDevicesRsp.default = {}

TSetBootDevicesRsp.struct = {}

function TSetBootDevicesRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetBootDevicesRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootDevicesRsp.proto_property, errs, need_convert)
    return self
end

function TSetBootDevicesRsp:unpack(_)
end

SystemsStorageController.SetBootDevicesRsp = TSetBootDevicesRsp

---@class SystemsStorageController.SetBootDevicesReq
---@field PriorityDriveName string
---@field SecondaryDriveName string
local TSetBootDevicesReq = {}
TSetBootDevicesReq.__index = TSetBootDevicesReq
TSetBootDevicesReq.group = {}

local function TSetBootDevicesReq_from_obj(obj)
    return setmetatable(obj, TSetBootDevicesReq)
end

function TSetBootDevicesReq.new(PriorityDriveName, SecondaryDriveName)
    return TSetBootDevicesReq_from_obj({PriorityDriveName = PriorityDriveName, SecondaryDriveName = SecondaryDriveName})
end
---@param obj SystemsStorageController.SetBootDevicesReq
function TSetBootDevicesReq:init_from_obj(obj)
    self.PriorityDriveName = obj.PriorityDriveName
    self.SecondaryDriveName = obj.SecondaryDriveName
end

function TSetBootDevicesReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootDevicesReq.group)
end

TSetBootDevicesReq.from_obj = TSetBootDevicesReq_from_obj

TSetBootDevicesReq.proto_property = {'PriorityDriveName', 'SecondaryDriveName'}

TSetBootDevicesReq.default = {'', ''}

TSetBootDevicesReq.struct = {
    {name = 'PriorityDriveName', is_array = false, struct = nil},
    {name = 'SecondaryDriveName', is_array = false, struct = nil}
}

function TSetBootDevicesReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PriorityDriveName', self.PriorityDriveName, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SecondaryDriveName', self.SecondaryDriveName, 'string', false, errs, need_convert)

    TSetBootDevicesReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootDevicesReq.proto_property, errs, need_convert)
    return self
end

function TSetBootDevicesReq:unpack(_)
    return self.PriorityDriveName, self.SecondaryDriveName
end

SystemsStorageController.SetBootDevicesReq = TSetBootDevicesReq

SystemsStorageController.interface = mdb.register_interface('bmc.kepler.Systems.Storage.Controller', {
    Id = {'y', nil, true, 255, false},
    Type = {'s', nil, true, nil, false},
    TypeId = {'y', nil, true, nil, false},
    DeviceName = {'s', nil, true, nil, false},
    Position = {'s', nil, true, nil, false},
    TemperatureCelsius = {'n', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    TemperatureAbnormal = {'y', nil, true, nil, false},
    Name = {'s', nil, true, nil, false},
    OOBSupport = {'y', nil, true, nil, false},
    FirmwareVersion = {'s', nil, true, nil, false},
    SupportedMode = {'as', nil, true, nil, false},
    MemorySizeMiB = {'q', nil, true, nil, false},
    DeviceInterface = {'s', nil, true, nil, false},
    SASAddr = {'s', nil, true, nil, false},
    SerialNumber = {'s', nil, true, nil, false},
    MaxStripSizeBytes = {'u', nil, true, nil, false},
    MinStripSizeBytes = {'u', nil, true, nil, false},
    NVDataVersion = {'s', nil, true, nil, false},
    MaintainPDFailHistrory = {'y', nil, true, nil, false},
    PCIeLinkWidth = {'s', nil, true, nil, false},
    UnconfiguredDriveWriteCachePolicy = {'s', nil, true, nil, false},
    HBADriveWriteCachePolicy = {'s', nil, true, nil, false},
    ConfiguredDriveWriteCachePolicy = {'s', nil, true, nil, false},
    SupportedRAIDTypes = {'as', nil, true, nil, false},
    SmarterCopyBackState = {'y', nil, true, nil, false},
    CopyBackState = {'y', nil, true, nil, false},
    BootDevices = {'as', nil, true, nil, false},
    HardwareRevision = {'s', nil, true, nil, false},
    HotSpareActivationMode = {'s', nil, true, nil, false},
    NoBatteryWriteCacheEnabled = {'y', nil, true, 255, false},
    ReadCachePercent = {'y', nil, true, 255, false},
    JBODState = {'y', nil, true, nil, false},
    CachePinnedState = {'y', nil, true, nil, false},
    DDREccCount = {'q', nil, true, nil, false},
    WorkMode = {'s', nil, true, nil, false},
    RefDrives = {'as', nil, true, nil, false},
    BOMNumber = {'s', nil, true, nil, false},
    CryptoEraseSupported = {'b', nil, true, nil, false}
}, {
    SetBootDevices = {'a{ss}ss', '', TSetBootDevicesReq, TSetBootDevicesRsp},
    SetJBODState = {'a{ss}y', '', TSetJBODStateReq, TSetJBODStateRsp},
    SetSmarterCopyBackState = {'a{ss}y', '', TSetSmarterCopyBackStateReq, TSetSmarterCopyBackStateRsp},
    RestoreDefaultSettings = {'a{ss}', '', TRestoreDefaultSettingsReq, TRestoreDefaultSettingsRsp},
    SetCopybackState = {'a{ss}y', '', TSetCopybackStateReq, TSetCopybackStateRsp},
    SetWorkMode = {'a{ss}yy', '', TSetWorkModeReq, TSetWorkModeRsp},
    ImportForeignConfig = {'a{ss}', '', TImportForeignConfigReq, TImportForeignConfigRsp},
    DumpLog = {'a{ss}', 'u', TDumpLogReq, TDumpLogRsp},
    ClearForeignConfig = {'a{ss}', '', TClearForeignConfigReq, TClearForeignConfigRsp},
    SetNoBatteryWriteCache = {'a{ss}y', '', TSetNoBatteryWriteCacheReq, TSetNoBatteryWriteCacheRsp},
    SetReadCachePercent = {'a{ss}y', '', TSetReadCachePercentReq, TSetReadCachePercentRsp},
    SetWriteCachePolicy = {'a{ss}ss', '', TSetWriteCachePolicyReq, TSetWriteCachePolicyRsp}
}, {})

return SystemsStorageController
