-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local ReleaseStorageController = {}

---@class ReleaseStorageController.GetControllerInfoReq
---@field ControllerId integer
local TGetControllerInfoReq = {}
TGetControllerInfoReq.__index = TGetControllerInfoReq
TGetControllerInfoReq.group = {}

local function TGetControllerInfoReq_from_obj(obj)
    return setmetatable(obj, TGetControllerInfoReq)
end

function TGetControllerInfoReq.new(ControllerId)
    return TGetControllerInfoReq_from_obj({ControllerId = ControllerId})
end
---@param obj ReleaseStorageController.GetControllerInfoReq
function TGetControllerInfoReq:init_from_obj(obj)
    self.ControllerId = obj.ControllerId
end

function TGetControllerInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetControllerInfoReq.group)
end

TGetControllerInfoReq.from_obj = TGetControllerInfoReq_from_obj

TGetControllerInfoReq.proto_property = {'ControllerId'}

TGetControllerInfoReq.default = {0}

TGetControllerInfoReq.descriptions = {[=[The Id of controller.]=]}

TGetControllerInfoReq.struct = {{name = 'ControllerId', is_array = false, struct = nil}}

function TGetControllerInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)

    TGetControllerInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetControllerInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetControllerInfoReq:unpack(_)
    return self.ControllerId
end

ReleaseStorageController.GetControllerInfoReq = TGetControllerInfoReq

---@class ReleaseStorageController.Details
---@field key string
---@field value string
local TDetails = {}
TDetails.__index = TDetails
TDetails.group = {}

local function TDetails_from_obj(obj)
    return setmetatable(obj, TDetails)
end

function TDetails.new(dict)
    return TDetails_from_obj(dict)
end

---@param obj ReleaseStorageController.Details
function TDetails:init_from_obj(obj)
    self = obj
end

function TDetails:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDetails.group)
end

TDetails.from_obj = TDetails_from_obj

TDetails.proto_property = {}

TDetails.default = {}

TDetails.struct = {}

function TDetails:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TDetails:remove_error_props(errs, self)
    return self
end

function TDetails:unpack(_)
    return self
end

ReleaseStorageController.Details = TDetails

---@class ReleaseStorageController.GetControllerInfoRsp
---@field Details ReleaseStorageController.Details
local TGetControllerInfoRsp = {}
TGetControllerInfoRsp.__index = TGetControllerInfoRsp
TGetControllerInfoRsp.group = {}

local function TGetControllerInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetControllerInfoRsp)
end

function TGetControllerInfoRsp.new(Details)
    return TGetControllerInfoRsp_from_obj({Details = Details})
end
---@param obj ReleaseStorageController.GetControllerInfoRsp
function TGetControllerInfoRsp:init_from_obj(obj)
    self.Details = obj.Details
end

function TGetControllerInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetControllerInfoRsp.group)
end

TGetControllerInfoRsp.from_obj = TGetControllerInfoRsp_from_obj

TGetControllerInfoRsp.proto_property = {'Details'}

TGetControllerInfoRsp.default = {ReleaseStorageController.Details.default}

TGetControllerInfoRsp.struct = {{name = 'Details', is_array = false, struct = ReleaseStorageController.Details.struct}}

function TGetControllerInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    ReleaseStorageController.Details.new(self.Details):validate(prefix, errs, need_convert)

    TGetControllerInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetControllerInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetControllerInfoRsp:unpack(_)
    return self.Details
end

ReleaseStorageController.GetControllerInfoRsp = TGetControllerInfoRsp

ReleaseStorageController.interface = mdb.register_interface('bmc.kepler.Release.Storage.Controller', {}, {
    GetControllerInfo = {
        'a{ss}y', 'a{ss}', TGetControllerInfoReq, TGetControllerInfoRsp,
        [=[Get the running information of controller.]=]
    }
}, {})

return ReleaseStorageController
