-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local RecordDriveSpareBlock = {}

---@class RecordDriveSpareBlock.MockRecordSpareBlockRsp
local TMockRecordSpareBlockRsp = {}
TMockRecordSpareBlockRsp.__index = TMockRecordSpareBlockRsp
TMockRecordSpareBlockRsp.group = {}

local function TMockRecordSpareBlockRsp_from_obj(obj)
    return setmetatable(obj, TMockRecordSpareBlockRsp)
end

function TMockRecordSpareBlockRsp.new()
    return TMockRecordSpareBlockRsp_from_obj({})
end
---@param obj RecordDriveSpareBlock.MockRecordSpareBlockRsp
function TMockRecordSpareBlockRsp:init_from_obj(obj)

end

function TMockRecordSpareBlockRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMockRecordSpareBlockRsp.group)
end

TMockRecordSpareBlockRsp.from_obj = TMockRecordSpareBlockRsp_from_obj

TMockRecordSpareBlockRsp.proto_property = {}

TMockRecordSpareBlockRsp.default = {}

TMockRecordSpareBlockRsp.struct = {}

function TMockRecordSpareBlockRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TMockRecordSpareBlockRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMockRecordSpareBlockRsp.proto_property, errs, need_convert)
    return self
end

function TMockRecordSpareBlockRsp:unpack(_)
end

RecordDriveSpareBlock.MockRecordSpareBlockRsp = TMockRecordSpareBlockRsp

---@class RecordDriveSpareBlock.MockRecordSpareBlockReq
---@field Id integer
---@field SlcSpareBlock integer
---@field TlcSpareBlock integer
local TMockRecordSpareBlockReq = {}
TMockRecordSpareBlockReq.__index = TMockRecordSpareBlockReq
TMockRecordSpareBlockReq.group = {}

local function TMockRecordSpareBlockReq_from_obj(obj)
    return setmetatable(obj, TMockRecordSpareBlockReq)
end

function TMockRecordSpareBlockReq.new(Id, SlcSpareBlock, TlcSpareBlock)
    return TMockRecordSpareBlockReq_from_obj({Id = Id, SlcSpareBlock = SlcSpareBlock, TlcSpareBlock = TlcSpareBlock})
end
---@param obj RecordDriveSpareBlock.MockRecordSpareBlockReq
function TMockRecordSpareBlockReq:init_from_obj(obj)
    self.Id = obj.Id
    self.SlcSpareBlock = obj.SlcSpareBlock
    self.TlcSpareBlock = obj.TlcSpareBlock
end

function TMockRecordSpareBlockReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMockRecordSpareBlockReq.group)
end

TMockRecordSpareBlockReq.from_obj = TMockRecordSpareBlockReq_from_obj

TMockRecordSpareBlockReq.proto_property = {'Id', 'SlcSpareBlock', 'TlcSpareBlock'}

TMockRecordSpareBlockReq.default = {0, 0, 0}

TMockRecordSpareBlockReq.struct = {
    {name = 'Id', is_array = false, struct = nil}, {name = 'SlcSpareBlock', is_array = false, struct = nil},
    {name = 'TlcSpareBlock', is_array = false, struct = nil}
}

function TMockRecordSpareBlockReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Id', self.Id, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SlcSpareBlock', self.SlcSpareBlock, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'TlcSpareBlock', self.TlcSpareBlock, 'uint8', false, errs, need_convert)

    TMockRecordSpareBlockReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMockRecordSpareBlockReq.proto_property, errs, need_convert)
    return self
end

function TMockRecordSpareBlockReq:unpack(_)
    return self.Id, self.SlcSpareBlock, self.TlcSpareBlock
end

RecordDriveSpareBlock.MockRecordSpareBlockReq = TMockRecordSpareBlockReq

RecordDriveSpareBlock.interface = mdb.register_interface('bmc.kepler.Debug.Storage.RecordDriveSpareBlock', {}, {
    MockRecordSpareBlock = {'a{ss}yyy', '', TMockRecordSpareBlockReq, TMockRecordSpareBlockRsp}
}, {})

return RecordDriveSpareBlock
