-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local PhyError = {}

---@class PhyError.RunningDisparityErrorCount
---@field RunningDisparityErrorCount integer
local TRunningDisparityErrorCount = {}
TRunningDisparityErrorCount.__index = TRunningDisparityErrorCount
TRunningDisparityErrorCount.group = {}

local function TRunningDisparityErrorCount_from_obj(obj)
    return setmetatable(obj, TRunningDisparityErrorCount)
end

function TRunningDisparityErrorCount.new(RunningDisparityErrorCount)
    return TRunningDisparityErrorCount_from_obj({RunningDisparityErrorCount = RunningDisparityErrorCount})
end
---@param obj PhyError.RunningDisparityErrorCount
function TRunningDisparityErrorCount:init_from_obj(obj)
    self.RunningDisparityErrorCount = obj.RunningDisparityErrorCount
end

function TRunningDisparityErrorCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRunningDisparityErrorCount.group)
end

TRunningDisparityErrorCount.from_obj = TRunningDisparityErrorCount_from_obj

TRunningDisparityErrorCount.proto_property = {'RunningDisparityErrorCount'}

TRunningDisparityErrorCount.default = {0}

TRunningDisparityErrorCount.struct = {{name = 'RunningDisparityErrorCount', is_array = false, struct = nil}}

function TRunningDisparityErrorCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RunningDisparityErrorCount', self.RunningDisparityErrorCount, 'uint32', true, errs,
        need_convert)

    TRunningDisparityErrorCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRunningDisparityErrorCount.proto_property, errs, need_convert)
    return self
end

function TRunningDisparityErrorCount:unpack(_)
    return self.RunningDisparityErrorCount
end

PhyError.RunningDisparityErrorCount = TRunningDisparityErrorCount

---@class PhyError.PhyResetProblemCount
---@field PhyResetProblemCount integer
local TPhyResetProblemCount = {}
TPhyResetProblemCount.__index = TPhyResetProblemCount
TPhyResetProblemCount.group = {}

local function TPhyResetProblemCount_from_obj(obj)
    return setmetatable(obj, TPhyResetProblemCount)
end

function TPhyResetProblemCount.new(PhyResetProblemCount)
    return TPhyResetProblemCount_from_obj({PhyResetProblemCount = PhyResetProblemCount})
end
---@param obj PhyError.PhyResetProblemCount
function TPhyResetProblemCount:init_from_obj(obj)
    self.PhyResetProblemCount = obj.PhyResetProblemCount
end

function TPhyResetProblemCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPhyResetProblemCount.group)
end

TPhyResetProblemCount.from_obj = TPhyResetProblemCount_from_obj

TPhyResetProblemCount.proto_property = {'PhyResetProblemCount'}

TPhyResetProblemCount.default = {0}

TPhyResetProblemCount.struct = {{name = 'PhyResetProblemCount', is_array = false, struct = nil}}

function TPhyResetProblemCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PhyResetProblemCount', self.PhyResetProblemCount, 'uint32', true, errs, need_convert)

    TPhyResetProblemCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPhyResetProblemCount.proto_property, errs, need_convert)
    return self
end

function TPhyResetProblemCount:unpack(_)
    return self.PhyResetProblemCount
end

PhyError.PhyResetProblemCount = TPhyResetProblemCount

---@class PhyError.LossDwordSyncCount
---@field LossDwordSyncCount integer
local TLossDwordSyncCount = {}
TLossDwordSyncCount.__index = TLossDwordSyncCount
TLossDwordSyncCount.group = {}

local function TLossDwordSyncCount_from_obj(obj)
    return setmetatable(obj, TLossDwordSyncCount)
end

function TLossDwordSyncCount.new(LossDwordSyncCount)
    return TLossDwordSyncCount_from_obj({LossDwordSyncCount = LossDwordSyncCount})
end
---@param obj PhyError.LossDwordSyncCount
function TLossDwordSyncCount:init_from_obj(obj)
    self.LossDwordSyncCount = obj.LossDwordSyncCount
end

function TLossDwordSyncCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLossDwordSyncCount.group)
end

TLossDwordSyncCount.from_obj = TLossDwordSyncCount_from_obj

TLossDwordSyncCount.proto_property = {'LossDwordSyncCount'}

TLossDwordSyncCount.default = {0}

TLossDwordSyncCount.struct = {{name = 'LossDwordSyncCount', is_array = false, struct = nil}}

function TLossDwordSyncCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LossDwordSyncCount', self.LossDwordSyncCount, 'uint32', true, errs, need_convert)

    TLossDwordSyncCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLossDwordSyncCount.proto_property, errs, need_convert)
    return self
end

function TLossDwordSyncCount:unpack(_)
    return self.LossDwordSyncCount
end

PhyError.LossDwordSyncCount = TLossDwordSyncCount

---@class PhyError.InvalidDwordCount
---@field InvalidDwordCount integer
local TInvalidDwordCount = {}
TInvalidDwordCount.__index = TInvalidDwordCount
TInvalidDwordCount.group = {}

local function TInvalidDwordCount_from_obj(obj)
    return setmetatable(obj, TInvalidDwordCount)
end

function TInvalidDwordCount.new(InvalidDwordCount)
    return TInvalidDwordCount_from_obj({InvalidDwordCount = InvalidDwordCount})
end
---@param obj PhyError.InvalidDwordCount
function TInvalidDwordCount:init_from_obj(obj)
    self.InvalidDwordCount = obj.InvalidDwordCount
end

function TInvalidDwordCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInvalidDwordCount.group)
end

TInvalidDwordCount.from_obj = TInvalidDwordCount_from_obj

TInvalidDwordCount.proto_property = {'InvalidDwordCount'}

TInvalidDwordCount.default = {0}

TInvalidDwordCount.struct = {{name = 'InvalidDwordCount', is_array = false, struct = nil}}

function TInvalidDwordCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InvalidDwordCount', self.InvalidDwordCount, 'uint32', true, errs, need_convert)

    TInvalidDwordCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInvalidDwordCount.proto_property, errs, need_convert)
    return self
end

function TInvalidDwordCount:unpack(_)
    return self.InvalidDwordCount
end

PhyError.InvalidDwordCount = TInvalidDwordCount

---@class PhyError.PhyId
---@field PhyId integer
local TPhyId = {}
TPhyId.__index = TPhyId
TPhyId.group = {}

local function TPhyId_from_obj(obj)
    return setmetatable(obj, TPhyId)
end

function TPhyId.new(PhyId)
    return TPhyId_from_obj({PhyId = PhyId})
end
---@param obj PhyError.PhyId
function TPhyId:init_from_obj(obj)
    self.PhyId = obj.PhyId
end

function TPhyId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPhyId.group)
end

TPhyId.from_obj = TPhyId_from_obj

TPhyId.proto_property = {'PhyId'}

TPhyId.default = {0}

TPhyId.struct = {{name = 'PhyId', is_array = false, struct = nil}}

function TPhyId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PhyId', self.PhyId, 'uint8', true, errs, need_convert)

    TPhyId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPhyId.proto_property, errs, need_convert)
    return self
end

function TPhyId:unpack(_)
    return self.PhyId
end

PhyError.PhyId = TPhyId

PhyError.interface = mdb.register_interface('bmc.kepler.Systems.Storage.PhyError', {
    PhyId = {'y', {}, true, nil, false},
    InvalidDwordCount = {'u', {}, true, nil, false},
    LossDwordSyncCount = {'u', {}, true, nil, false},
    PhyResetProblemCount = {'u', {}, true, nil, false},
    RunningDisparityErrorCount = {'u', {}, true, nil, false}
}, {}, {})

return PhyError
