-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local PhyBitError = {}

---@class PhyBitError.FileMockEnabled
---@field FileMockEnabled boolean
local TFileMockEnabled = {}
TFileMockEnabled.__index = TFileMockEnabled
TFileMockEnabled.group = {}

local function TFileMockEnabled_from_obj(obj)
    return setmetatable(obj, TFileMockEnabled)
end

function TFileMockEnabled.new(FileMockEnabled)
    return TFileMockEnabled_from_obj({FileMockEnabled = FileMockEnabled})
end
---@param obj PhyBitError.FileMockEnabled
function TFileMockEnabled:init_from_obj(obj)
    self.FileMockEnabled = obj.FileMockEnabled
end

function TFileMockEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFileMockEnabled.group)
end

TFileMockEnabled.from_obj = TFileMockEnabled_from_obj

TFileMockEnabled.proto_property = {'FileMockEnabled'}

TFileMockEnabled.default = {false}

TFileMockEnabled.struct = {{name = 'FileMockEnabled', is_array = false, struct = nil}}

function TFileMockEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FileMockEnabled', self.FileMockEnabled, 'bool', false, errs, need_convert)

    TFileMockEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFileMockEnabled.proto_property, errs, need_convert)
    return self
end

function TFileMockEnabled:unpack(_)
    return self.FileMockEnabled
end

PhyBitError.FileMockEnabled = TFileMockEnabled

---@class PhyBitError.MockDataRsp
---@field MockResult integer
local TMockDataRsp = {}
TMockDataRsp.__index = TMockDataRsp
TMockDataRsp.group = {}

local function TMockDataRsp_from_obj(obj)
    return setmetatable(obj, TMockDataRsp)
end

function TMockDataRsp.new(MockResult)
    return TMockDataRsp_from_obj({MockResult = MockResult})
end
---@param obj PhyBitError.MockDataRsp
function TMockDataRsp:init_from_obj(obj)
    self.MockResult = obj.MockResult
end

function TMockDataRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMockDataRsp.group)
end

TMockDataRsp.from_obj = TMockDataRsp_from_obj

TMockDataRsp.proto_property = {'MockResult'}

TMockDataRsp.default = {0}

TMockDataRsp.struct = {{name = 'MockResult', is_array = false, struct = nil}}

function TMockDataRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MockResult', self.MockResult, 'uint8', false, errs, need_convert)

    TMockDataRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMockDataRsp.proto_property, errs, need_convert)
    return self
end

function TMockDataRsp:unpack(_)
    return self.MockResult
end

PhyBitError.MockDataRsp = TMockDataRsp

---@class PhyBitError.MockDataReq
---@field ControllerId integer
---@field ExpanderId integer
---@field FilePath string
local TMockDataReq = {}
TMockDataReq.__index = TMockDataReq
TMockDataReq.group = {}

local function TMockDataReq_from_obj(obj)
    return setmetatable(obj, TMockDataReq)
end

function TMockDataReq.new(ControllerId, ExpanderId, FilePath)
    return TMockDataReq_from_obj({ControllerId = ControllerId, ExpanderId = ExpanderId, FilePath = FilePath})
end
---@param obj PhyBitError.MockDataReq
function TMockDataReq:init_from_obj(obj)
    self.ControllerId = obj.ControllerId
    self.ExpanderId = obj.ExpanderId
    self.FilePath = obj.FilePath
end

function TMockDataReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMockDataReq.group)
end

TMockDataReq.from_obj = TMockDataReq_from_obj

TMockDataReq.proto_property = {'ControllerId', 'ExpanderId', 'FilePath'}

TMockDataReq.default = {0, 0, ''}

TMockDataReq.struct = {
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'ExpanderId', is_array = false, struct = nil},
    {name = 'FilePath', is_array = false, struct = nil}
}

function TMockDataReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ExpanderId', self.ExpanderId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FilePath', self.FilePath, 'string', false, errs, need_convert)

    TMockDataReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMockDataReq.proto_property, errs, need_convert)
    return self
end

function TMockDataReq:unpack(_)
    return self.ControllerId, self.ExpanderId, self.FilePath
end

PhyBitError.MockDataReq = TMockDataReq

PhyBitError.interface = mdb.register_interface('bmc.kepler.Debug.Storage.PhyBitError',
    {FileMockEnabled = {'b', {}, false, nil, false}}, {MockData = {'a{ss}yys', 'y', TMockDataReq, TMockDataRsp}}, {})

return PhyBitError
