-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Drives = {}

---@class Drives.LogAutoCollectInterval
---@field LogAutoCollectInterval integer
local TLogAutoCollectInterval = {}
TLogAutoCollectInterval.__index = TLogAutoCollectInterval
TLogAutoCollectInterval.group = {}

local function TLogAutoCollectInterval_from_obj(obj)
    return setmetatable(obj, TLogAutoCollectInterval)
end

function TLogAutoCollectInterval.new(LogAutoCollectInterval)
    return TLogAutoCollectInterval_from_obj({LogAutoCollectInterval = LogAutoCollectInterval or 24})
end
---@param obj Drives.LogAutoCollectInterval
function TLogAutoCollectInterval:init_from_obj(obj)
    self.LogAutoCollectInterval = obj.LogAutoCollectInterval or 24
end

function TLogAutoCollectInterval:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLogAutoCollectInterval.group)
end

TLogAutoCollectInterval.from_obj = TLogAutoCollectInterval_from_obj

TLogAutoCollectInterval.proto_property = {'LogAutoCollectInterval'}

TLogAutoCollectInterval.default = {0}

TLogAutoCollectInterval.struct = {{name = 'LogAutoCollectInterval', is_array = false, struct = nil}}

function TLogAutoCollectInterval:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LogAutoCollectInterval', self.LogAutoCollectInterval, 'uint8', false, errs,
        need_convert)

    TLogAutoCollectInterval:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLogAutoCollectInterval.proto_property, errs, need_convert)
    return self
end

function TLogAutoCollectInterval:unpack(_)
    return self.LogAutoCollectInterval
end

Drives.LogAutoCollectInterval = TLogAutoCollectInterval

---@class Drives.LogAutoCollectEnable
---@field LogAutoCollectEnable boolean
local TLogAutoCollectEnable = {}
TLogAutoCollectEnable.__index = TLogAutoCollectEnable
TLogAutoCollectEnable.group = {}

local function TLogAutoCollectEnable_from_obj(obj)
    return setmetatable(obj, TLogAutoCollectEnable)
end

function TLogAutoCollectEnable.new(LogAutoCollectEnable)
    return TLogAutoCollectEnable_from_obj({
        LogAutoCollectEnable = LogAutoCollectEnable == nil and true or LogAutoCollectEnable
    })
end
---@param obj Drives.LogAutoCollectEnable
function TLogAutoCollectEnable:init_from_obj(obj)
    self.LogAutoCollectEnable = obj.LogAutoCollectEnable == nil and true or obj.LogAutoCollectEnable
end

function TLogAutoCollectEnable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLogAutoCollectEnable.group)
end

TLogAutoCollectEnable.from_obj = TLogAutoCollectEnable_from_obj

TLogAutoCollectEnable.proto_property = {'LogAutoCollectEnable'}

TLogAutoCollectEnable.default = {false}

TLogAutoCollectEnable.struct = {{name = 'LogAutoCollectEnable', is_array = false, struct = nil}}

function TLogAutoCollectEnable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LogAutoCollectEnable', self.LogAutoCollectEnable, 'bool', false, errs, need_convert)

    TLogAutoCollectEnable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLogAutoCollectEnable.proto_property, errs, need_convert)
    return self
end

function TLogAutoCollectEnable:unpack(_)
    return self.LogAutoCollectEnable
end

Drives.LogAutoCollectEnable = TLogAutoCollectEnable

---@class Drives.MaxTemperatureCelsius
---@field MaxTemperatureCelsius integer
local TMaxTemperatureCelsius = {}
TMaxTemperatureCelsius.__index = TMaxTemperatureCelsius
TMaxTemperatureCelsius.group = {}

local function TMaxTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TMaxTemperatureCelsius)
end

function TMaxTemperatureCelsius.new(MaxTemperatureCelsius)
    return TMaxTemperatureCelsius_from_obj({MaxTemperatureCelsius = MaxTemperatureCelsius})
end
---@param obj Drives.MaxTemperatureCelsius
function TMaxTemperatureCelsius:init_from_obj(obj)
    self.MaxTemperatureCelsius = obj.MaxTemperatureCelsius
end

function TMaxTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaxTemperatureCelsius.group)
end

TMaxTemperatureCelsius.from_obj = TMaxTemperatureCelsius_from_obj

TMaxTemperatureCelsius.proto_property = {'MaxTemperatureCelsius'}

TMaxTemperatureCelsius.default = {0}

TMaxTemperatureCelsius.struct = {{name = 'MaxTemperatureCelsius', is_array = false, struct = nil}}

function TMaxTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxTemperatureCelsius', self.MaxTemperatureCelsius, 'uint8', true, errs, need_convert)

    TMaxTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaxTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TMaxTemperatureCelsius:unpack(_)
    return self.MaxTemperatureCelsius
end

Drives.MaxTemperatureCelsius = TMaxTemperatureCelsius

---@class Drives.StartCollectLogRsp
local TStartCollectLogRsp = {}
TStartCollectLogRsp.__index = TStartCollectLogRsp
TStartCollectLogRsp.group = {}

local function TStartCollectLogRsp_from_obj(obj)
    return setmetatable(obj, TStartCollectLogRsp)
end

function TStartCollectLogRsp.new()
    return TStartCollectLogRsp_from_obj({})
end
---@param obj Drives.StartCollectLogRsp
function TStartCollectLogRsp:init_from_obj(obj)

end

function TStartCollectLogRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartCollectLogRsp.group)
end

TStartCollectLogRsp.from_obj = TStartCollectLogRsp_from_obj

TStartCollectLogRsp.proto_property = {}

TStartCollectLogRsp.default = {}

TStartCollectLogRsp.struct = {}

function TStartCollectLogRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TStartCollectLogRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartCollectLogRsp.proto_property, errs, need_convert)
    return self
end

function TStartCollectLogRsp:unpack(_)
end

Drives.StartCollectLogRsp = TStartCollectLogRsp

---@class Drives.StartCollectLogReq
---@field DriveName string
local TStartCollectLogReq = {}
TStartCollectLogReq.__index = TStartCollectLogReq
TStartCollectLogReq.group = {}

local function TStartCollectLogReq_from_obj(obj)
    return setmetatable(obj, TStartCollectLogReq)
end

function TStartCollectLogReq.new(DriveName)
    return TStartCollectLogReq_from_obj({DriveName = DriveName})
end
---@param obj Drives.StartCollectLogReq
function TStartCollectLogReq:init_from_obj(obj)
    self.DriveName = obj.DriveName
end

function TStartCollectLogReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartCollectLogReq.group)
end

TStartCollectLogReq.from_obj = TStartCollectLogReq_from_obj

TStartCollectLogReq.proto_property = {'DriveName'}

TStartCollectLogReq.default = {''}

TStartCollectLogReq.struct = {{name = 'DriveName', is_array = false, struct = nil}}

function TStartCollectLogReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DriveName', self.DriveName, 'string', false, errs, need_convert)

    TStartCollectLogReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartCollectLogReq.proto_property, errs, need_convert)
    return self
end

function TStartCollectLogReq:unpack(_)
    return self.DriveName
end

Drives.StartCollectLogReq = TStartCollectLogReq

---@class Drives.SetDriveSubHealthDiagResultRsp
local TSetDriveSubHealthDiagResultRsp = {}
TSetDriveSubHealthDiagResultRsp.__index = TSetDriveSubHealthDiagResultRsp
TSetDriveSubHealthDiagResultRsp.group = {}

local function TSetDriveSubHealthDiagResultRsp_from_obj(obj)
    return setmetatable(obj, TSetDriveSubHealthDiagResultRsp)
end

function TSetDriveSubHealthDiagResultRsp.new()
    return TSetDriveSubHealthDiagResultRsp_from_obj({})
end
---@param obj Drives.SetDriveSubHealthDiagResultRsp
function TSetDriveSubHealthDiagResultRsp:init_from_obj(obj)

end

function TSetDriveSubHealthDiagResultRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDriveSubHealthDiagResultRsp.group)
end

TSetDriveSubHealthDiagResultRsp.from_obj = TSetDriveSubHealthDiagResultRsp_from_obj

TSetDriveSubHealthDiagResultRsp.proto_property = {}

TSetDriveSubHealthDiagResultRsp.default = {}

TSetDriveSubHealthDiagResultRsp.struct = {}

function TSetDriveSubHealthDiagResultRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetDriveSubHealthDiagResultRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDriveSubHealthDiagResultRsp.proto_property, errs, need_convert)
    return self
end

function TSetDriveSubHealthDiagResultRsp:unpack(_)
end

Drives.SetDriveSubHealthDiagResultRsp = TSetDriveSubHealthDiagResultRsp

---@class Drives.GetNvmeDriveCountRsp
---@field NvmeDriveCount integer
local TGetNvmeDriveCountRsp = {}
TGetNvmeDriveCountRsp.__index = TGetNvmeDriveCountRsp
TGetNvmeDriveCountRsp.group = {}

local function TGetNvmeDriveCountRsp_from_obj(obj)
    return setmetatable(obj, TGetNvmeDriveCountRsp)
end

function TGetNvmeDriveCountRsp.new(NvmeDriveCount)
    return TGetNvmeDriveCountRsp_from_obj({NvmeDriveCount = NvmeDriveCount})
end
---@param obj Drives.GetNvmeDriveCountRsp
function TGetNvmeDriveCountRsp:init_from_obj(obj)
    self.NvmeDriveCount = obj.NvmeDriveCount
end

function TGetNvmeDriveCountRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetNvmeDriveCountRsp.group)
end

TGetNvmeDriveCountRsp.from_obj = TGetNvmeDriveCountRsp_from_obj

TGetNvmeDriveCountRsp.proto_property = {'NvmeDriveCount'}

TGetNvmeDriveCountRsp.default = {0}

TGetNvmeDriveCountRsp.struct = {{name = 'NvmeDriveCount', is_array = false, struct = nil}}

function TGetNvmeDriveCountRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NvmeDriveCount', self.NvmeDriveCount, 'uint16', false, errs, need_convert)

    TGetNvmeDriveCountRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetNvmeDriveCountRsp.proto_property, errs, need_convert)
    return self
end

function TGetNvmeDriveCountRsp:unpack(_)
    return self.NvmeDriveCount
end

Drives.GetNvmeDriveCountRsp = TGetNvmeDriveCountRsp

---@class Drives.GetNvmeDriveCountReq
local TGetNvmeDriveCountReq = {}
TGetNvmeDriveCountReq.__index = TGetNvmeDriveCountReq
TGetNvmeDriveCountReq.group = {}

local function TGetNvmeDriveCountReq_from_obj(obj)
    return setmetatable(obj, TGetNvmeDriveCountReq)
end

function TGetNvmeDriveCountReq.new()
    return TGetNvmeDriveCountReq_from_obj({})
end
---@param obj Drives.GetNvmeDriveCountReq
function TGetNvmeDriveCountReq:init_from_obj(obj)

end

function TGetNvmeDriveCountReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetNvmeDriveCountReq.group)
end

TGetNvmeDriveCountReq.from_obj = TGetNvmeDriveCountReq_from_obj

TGetNvmeDriveCountReq.proto_property = {}

TGetNvmeDriveCountReq.default = {}

TGetNvmeDriveCountReq.struct = {}

function TGetNvmeDriveCountReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetNvmeDriveCountReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetNvmeDriveCountReq.proto_property, errs, need_convert)
    return self
end

function TGetNvmeDriveCountReq:unpack(_)
end

Drives.GetNvmeDriveCountReq = TGetNvmeDriveCountReq

---@class Drives.GetNvmeDriveRawDataRsp
---@field NvmeDriveData string
local TGetNvmeDriveRawDataRsp = {}
TGetNvmeDriveRawDataRsp.__index = TGetNvmeDriveRawDataRsp
TGetNvmeDriveRawDataRsp.group = {}

local function TGetNvmeDriveRawDataRsp_from_obj(obj)
    return setmetatable(obj, TGetNvmeDriveRawDataRsp)
end

function TGetNvmeDriveRawDataRsp.new(NvmeDriveData)
    return TGetNvmeDriveRawDataRsp_from_obj({NvmeDriveData = NvmeDriveData})
end
---@param obj Drives.GetNvmeDriveRawDataRsp
function TGetNvmeDriveRawDataRsp:init_from_obj(obj)
    self.NvmeDriveData = obj.NvmeDriveData
end

function TGetNvmeDriveRawDataRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetNvmeDriveRawDataRsp.group)
end

TGetNvmeDriveRawDataRsp.from_obj = TGetNvmeDriveRawDataRsp_from_obj

TGetNvmeDriveRawDataRsp.proto_property = {'NvmeDriveData'}

TGetNvmeDriveRawDataRsp.default = {''}

TGetNvmeDriveRawDataRsp.struct = {{name = 'NvmeDriveData', is_array = false, struct = nil}}

function TGetNvmeDriveRawDataRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NvmeDriveData', self.NvmeDriveData, 'string', false, errs, need_convert)

    TGetNvmeDriveRawDataRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetNvmeDriveRawDataRsp.proto_property, errs, need_convert)
    return self
end

function TGetNvmeDriveRawDataRsp:unpack(_)
    return self.NvmeDriveData
end

Drives.GetNvmeDriveRawDataRsp = TGetNvmeDriveRawDataRsp

---@class Drives.GetNvmeDriveRawDataReq
---@field index integer
local TGetNvmeDriveRawDataReq = {}
TGetNvmeDriveRawDataReq.__index = TGetNvmeDriveRawDataReq
TGetNvmeDriveRawDataReq.group = {}

local function TGetNvmeDriveRawDataReq_from_obj(obj)
    return setmetatable(obj, TGetNvmeDriveRawDataReq)
end

function TGetNvmeDriveRawDataReq.new(index)
    return TGetNvmeDriveRawDataReq_from_obj({index = index})
end
---@param obj Drives.GetNvmeDriveRawDataReq
function TGetNvmeDriveRawDataReq:init_from_obj(obj)
    self.index = obj.index
end

function TGetNvmeDriveRawDataReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetNvmeDriveRawDataReq.group)
end

TGetNvmeDriveRawDataReq.from_obj = TGetNvmeDriveRawDataReq_from_obj

TGetNvmeDriveRawDataReq.proto_property = {'index'}

TGetNvmeDriveRawDataReq.default = {0}

TGetNvmeDriveRawDataReq.struct = {{name = 'index', is_array = false, struct = nil}}

function TGetNvmeDriveRawDataReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'index', self.index, 'uint16', false, errs, need_convert)

    TGetNvmeDriveRawDataReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetNvmeDriveRawDataReq.proto_property, errs, need_convert)
    return self
end

function TGetNvmeDriveRawDataReq:unpack(_)
    return self.index
end

Drives.GetNvmeDriveRawDataReq = TGetNvmeDriveRawDataReq

---@class Drives.GetDrivesSubHealthDiagInfoReq
---@field SubHealthType string
local TGetDrivesSubHealthDiagInfoReq = {}
TGetDrivesSubHealthDiagInfoReq.__index = TGetDrivesSubHealthDiagInfoReq
TGetDrivesSubHealthDiagInfoReq.group = {}

local function TGetDrivesSubHealthDiagInfoReq_from_obj(obj)
    return setmetatable(obj, TGetDrivesSubHealthDiagInfoReq)
end

function TGetDrivesSubHealthDiagInfoReq.new(SubHealthType)
    return TGetDrivesSubHealthDiagInfoReq_from_obj({SubHealthType = SubHealthType})
end
---@param obj Drives.GetDrivesSubHealthDiagInfoReq
function TGetDrivesSubHealthDiagInfoReq:init_from_obj(obj)
    self.SubHealthType = obj.SubHealthType
end

function TGetDrivesSubHealthDiagInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDrivesSubHealthDiagInfoReq.group)
end

TGetDrivesSubHealthDiagInfoReq.from_obj = TGetDrivesSubHealthDiagInfoReq_from_obj

TGetDrivesSubHealthDiagInfoReq.proto_property = {'SubHealthType'}

TGetDrivesSubHealthDiagInfoReq.default = {''}

TGetDrivesSubHealthDiagInfoReq.struct = {{name = 'SubHealthType', is_array = false, struct = nil}}

function TGetDrivesSubHealthDiagInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SubHealthType', self.SubHealthType, 'string', false, errs, need_convert)

    TGetDrivesSubHealthDiagInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDrivesSubHealthDiagInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetDrivesSubHealthDiagInfoReq:unpack(_)
    return self.SubHealthType
end

Drives.GetDrivesSubHealthDiagInfoReq = TGetDrivesSubHealthDiagInfoReq

---@class Drives.CollectIODeteriorationDiagInfoRsp
---@field TaskId integer
local TCollectIODeteriorationDiagInfoRsp = {}
TCollectIODeteriorationDiagInfoRsp.__index = TCollectIODeteriorationDiagInfoRsp
TCollectIODeteriorationDiagInfoRsp.group = {}

local function TCollectIODeteriorationDiagInfoRsp_from_obj(obj)
    return setmetatable(obj, TCollectIODeteriorationDiagInfoRsp)
end

function TCollectIODeteriorationDiagInfoRsp.new(TaskId)
    return TCollectIODeteriorationDiagInfoRsp_from_obj({TaskId = TaskId})
end
---@param obj Drives.CollectIODeteriorationDiagInfoRsp
function TCollectIODeteriorationDiagInfoRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TCollectIODeteriorationDiagInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCollectIODeteriorationDiagInfoRsp.group)
end

TCollectIODeteriorationDiagInfoRsp.from_obj = TCollectIODeteriorationDiagInfoRsp_from_obj

TCollectIODeteriorationDiagInfoRsp.proto_property = {'TaskId'}

TCollectIODeteriorationDiagInfoRsp.default = {0}

TCollectIODeteriorationDiagInfoRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TCollectIODeteriorationDiagInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TCollectIODeteriorationDiagInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCollectIODeteriorationDiagInfoRsp.proto_property, errs, need_convert)
    return self
end

function TCollectIODeteriorationDiagInfoRsp:unpack(_)
    return self.TaskId
end

Drives.CollectIODeteriorationDiagInfoRsp = TCollectIODeteriorationDiagInfoRsp

---@class Drives.CollectIODeteriorationDiagInfoReq
local TCollectIODeteriorationDiagInfoReq = {}
TCollectIODeteriorationDiagInfoReq.__index = TCollectIODeteriorationDiagInfoReq
TCollectIODeteriorationDiagInfoReq.group = {}

local function TCollectIODeteriorationDiagInfoReq_from_obj(obj)
    return setmetatable(obj, TCollectIODeteriorationDiagInfoReq)
end

function TCollectIODeteriorationDiagInfoReq.new()
    return TCollectIODeteriorationDiagInfoReq_from_obj({})
end
---@param obj Drives.CollectIODeteriorationDiagInfoReq
function TCollectIODeteriorationDiagInfoReq:init_from_obj(obj)

end

function TCollectIODeteriorationDiagInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCollectIODeteriorationDiagInfoReq.group)
end

TCollectIODeteriorationDiagInfoReq.from_obj = TCollectIODeteriorationDiagInfoReq_from_obj

TCollectIODeteriorationDiagInfoReq.proto_property = {}

TCollectIODeteriorationDiagInfoReq.default = {}

TCollectIODeteriorationDiagInfoReq.struct = {}

function TCollectIODeteriorationDiagInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TCollectIODeteriorationDiagInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCollectIODeteriorationDiagInfoReq.proto_property, errs, need_convert)
    return self
end

function TCollectIODeteriorationDiagInfoReq:unpack(_)
end

Drives.CollectIODeteriorationDiagInfoReq = TCollectIODeteriorationDiagInfoReq

---@class Drives.KeyValueTable
---@field Key string
---@field Value string
local TKeyValueTable = {}
TKeyValueTable.__index = TKeyValueTable
TKeyValueTable.group = {}

local function TKeyValueTable_from_obj(obj)
    return setmetatable(obj, TKeyValueTable)
end

function TKeyValueTable.new(Key, Value)
    return TKeyValueTable_from_obj({Key = Key, Value = Value})
end
---@param obj Drives.KeyValueTable
function TKeyValueTable:init_from_obj(obj)
    self.Key = obj.Key
    self.Value = obj.Value
end

function TKeyValueTable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TKeyValueTable.group)
end

TKeyValueTable.from_obj = TKeyValueTable_from_obj

TKeyValueTable.proto_property = {'Key', 'Value'}

TKeyValueTable.default = {'', ''}

TKeyValueTable.struct = {
    {name = 'Key', is_array = false, struct = nil}, {name = 'Value', is_array = false, struct = nil}
}

function TKeyValueTable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Key', self.Key, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Value', self.Value, 'string', false, errs, need_convert)

    TKeyValueTable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TKeyValueTable.proto_property, errs, need_convert)
    return self
end

function TKeyValueTable:unpack(_)
    return self.Key, self.Value
end

Drives.KeyValueTable = TKeyValueTable

---@class Drives.SetDriveSubHealthDiagResultReq
---@field SubHealthDiagResult Drives.KeyValueTable[]
local TSetDriveSubHealthDiagResultReq = {}
TSetDriveSubHealthDiagResultReq.__index = TSetDriveSubHealthDiagResultReq
TSetDriveSubHealthDiagResultReq.group = {}

local function TSetDriveSubHealthDiagResultReq_from_obj(obj)
    obj.SubHealthDiagResult = utils.from_obj(Drives.KeyValueTable, obj.SubHealthDiagResult, true)
    return setmetatable(obj, TSetDriveSubHealthDiagResultReq)
end

function TSetDriveSubHealthDiagResultReq.new(SubHealthDiagResult)
    return TSetDriveSubHealthDiagResultReq_from_obj({SubHealthDiagResult = SubHealthDiagResult})
end
---@param obj Drives.SetDriveSubHealthDiagResultReq
function TSetDriveSubHealthDiagResultReq:init_from_obj(obj)
    self.SubHealthDiagResult = obj.SubHealthDiagResult
end

function TSetDriveSubHealthDiagResultReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDriveSubHealthDiagResultReq.group)
end

TSetDriveSubHealthDiagResultReq.from_obj = TSetDriveSubHealthDiagResultReq_from_obj

TSetDriveSubHealthDiagResultReq.proto_property = {'SubHealthDiagResult'}

TSetDriveSubHealthDiagResultReq.default = {{}}

TSetDriveSubHealthDiagResultReq.struct = {
    {name = 'SubHealthDiagResult', is_array = true, struct = Drives.KeyValueTable.struct}
}

function TSetDriveSubHealthDiagResultReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.SubHealthDiagResult) do
        Drives.KeyValueTable.new(v.Key, v.Value):validate(prefix, errs, need_convert)
    end

    TSetDriveSubHealthDiagResultReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDriveSubHealthDiagResultReq.proto_property, errs, need_convert)
    return self
end

function TSetDriveSubHealthDiagResultReq:unpack(raw)
    return utils.unpack(raw, self.SubHealthDiagResult, true)
end

Drives.SetDriveSubHealthDiagResultReq = TSetDriveSubHealthDiagResultReq

---@class Drives.DiagInfoList
---@field key string
---@field value string
local TDiagInfoList = {}
TDiagInfoList.__index = TDiagInfoList
TDiagInfoList.group = {}

local function TDiagInfoList_from_obj(obj)
    return setmetatable(obj, TDiagInfoList)
end

function TDiagInfoList.new(dict)
    return TDiagInfoList_from_obj(dict)
end

---@param obj Drives.DiagInfoList
function TDiagInfoList:init_from_obj(obj)
    self = obj
end

function TDiagInfoList:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDiagInfoList.group)
end

TDiagInfoList.from_obj = TDiagInfoList_from_obj

TDiagInfoList.proto_property = {}

TDiagInfoList.default = {}

TDiagInfoList.struct = {}

function TDiagInfoList:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TDiagInfoList:remove_error_props(errs, self)
    return self
end

function TDiagInfoList:unpack(_)
    return self
end

Drives.DiagInfoList = TDiagInfoList

---@class Drives.DriveList
---@field key integer
---@field value Drives.DiagInfoList
local TDriveList = {}
TDriveList.__index = TDriveList
TDriveList.group = {}

local function TDriveList_from_obj(obj)
    return setmetatable(obj, TDriveList)
end

function TDriveList.new(dict)
    return TDriveList_from_obj(dict)
end

---@param obj Drives.DriveList
function TDriveList:init_from_obj(obj)
    self = obj
end

function TDriveList:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDriveList.group)
end

TDriveList.from_obj = TDriveList_from_obj

TDriveList.proto_property = {}

TDriveList.default = {}

TDriveList.struct = {}

function TDriveList:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'uint32', false, errs, need_convert)

        Drives.DiagInfoList.new(v):validate(prefix, errs, need_convert)

    end

    TDriveList:remove_error_props(errs, self)
    return self
end

function TDriveList:unpack(_)
    return self
end

Drives.DriveList = TDriveList

---@class Drives.GetDrivesSubHealthDiagInfoRsp
---@field SubHealthDiagInfoList Drives.DriveList[]
local TGetDrivesSubHealthDiagInfoRsp = {}
TGetDrivesSubHealthDiagInfoRsp.__index = TGetDrivesSubHealthDiagInfoRsp
TGetDrivesSubHealthDiagInfoRsp.group = {}

local function TGetDrivesSubHealthDiagInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetDrivesSubHealthDiagInfoRsp)
end

function TGetDrivesSubHealthDiagInfoRsp.new(SubHealthDiagInfoList)
    return TGetDrivesSubHealthDiagInfoRsp_from_obj({SubHealthDiagInfoList = SubHealthDiagInfoList})
end
---@param obj Drives.GetDrivesSubHealthDiagInfoRsp
function TGetDrivesSubHealthDiagInfoRsp:init_from_obj(obj)
    self.SubHealthDiagInfoList = obj.SubHealthDiagInfoList
end

function TGetDrivesSubHealthDiagInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDrivesSubHealthDiagInfoRsp.group)
end

TGetDrivesSubHealthDiagInfoRsp.from_obj = TGetDrivesSubHealthDiagInfoRsp_from_obj

TGetDrivesSubHealthDiagInfoRsp.proto_property = {'SubHealthDiagInfoList'}

TGetDrivesSubHealthDiagInfoRsp.default = {{}}

TGetDrivesSubHealthDiagInfoRsp.struct = {
    {name = 'SubHealthDiagInfoList', is_array = true, struct = Drives.DriveList.struct}
}

function TGetDrivesSubHealthDiagInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.SubHealthDiagInfoList) do
        Drives.DriveList.new(v):validate(prefix, errs, need_convert)
    end

    TGetDrivesSubHealthDiagInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDrivesSubHealthDiagInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetDrivesSubHealthDiagInfoRsp:unpack(_)
    return self.SubHealthDiagInfoList
end

Drives.GetDrivesSubHealthDiagInfoRsp = TGetDrivesSubHealthDiagInfoRsp

Drives.interface = mdb.register_interface('bmc.kepler.Systems.Storage.Drives', {
    MaxTemperatureCelsius = {'y', nil, true, nil, false},
    LogAutoCollectEnable = {'b', nil, false, true, false},
    LogAutoCollectInterval = {'y', nil, false, 24, false}
}, {
    CollectIODeteriorationDiagInfo = {
        'a{ss}', 'u', TCollectIODeteriorationDiagInfoReq, TCollectIODeteriorationDiagInfoRsp
    },
    GetDrivesSubHealthDiagInfo = {
        'a{ss}s', 'aa{ua{ss}}', TGetDrivesSubHealthDiagInfoReq, TGetDrivesSubHealthDiagInfoRsp
    },
    GetNvmeDriveRawData = {'a{ss}q', 's', TGetNvmeDriveRawDataReq, TGetNvmeDriveRawDataRsp},
    GetNvmeDriveCount = {'a{ss}', 'q', TGetNvmeDriveCountReq, TGetNvmeDriveCountRsp},
    SetDriveSubHealthDiagResult = {'a{ss}a(ss)', '', TSetDriveSubHealthDiagResultReq, TSetDriveSubHealthDiagResultRsp},
    StartCollectLog = {'a{ss}s', '', TStartCollectLogReq, TStartCollectLogRsp}
}, {})

return Drives
