-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local DriveSubHealth = {}

---@class DriveSubHealth.IODeteriorationHealthCode
---@field IODeteriorationHealthCode integer
local TIODeteriorationHealthCode = {}
TIODeteriorationHealthCode.__index = TIODeteriorationHealthCode
TIODeteriorationHealthCode.group = {}

local function TIODeteriorationHealthCode_from_obj(obj)
    return setmetatable(obj, TIODeteriorationHealthCode)
end

function TIODeteriorationHealthCode.new(IODeteriorationHealthCode)
    return TIODeteriorationHealthCode_from_obj({IODeteriorationHealthCode = IODeteriorationHealthCode})
end
---@param obj DriveSubHealth.IODeteriorationHealthCode
function TIODeteriorationHealthCode:init_from_obj(obj)
    self.IODeteriorationHealthCode = obj.IODeteriorationHealthCode
end

function TIODeteriorationHealthCode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIODeteriorationHealthCode.group)
end

TIODeteriorationHealthCode.from_obj = TIODeteriorationHealthCode_from_obj

TIODeteriorationHealthCode.proto_property = {'IODeteriorationHealthCode'}

TIODeteriorationHealthCode.default = {0}

TIODeteriorationHealthCode.struct = {{name = 'IODeteriorationHealthCode', is_array = false, struct = nil}}

function TIODeteriorationHealthCode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IODeteriorationHealthCode', self.IODeteriorationHealthCode, 'uint16', true, errs,
        need_convert)

    TIODeteriorationHealthCode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIODeteriorationHealthCode.proto_property, errs, need_convert)
    return self
end

function TIODeteriorationHealthCode:unpack(_)
    return self.IODeteriorationHealthCode
end

DriveSubHealth.IODeteriorationHealthCode = TIODeteriorationHealthCode

---@class DriveSubHealth.EstimatedRemainingLifespan
---@field EstimatedRemainingLifespan integer
local TEstimatedRemainingLifespan = {}
TEstimatedRemainingLifespan.__index = TEstimatedRemainingLifespan
TEstimatedRemainingLifespan.group = {}

local function TEstimatedRemainingLifespan_from_obj(obj)
    return setmetatable(obj, TEstimatedRemainingLifespan)
end

function TEstimatedRemainingLifespan.new(EstimatedRemainingLifespan)
    return TEstimatedRemainingLifespan_from_obj({EstimatedRemainingLifespan = EstimatedRemainingLifespan or 4294967295})
end
---@param obj DriveSubHealth.EstimatedRemainingLifespan
function TEstimatedRemainingLifespan:init_from_obj(obj)
    self.EstimatedRemainingLifespan = obj.EstimatedRemainingLifespan or 4294967295
end

function TEstimatedRemainingLifespan:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEstimatedRemainingLifespan.group)
end

TEstimatedRemainingLifespan.from_obj = TEstimatedRemainingLifespan_from_obj

TEstimatedRemainingLifespan.proto_property = {'EstimatedRemainingLifespan'}

TEstimatedRemainingLifespan.default = {0}

TEstimatedRemainingLifespan.struct = {{name = 'EstimatedRemainingLifespan', is_array = false, struct = nil}}

function TEstimatedRemainingLifespan:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EstimatedRemainingLifespan', self.EstimatedRemainingLifespan, 'uint32', true, errs,
        need_convert)

    TEstimatedRemainingLifespan:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEstimatedRemainingLifespan.proto_property, errs, need_convert)
    return self
end

function TEstimatedRemainingLifespan:unpack(_)
    return self.EstimatedRemainingLifespan
end

DriveSubHealth.EstimatedRemainingLifespan = TEstimatedRemainingLifespan

---@class DriveSubHealth.TLCSpareBlockPercentage
---@field TLCSpareBlockPercentage integer
local TTLCSpareBlockPercentage = {}
TTLCSpareBlockPercentage.__index = TTLCSpareBlockPercentage
TTLCSpareBlockPercentage.group = {}

local function TTLCSpareBlockPercentage_from_obj(obj)
    return setmetatable(obj, TTLCSpareBlockPercentage)
end

function TTLCSpareBlockPercentage.new(TLCSpareBlockPercentage)
    return TTLCSpareBlockPercentage_from_obj({TLCSpareBlockPercentage = TLCSpareBlockPercentage or 255})
end
---@param obj DriveSubHealth.TLCSpareBlockPercentage
function TTLCSpareBlockPercentage:init_from_obj(obj)
    self.TLCSpareBlockPercentage = obj.TLCSpareBlockPercentage or 255
end

function TTLCSpareBlockPercentage:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTLCSpareBlockPercentage.group)
end

TTLCSpareBlockPercentage.from_obj = TTLCSpareBlockPercentage_from_obj

TTLCSpareBlockPercentage.proto_property = {'TLCSpareBlockPercentage'}

TTLCSpareBlockPercentage.default = {0}

TTLCSpareBlockPercentage.struct = {{name = 'TLCSpareBlockPercentage', is_array = false, struct = nil}}

function TTLCSpareBlockPercentage:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TLCSpareBlockPercentage', self.TLCSpareBlockPercentage, 'uint8', true, errs,
        need_convert)

    TTLCSpareBlockPercentage:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTLCSpareBlockPercentage.proto_property, errs, need_convert)
    return self
end

function TTLCSpareBlockPercentage:unpack(_)
    return self.TLCSpareBlockPercentage
end

DriveSubHealth.TLCSpareBlockPercentage = TTLCSpareBlockPercentage

---@class DriveSubHealth.SLCSpareBlockPercentage
---@field SLCSpareBlockPercentage integer
local TSLCSpareBlockPercentage = {}
TSLCSpareBlockPercentage.__index = TSLCSpareBlockPercentage
TSLCSpareBlockPercentage.group = {}

local function TSLCSpareBlockPercentage_from_obj(obj)
    return setmetatable(obj, TSLCSpareBlockPercentage)
end

function TSLCSpareBlockPercentage.new(SLCSpareBlockPercentage)
    return TSLCSpareBlockPercentage_from_obj({SLCSpareBlockPercentage = SLCSpareBlockPercentage or 255})
end
---@param obj DriveSubHealth.SLCSpareBlockPercentage
function TSLCSpareBlockPercentage:init_from_obj(obj)
    self.SLCSpareBlockPercentage = obj.SLCSpareBlockPercentage or 255
end

function TSLCSpareBlockPercentage:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSLCSpareBlockPercentage.group)
end

TSLCSpareBlockPercentage.from_obj = TSLCSpareBlockPercentage_from_obj

TSLCSpareBlockPercentage.proto_property = {'SLCSpareBlockPercentage'}

TSLCSpareBlockPercentage.default = {0}

TSLCSpareBlockPercentage.struct = {{name = 'SLCSpareBlockPercentage', is_array = false, struct = nil}}

function TSLCSpareBlockPercentage:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SLCSpareBlockPercentage', self.SLCSpareBlockPercentage, 'uint8', true, errs,
        need_convert)

    TSLCSpareBlockPercentage:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSLCSpareBlockPercentage.proto_property, errs, need_convert)
    return self
end

function TSLCSpareBlockPercentage:unpack(_)
    return self.SLCSpareBlockPercentage
end

DriveSubHealth.SLCSpareBlockPercentage = TSLCSpareBlockPercentage

---@class DriveSubHealth.EstimatedRemainingLifespanInsufficient
---@field EstimatedRemainingLifespanInsufficient integer
local TEstimatedRemainingLifespanInsufficient = {}
TEstimatedRemainingLifespanInsufficient.__index = TEstimatedRemainingLifespanInsufficient
TEstimatedRemainingLifespanInsufficient.group = {}

local function TEstimatedRemainingLifespanInsufficient_from_obj(obj)
    return setmetatable(obj, TEstimatedRemainingLifespanInsufficient)
end

function TEstimatedRemainingLifespanInsufficient.new(EstimatedRemainingLifespanInsufficient)
    return TEstimatedRemainingLifespanInsufficient_from_obj({
        EstimatedRemainingLifespanInsufficient = EstimatedRemainingLifespanInsufficient
    })
end
---@param obj DriveSubHealth.EstimatedRemainingLifespanInsufficient
function TEstimatedRemainingLifespanInsufficient:init_from_obj(obj)
    self.EstimatedRemainingLifespanInsufficient = obj.EstimatedRemainingLifespanInsufficient
end

function TEstimatedRemainingLifespanInsufficient:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEstimatedRemainingLifespanInsufficient.group)
end

TEstimatedRemainingLifespanInsufficient.from_obj = TEstimatedRemainingLifespanInsufficient_from_obj

TEstimatedRemainingLifespanInsufficient.proto_property = {'EstimatedRemainingLifespanInsufficient'}

TEstimatedRemainingLifespanInsufficient.default = {0}

TEstimatedRemainingLifespanInsufficient.struct = {
    {name = 'EstimatedRemainingLifespanInsufficient', is_array = false, struct = nil}
}

function TEstimatedRemainingLifespanInsufficient:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EstimatedRemainingLifespanInsufficient', self.EstimatedRemainingLifespanInsufficient,
        'uint8', true, errs, need_convert)

    TEstimatedRemainingLifespanInsufficient:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEstimatedRemainingLifespanInsufficient.proto_property, errs, need_convert)
    return self
end

function TEstimatedRemainingLifespanInsufficient:unpack(_)
    return self.EstimatedRemainingLifespanInsufficient
end

DriveSubHealth.EstimatedRemainingLifespanInsufficient = TEstimatedRemainingLifespanInsufficient

DriveSubHealth.interface = mdb.register_interface('bmc.kepler.Systems.Storage.Drive.DriveSubHealth', {
    EstimatedRemainingLifespanInsufficient = {'y', nil, true, nil, false},
    SLCSpareBlockPercentage = {'y', nil, true, 255, false},
    TLCSpareBlockPercentage = {'y', nil, true, 255, false},
    EstimatedRemainingLifespan = {'u', nil, true, 4294967295, false},
    IODeteriorationHealthCode = {'q', nil, true, nil, false}
}, {}, {})

return DriveSubHealth
