-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local DiskPartition = {}

---@class DiskPartition.TotalCapacityGiB
---@field TotalCapacityGiB number
local TTotalCapacityGiB = {}
TTotalCapacityGiB.__index = TTotalCapacityGiB
TTotalCapacityGiB.group = {}

local function TTotalCapacityGiB_from_obj(obj)
    return setmetatable(obj, TTotalCapacityGiB)
end

function TTotalCapacityGiB.new(TotalCapacityGiB)
    return TTotalCapacityGiB_from_obj({TotalCapacityGiB = TotalCapacityGiB})
end
---@param obj DiskPartition.TotalCapacityGiB
function TTotalCapacityGiB:init_from_obj(obj)
    self.TotalCapacityGiB = obj.TotalCapacityGiB
end

function TTotalCapacityGiB:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTotalCapacityGiB.group)
end

TTotalCapacityGiB.from_obj = TTotalCapacityGiB_from_obj

TTotalCapacityGiB.proto_property = {'TotalCapacityGiB'}

TTotalCapacityGiB.default = {0}

TTotalCapacityGiB.struct = {{name = 'TotalCapacityGiB', is_array = false, struct = nil}}

function TTotalCapacityGiB:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TotalCapacityGiB', self.TotalCapacityGiB, 'double', true, errs, need_convert)

    TTotalCapacityGiB:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTotalCapacityGiB.proto_property, errs, need_convert)
    return self
end

function TTotalCapacityGiB:unpack(_)
    return self.TotalCapacityGiB
end

DiskPartition.TotalCapacityGiB = TTotalCapacityGiB

---@class DiskPartition.UsedCapacityGiB
---@field UsedCapacityGiB number
local TUsedCapacityGiB = {}
TUsedCapacityGiB.__index = TUsedCapacityGiB
TUsedCapacityGiB.group = {}

local function TUsedCapacityGiB_from_obj(obj)
    return setmetatable(obj, TUsedCapacityGiB)
end

function TUsedCapacityGiB.new(UsedCapacityGiB)
    return TUsedCapacityGiB_from_obj({UsedCapacityGiB = UsedCapacityGiB})
end
---@param obj DiskPartition.UsedCapacityGiB
function TUsedCapacityGiB:init_from_obj(obj)
    self.UsedCapacityGiB = obj.UsedCapacityGiB
end

function TUsedCapacityGiB:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUsedCapacityGiB.group)
end

TUsedCapacityGiB.from_obj = TUsedCapacityGiB_from_obj

TUsedCapacityGiB.proto_property = {'UsedCapacityGiB'}

TUsedCapacityGiB.default = {0}

TUsedCapacityGiB.struct = {{name = 'UsedCapacityGiB', is_array = false, struct = nil}}

function TUsedCapacityGiB:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UsedCapacityGiB', self.UsedCapacityGiB, 'double', true, errs, need_convert)

    TUsedCapacityGiB:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUsedCapacityGiB.proto_property, errs, need_convert)
    return self
end

function TUsedCapacityGiB:unpack(_)
    return self.UsedCapacityGiB
end

DiskPartition.UsedCapacityGiB = TUsedCapacityGiB

---@class DiskPartition.Usage
---@field Usage integer
local TUsage = {}
TUsage.__index = TUsage
TUsage.group = {}

local function TUsage_from_obj(obj)
    return setmetatable(obj, TUsage)
end

function TUsage.new(Usage)
    return TUsage_from_obj({Usage = Usage})
end
---@param obj DiskPartition.Usage
function TUsage:init_from_obj(obj)
    self.Usage = obj.Usage
end

function TUsage:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUsage.group)
end

TUsage.from_obj = TUsage_from_obj

TUsage.proto_property = {'Usage'}

TUsage.default = {0}

TUsage.struct = {{name = 'Usage', is_array = false, struct = nil}}

function TUsage:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Usage', self.Usage, 'uint8', true, errs, need_convert)

    TUsage:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUsage.proto_property, errs, need_convert)
    return self
end

function TUsage:unpack(_)
    return self.Usage
end

DiskPartition.Usage = TUsage

---@class DiskPartition.Name
---@field Name string
local TName = {}
TName.__index = TName
TName.group = {}

local function TName_from_obj(obj)
    return setmetatable(obj, TName)
end

function TName.new(Name)
    return TName_from_obj({Name = Name})
end
---@param obj DiskPartition.Name
function TName:init_from_obj(obj)
    self.Name = obj.Name
end

function TName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TName.group)
end

TName.from_obj = TName_from_obj

TName.proto_property = {'Name'}

TName.default = {''}

TName.struct = {{name = 'Name', is_array = false, struct = nil}}

function TName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Name', self.Name, 'string', true, errs, need_convert)

    TName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TName.proto_property, errs, need_convert)
    return self
end

function TName:unpack(_)
    return self.Name
end

DiskPartition.Name = TName

DiskPartition.interface = mdb.register_interface('bmc.kepler.Systems.Storage.DiskPartition', {
    Name = {'s', nil, true, nil, false},
    Usage = {'y', nil, true, nil, false},
    UsedCapacityGiB = {'d', nil, true, nil, false},
    TotalCapacityGiB = {'d', nil, true, nil, false}
}, {}, {})

return DiskPartition
