-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Connector = {}

---@class Connector.LoadStatus
---@field LoadStatus integer
local TLoadStatus = {}
TLoadStatus.__index = TLoadStatus
TLoadStatus.group = {}

local function TLoadStatus_from_obj(obj)
    return setmetatable(obj, TLoadStatus)
end

function TLoadStatus.new(LoadStatus)
    return TLoadStatus_from_obj({LoadStatus = LoadStatus or 255})
end
---@param obj Connector.LoadStatus
function TLoadStatus:init_from_obj(obj)
    self.LoadStatus = obj.LoadStatus or 255
end

function TLoadStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLoadStatus.group)
end

TLoadStatus.from_obj = TLoadStatus_from_obj

TLoadStatus.proto_property = {'LoadStatus'}

TLoadStatus.default = {0}

TLoadStatus.struct = {{name = 'LoadStatus', is_array = false, struct = nil}}

function TLoadStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LoadStatus', self.LoadStatus, 'uint8', true, errs, need_convert)

    TLoadStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLoadStatus.proto_property, errs, need_convert)
    return self
end

function TLoadStatus:unpack(_)
    return self.LoadStatus
end

Connector.LoadStatus = TLoadStatus

---@class Connector.ChassisId
---@field ChassisId string
local TChassisId = {}
TChassisId.__index = TChassisId
TChassisId.group = {}

local function TChassisId_from_obj(obj)
    return setmetatable(obj, TChassisId)
end

function TChassisId.new(ChassisId)
    return TChassisId_from_obj({ChassisId = ChassisId})
end
---@param obj Connector.ChassisId
function TChassisId:init_from_obj(obj)
    self.ChassisId = obj.ChassisId
end

function TChassisId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChassisId.group)
end

TChassisId.from_obj = TChassisId_from_obj

TChassisId.proto_property = {'ChassisId'}

TChassisId.default = {''}

TChassisId.struct = {{name = 'ChassisId', is_array = false, struct = nil}}

function TChassisId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChassisId', self.ChassisId, 'string', true, errs, need_convert)

    TChassisId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChassisId.proto_property, errs, need_convert)
    return self
end

function TChassisId:unpack(_)
    return self.ChassisId
end

Connector.ChassisId = TChassisId

---@class Connector.IdentifyMode
---@field IdentifyMode integer
local TIdentifyMode = {}
TIdentifyMode.__index = TIdentifyMode
TIdentifyMode.group = {}

local function TIdentifyMode_from_obj(obj)
    return setmetatable(obj, TIdentifyMode)
end

function TIdentifyMode.new(IdentifyMode)
    return TIdentifyMode_from_obj({IdentifyMode = IdentifyMode})
end
---@param obj Connector.IdentifyMode
function TIdentifyMode:init_from_obj(obj)
    self.IdentifyMode = obj.IdentifyMode
end

function TIdentifyMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIdentifyMode.group)
end

TIdentifyMode.from_obj = TIdentifyMode_from_obj

TIdentifyMode.proto_property = {'IdentifyMode'}

TIdentifyMode.default = {0}

TIdentifyMode.struct = {{name = 'IdentifyMode', is_array = false, struct = nil}}

function TIdentifyMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IdentifyMode', self.IdentifyMode, 'uint8', true, errs, need_convert)

    TIdentifyMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIdentifyMode.proto_property, errs, need_convert)
    return self
end

function TIdentifyMode:unpack(_)
    return self.IdentifyMode
end

Connector.IdentifyMode = TIdentifyMode

---@class Connector.Type
---@field Type string
local TType = {}
TType.__index = TType
TType.group = {}

local function TType_from_obj(obj)
    return setmetatable(obj, TType)
end

function TType.new(Type)
    return TType_from_obj({Type = Type})
end
---@param obj Connector.Type
function TType:init_from_obj(obj)
    self.Type = obj.Type
end

function TType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TType.group)
end

TType.from_obj = TType_from_obj

TType.proto_property = {'Type'}

TType.default = {''}

TType.struct = {{name = 'Type', is_array = false, struct = nil}}

function TType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'string', true, errs, need_convert)

    TType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TType.proto_property, errs, need_convert)
    return self
end

function TType:unpack(_)
    return self.Type
end

Connector.Type = TType

---@class Connector.SilkText
---@field SilkText string
local TSilkText = {}
TSilkText.__index = TSilkText
TSilkText.group = {}

local function TSilkText_from_obj(obj)
    return setmetatable(obj, TSilkText)
end

function TSilkText.new(SilkText)
    return TSilkText_from_obj({SilkText = SilkText})
end
---@param obj Connector.SilkText
function TSilkText:init_from_obj(obj)
    self.SilkText = obj.SilkText
end

function TSilkText:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSilkText.group)
end

TSilkText.from_obj = TSilkText_from_obj

TSilkText.proto_property = {'SilkText'}

TSilkText.default = {''}

TSilkText.struct = {{name = 'SilkText', is_array = false, struct = nil}}

function TSilkText:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SilkText', self.SilkText, 'string', true, errs, need_convert)

    TSilkText:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSilkText.proto_property, errs, need_convert)
    return self
end

function TSilkText:unpack(_)
    return self.SilkText
end

Connector.SilkText = TSilkText

---@class Connector.ManagerId
---@field ManagerId string
local TManagerId = {}
TManagerId.__index = TManagerId
TManagerId.group = {}

local function TManagerId_from_obj(obj)
    return setmetatable(obj, TManagerId)
end

function TManagerId.new(ManagerId)
    return TManagerId_from_obj({ManagerId = ManagerId})
end
---@param obj Connector.ManagerId
function TManagerId:init_from_obj(obj)
    self.ManagerId = obj.ManagerId
end

function TManagerId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManagerId.group)
end

TManagerId.from_obj = TManagerId_from_obj

TManagerId.proto_property = {'ManagerId'}

TManagerId.default = {''}

TManagerId.struct = {{name = 'ManagerId', is_array = false, struct = nil}}

function TManagerId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManagerId', self.ManagerId, 'string', true, errs, need_convert)

    TManagerId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManagerId.proto_property, errs, need_convert)
    return self
end

function TManagerId:unpack(_)
    return self.ManagerId
end

Connector.ManagerId = TManagerId

---@class Connector.SystemId
---@field SystemId integer
local TSystemId = {}
TSystemId.__index = TSystemId
TSystemId.group = {}

local function TSystemId_from_obj(obj)
    return setmetatable(obj, TSystemId)
end

function TSystemId.new(SystemId)
    return TSystemId_from_obj({SystemId = SystemId})
end
---@param obj Connector.SystemId
function TSystemId:init_from_obj(obj)
    self.SystemId = obj.SystemId
end

function TSystemId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemId.group)
end

TSystemId.from_obj = TSystemId_from_obj

TSystemId.proto_property = {'SystemId'}

TSystemId.default = {0}

TSystemId.struct = {{name = 'SystemId', is_array = false, struct = nil}}

function TSystemId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'uint8', true, errs, need_convert)

    TSystemId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemId.proto_property, errs, need_convert)
    return self
end

function TSystemId:unpack(_)
    return self.SystemId
end

Connector.SystemId = TSystemId

---@class Connector.Buses
---@field Buses string[]
local TBuses = {}
TBuses.__index = TBuses
TBuses.group = {}

local function TBuses_from_obj(obj)
    return setmetatable(obj, TBuses)
end

function TBuses.new(Buses)
    return TBuses_from_obj({Buses = Buses})
end
---@param obj Connector.Buses
function TBuses:init_from_obj(obj)
    self.Buses = obj.Buses
end

function TBuses:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBuses.group)
end

TBuses.from_obj = TBuses_from_obj

TBuses.proto_property = {'Buses'}

TBuses.default = {{}}

TBuses.struct = {{name = 'Buses', is_array = true, struct = nil}}

function TBuses:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'Buses', self.Buses, 'string', true, errs, need_convert)

    TBuses:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBuses.proto_property, errs, need_convert)
    return self
end

function TBuses:unpack(_)
    return self.Buses
end

Connector.Buses = TBuses

---@class Connector.AuxId
---@field AuxId string
local TAuxId = {}
TAuxId.__index = TAuxId
TAuxId.group = {}

local function TAuxId_from_obj(obj)
    return setmetatable(obj, TAuxId)
end

function TAuxId.new(AuxId)
    return TAuxId_from_obj({AuxId = AuxId})
end
---@param obj Connector.AuxId
function TAuxId:init_from_obj(obj)
    self.AuxId = obj.AuxId
end

function TAuxId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAuxId.group)
end

TAuxId.from_obj = TAuxId_from_obj

TAuxId.proto_property = {'AuxId'}

TAuxId.default = {''}

TAuxId.struct = {{name = 'AuxId', is_array = false, struct = nil}}

function TAuxId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AuxId', self.AuxId, 'string', false, errs, need_convert)

    TAuxId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAuxId.proto_property, errs, need_convert)
    return self
end

function TAuxId:unpack(_)
    return self.AuxId
end

Connector.AuxId = TAuxId

---@class Connector.Id
---@field Id string
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj Connector.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {''}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

Connector.Id = TId

---@class Connector.Presence
---@field Presence integer
local TPresence = {}
TPresence.__index = TPresence
TPresence.group = {}

local function TPresence_from_obj(obj)
    return setmetatable(obj, TPresence)
end

function TPresence.new(Presence)
    return TPresence_from_obj({Presence = Presence})
end
---@param obj Connector.Presence
function TPresence:init_from_obj(obj)
    self.Presence = obj.Presence
end

function TPresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPresence.group)
end

TPresence.from_obj = TPresence_from_obj

TPresence.proto_property = {'Presence'}

TPresence.default = {0}

TPresence.struct = {{name = 'Presence', is_array = false, struct = nil}}

function TPresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Presence', self.Presence, 'uint8', false, errs, need_convert)

    TPresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPresence.proto_property, errs, need_convert)
    return self
end

function TPresence:unpack(_)
    return self.Presence
end

Connector.Presence = TPresence

---@class Connector.GroupPosition
---@field GroupPosition string
local TGroupPosition = {}
TGroupPosition.__index = TGroupPosition
TGroupPosition.group = {}

local function TGroupPosition_from_obj(obj)
    return setmetatable(obj, TGroupPosition)
end

function TGroupPosition.new(GroupPosition)
    return TGroupPosition_from_obj({GroupPosition = GroupPosition})
end
---@param obj Connector.GroupPosition
function TGroupPosition:init_from_obj(obj)
    self.GroupPosition = obj.GroupPosition
end

function TGroupPosition:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGroupPosition.group)
end

TGroupPosition.from_obj = TGroupPosition_from_obj

TGroupPosition.proto_property = {'GroupPosition'}

TGroupPosition.default = {''}

TGroupPosition.struct = {{name = 'GroupPosition', is_array = false, struct = nil}}

function TGroupPosition:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GroupPosition', self.GroupPosition, 'string', true, errs, need_convert)

    TGroupPosition:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGroupPosition.proto_property, errs, need_convert)
    return self
end

function TGroupPosition:unpack(_)
    return self.GroupPosition
end

Connector.GroupPosition = TGroupPosition

---@class Connector.GroupId
---@field GroupId integer
local TGroupId = {}
TGroupId.__index = TGroupId
TGroupId.group = {}

local function TGroupId_from_obj(obj)
    return setmetatable(obj, TGroupId)
end

function TGroupId.new(GroupId)
    return TGroupId_from_obj({GroupId = GroupId})
end
---@param obj Connector.GroupId
function TGroupId:init_from_obj(obj)
    self.GroupId = obj.GroupId
end

function TGroupId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGroupId.group)
end

TGroupId.from_obj = TGroupId_from_obj

TGroupId.proto_property = {'GroupId'}

TGroupId.default = {0}

TGroupId.struct = {{name = 'GroupId', is_array = false, struct = nil}}

function TGroupId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GroupId', self.GroupId, 'uint32', true, errs, need_convert)

    TGroupId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGroupId.proto_property, errs, need_convert)
    return self
end

function TGroupId:unpack(_)
    return self.GroupId
end

Connector.GroupId = TGroupId

---@class Connector.Slot
---@field Slot integer
local TSlot = {}
TSlot.__index = TSlot
TSlot.group = {}

local function TSlot_from_obj(obj)
    return setmetatable(obj, TSlot)
end

function TSlot.new(Slot)
    return TSlot_from_obj({Slot = Slot})
end
---@param obj Connector.Slot
function TSlot:init_from_obj(obj)
    self.Slot = obj.Slot
end

function TSlot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlot.group)
end

TSlot.from_obj = TSlot_from_obj

TSlot.proto_property = {'Slot'}

TSlot.default = {0}

TSlot.struct = {{name = 'Slot', is_array = false, struct = nil}}

function TSlot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Slot', self.Slot, 'uint8', false, errs, need_convert)

    TSlot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlot.proto_property, errs, need_convert)
    return self
end

function TSlot:unpack(_)
    return self.Slot
end

Connector.Slot = TSlot

---@class Connector.Bom
---@field Bom string
local TBom = {}
TBom.__index = TBom
TBom.group = {}

local function TBom_from_obj(obj)
    return setmetatable(obj, TBom)
end

function TBom.new(Bom)
    return TBom_from_obj({Bom = Bom})
end
---@param obj Connector.Bom
function TBom:init_from_obj(obj)
    self.Bom = obj.Bom
end

function TBom:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBom.group)
end

TBom.from_obj = TBom_from_obj

TBom.proto_property = {'Bom'}

TBom.default = {''}

TBom.struct = {{name = 'Bom', is_array = false, struct = nil}}

function TBom:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Bom', self.Bom, 'string', true, errs, need_convert)

    TBom:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBom.proto_property, errs, need_convert)
    return self
end

function TBom:unpack(_)
    return self.Bom
end

Connector.Bom = TBom

---@class Connector.ReloadRsp
local TReloadRsp = {}
TReloadRsp.__index = TReloadRsp
TReloadRsp.group = {}

local function TReloadRsp_from_obj(obj)
    return setmetatable(obj, TReloadRsp)
end

function TReloadRsp.new()
    return TReloadRsp_from_obj({})
end
---@param obj Connector.ReloadRsp
function TReloadRsp:init_from_obj(obj)

end

function TReloadRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReloadRsp.group)
end

TReloadRsp.from_obj = TReloadRsp_from_obj

TReloadRsp.proto_property = {}

TReloadRsp.default = {}

TReloadRsp.struct = {}

function TReloadRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TReloadRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReloadRsp.proto_property, errs, need_convert)
    return self
end

function TReloadRsp:unpack(_)
end

Connector.ReloadRsp = TReloadRsp

---@class Connector.ReloadReq
---@field Bom string
---@field Id string
---@field AuxId string
---@field IdentifyMode integer
local TReloadReq = {}
TReloadReq.__index = TReloadReq
TReloadReq.group = {}

local function TReloadReq_from_obj(obj)
    return setmetatable(obj, TReloadReq)
end

function TReloadReq.new(Bom, Id, AuxId, IdentifyMode)
    return TReloadReq_from_obj({Bom = Bom, Id = Id, AuxId = AuxId, IdentifyMode = IdentifyMode})
end
---@param obj Connector.ReloadReq
function TReloadReq:init_from_obj(obj)
    self.Bom = obj.Bom
    self.Id = obj.Id
    self.AuxId = obj.AuxId
    self.IdentifyMode = obj.IdentifyMode
end

function TReloadReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReloadReq.group)
end

TReloadReq.from_obj = TReloadReq_from_obj

TReloadReq.proto_property = {'Bom', 'Id', 'AuxId', 'IdentifyMode'}

TReloadReq.default = {'', '', '', 0}

TReloadReq.struct = {
    {name = 'Bom', is_array = false, struct = nil}, {name = 'Id', is_array = false, struct = nil},
    {name = 'AuxId', is_array = false, struct = nil}, {name = 'IdentifyMode', is_array = false, struct = nil}
}

function TReloadReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Bom', self.Bom, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'AuxId', self.AuxId, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'IdentifyMode', self.IdentifyMode, 'uint8', false, errs, need_convert)

    TReloadReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReloadReq.proto_property, errs, need_convert)
    return self
end

function TReloadReq:unpack(_)
    return self.Bom, self.Id, self.AuxId, self.IdentifyMode
end

Connector.ReloadReq = TReloadReq

Connector.interface = mdb.register_interface('bmc.kepler.Connector', {
    Bom = {'s', nil, true, nil, false},
    Slot = {'y', nil, false, nil, false},
    GroupId = {'u', nil, true, nil, false},
    GroupPosition = {'s', nil, true, nil, false},
    Presence = {'y', nil, false, nil, false},
    Id = {'s', nil, false, nil, false},
    AuxId = {'s', nil, false, nil, false},
    Buses = {'as', nil, true, nil, false},
    SystemId = {'y', nil, true, nil, false},
    ManagerId = {'s', nil, true, nil, false},
    SilkText = {'s', nil, true, nil, false},
    Type = {'s', nil, true, nil, false},
    IdentifyMode = {'y', nil, true, nil, false},
    ChassisId = {'s', nil, true, nil, false},
    LoadStatus = {'y', nil, true, 255, false}
}, {Reload = {'a{ss}sssy', '', TReloadReq, TReloadRsp}}, {})

return Connector
