--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local StartDriveCollectLog = {}

---@class StorageIpmiCmds.StartDriveCollectLogReq
---@field ManufacturerId integer
---@field Reserve integer
---@field DriveId integer
---@field Frame integer
---@field WritingOffset integer
---@field WritingLength integer
---@field Data string
local TStartDriveCollectLogReq = {}
TStartDriveCollectLogReq.__index = TStartDriveCollectLogReq
TStartDriveCollectLogReq.group = {}

local function TStartDriveCollectLogReq_from_obj(obj)
    return setmetatable(obj, TStartDriveCollectLogReq)
end

function TStartDriveCollectLogReq.new(ManufacturerId, Reserve, DriveId, Frame, WritingOffset, WritingLength, Data)
    return TStartDriveCollectLogReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        DriveId = DriveId,
        Frame = Frame,
        WritingOffset = WritingOffset,
        WritingLength = WritingLength,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.StartDriveCollectLogReq
function TStartDriveCollectLogReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.DriveId = obj.DriveId
    self.Frame = obj.Frame
    self.WritingOffset = obj.WritingOffset
    self.WritingLength = obj.WritingLength
    self.Data = obj.Data
end

function TStartDriveCollectLogReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartDriveCollectLogReq.group)
end

TStartDriveCollectLogReq.from_obj = TStartDriveCollectLogReq_from_obj

TStartDriveCollectLogReq.proto_property = {
    'ManufacturerId', 'Reserve', 'DriveId', 'Frame', 'WritingOffset', 'WritingLength', 'Data'
}

TStartDriveCollectLogReq.default = {0, 0, 0, 0, 0, 0, ''}

TStartDriveCollectLogReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'DriveId', is_array = false, struct = nil}, {name = 'Frame', is_array = false, struct = nil},
    {name = 'WritingOffset', is_array = false, struct = nil}, {name = 'WritingLength', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TStartDriveCollectLogReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DriveId', self.DriveId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Frame', self.Frame, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingOffset', self.WritingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingLength', self.WritingLength, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TStartDriveCollectLogReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartDriveCollectLogReq.proto_property, errs, need_convert)
    return self
end

function TStartDriveCollectLogReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.DriveId, self.Frame, self.WritingOffset, self.WritingLength,
        self.Data
end

StartDriveCollectLog.StartDriveCollectLogReq = TStartDriveCollectLogReq

---@class StorageIpmiCmds.StartDriveCollectLogRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TStartDriveCollectLogRsp = {}
TStartDriveCollectLogRsp.__index = TStartDriveCollectLogRsp
TStartDriveCollectLogRsp.group = {}

local function TStartDriveCollectLogRsp_from_obj(obj)
    return setmetatable(obj, TStartDriveCollectLogRsp)
end

function TStartDriveCollectLogRsp.new(CompletionCode, ManufactureId)
    return TStartDriveCollectLogRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj StorageIpmiCmds.StartDriveCollectLogRsp
function TStartDriveCollectLogRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TStartDriveCollectLogRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartDriveCollectLogRsp.group)
end

TStartDriveCollectLogRsp.from_obj = TStartDriveCollectLogRsp_from_obj

TStartDriveCollectLogRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TStartDriveCollectLogRsp.default = {0, 0}

TStartDriveCollectLogRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TStartDriveCollectLogRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TStartDriveCollectLogRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartDriveCollectLogRsp.proto_property, errs, need_convert)
    return self
end

function TStartDriveCollectLogRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

StartDriveCollectLog.StartDriveCollectLogRsp = TStartDriveCollectLogRsp

return StartDriveCollectLog
