--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetPdLogCollect = {}

---@class StorageIpmiCmds.SetPdLogCollectReq
---@field ManufacturerId integer
---@field Reserve integer
local TSetPdLogCollectReq = {}
TSetPdLogCollectReq.__index = TSetPdLogCollectReq
TSetPdLogCollectReq.group = {}

local function TSetPdLogCollectReq_from_obj(obj)
    return setmetatable(obj, TSetPdLogCollectReq)
end

function TSetPdLogCollectReq.new(ManufacturerId, Reserve)
    return TSetPdLogCollectReq_from_obj({ManufacturerId = ManufacturerId, Reserve = Reserve})
end
---@param obj StorageIpmiCmds.SetPdLogCollectReq
function TSetPdLogCollectReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
end

function TSetPdLogCollectReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPdLogCollectReq.group)
end

TSetPdLogCollectReq.from_obj = TSetPdLogCollectReq_from_obj

TSetPdLogCollectReq.proto_property = {'ManufacturerId', 'Reserve'}

TSetPdLogCollectReq.default = {0, 0}

TSetPdLogCollectReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil}
}

function TSetPdLogCollectReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)

    TSetPdLogCollectReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPdLogCollectReq.proto_property, errs, need_convert)
    return self
end

function TSetPdLogCollectReq:unpack(_)
    return self.ManufacturerId, self.Reserve
end

SetPdLogCollect.SetPdLogCollectReq = TSetPdLogCollectReq

---@class StorageIpmiCmds.SetPdLogCollectRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetPdLogCollectRsp = {}
TSetPdLogCollectRsp.__index = TSetPdLogCollectRsp
TSetPdLogCollectRsp.group = {}

local function TSetPdLogCollectRsp_from_obj(obj)
    return setmetatable(obj, TSetPdLogCollectRsp)
end

function TSetPdLogCollectRsp.new(CompletionCode, ManufactureId)
    return TSetPdLogCollectRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj StorageIpmiCmds.SetPdLogCollectRsp
function TSetPdLogCollectRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetPdLogCollectRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPdLogCollectRsp.group)
end

TSetPdLogCollectRsp.from_obj = TSetPdLogCollectRsp_from_obj

TSetPdLogCollectRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetPdLogCollectRsp.default = {0, 0}

TSetPdLogCollectRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetPdLogCollectRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetPdLogCollectRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPdLogCollectRsp.proto_property, errs, need_convert)
    return self
end

function TSetPdLogCollectRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetPdLogCollect.SetPdLogCollectRsp = TSetPdLogCollectRsp

return SetPdLogCollect
