--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetPCHDiskInfo = {}

---@class StorageIpmiCmds.SetPCHDiskInfoReq
---@field DiskType integer
---@field SlotNumber integer
---@field InterfaceType integer
---@field FirmwareVersionLen integer
---@field FirmwareVersion string
---@field Reserve string
---@field CapacityMB integer
---@field ModelLen integer
---@field Model string
---@field SNLen integer
---@field SN string
---@field Reserve1 string
---@field MediaType integer
---@field NegotitatedspeedGbs integer
---@field CapableSpeedGbs integer
---@field ManufacturerLen integer
---@field Manufacturer string
local TSetPCHDiskInfoReq = {}
TSetPCHDiskInfoReq.__index = TSetPCHDiskInfoReq
TSetPCHDiskInfoReq.group = {}

local function TSetPCHDiskInfoReq_from_obj(obj)
    return setmetatable(obj, TSetPCHDiskInfoReq)
end

function TSetPCHDiskInfoReq.new(DiskType, SlotNumber, InterfaceType, FirmwareVersionLen, FirmwareVersion, Reserve,
    CapacityMB, ModelLen, Model, SNLen, SN, Reserve1, MediaType, NegotitatedspeedGbs, CapableSpeedGbs, ManufacturerLen,
    Manufacturer)
    return TSetPCHDiskInfoReq_from_obj({
        DiskType = DiskType,
        SlotNumber = SlotNumber,
        InterfaceType = InterfaceType,
        FirmwareVersionLen = FirmwareVersionLen,
        FirmwareVersion = FirmwareVersion,
        Reserve = Reserve,
        CapacityMB = CapacityMB,
        ModelLen = ModelLen,
        Model = Model,
        SNLen = SNLen,
        SN = SN,
        Reserve1 = Reserve1,
        MediaType = MediaType,
        NegotitatedspeedGbs = NegotitatedspeedGbs,
        CapableSpeedGbs = CapableSpeedGbs,
        ManufacturerLen = ManufacturerLen,
        Manufacturer = Manufacturer
    })
end
---@param obj StorageIpmiCmds.SetPCHDiskInfoReq
function TSetPCHDiskInfoReq:init_from_obj(obj)
    self.DiskType = obj.DiskType
    self.SlotNumber = obj.SlotNumber
    self.InterfaceType = obj.InterfaceType
    self.FirmwareVersionLen = obj.FirmwareVersionLen
    self.FirmwareVersion = obj.FirmwareVersion
    self.Reserve = obj.Reserve
    self.CapacityMB = obj.CapacityMB
    self.ModelLen = obj.ModelLen
    self.Model = obj.Model
    self.SNLen = obj.SNLen
    self.SN = obj.SN
    self.Reserve1 = obj.Reserve1
    self.MediaType = obj.MediaType
    self.NegotitatedspeedGbs = obj.NegotitatedspeedGbs
    self.CapableSpeedGbs = obj.CapableSpeedGbs
    self.ManufacturerLen = obj.ManufacturerLen
    self.Manufacturer = obj.Manufacturer
end

function TSetPCHDiskInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPCHDiskInfoReq.group)
end

TSetPCHDiskInfoReq.from_obj = TSetPCHDiskInfoReq_from_obj

TSetPCHDiskInfoReq.proto_property = {
    'DiskType', 'SlotNumber', 'InterfaceType', 'FirmwareVersionLen', 'FirmwareVersion', 'Reserve', 'CapacityMB',
    'ModelLen', 'Model', 'SNLen', 'SN', 'Reserve1', 'MediaType', 'NegotitatedspeedGbs', 'CapableSpeedGbs',
    'ManufacturerLen', 'Manufacturer'
}

TSetPCHDiskInfoReq.default = {0, 0, 0, 0, '', '', 0, 0, '', 0, '', '', 0, 0, 0, 0, ''}

TSetPCHDiskInfoReq.struct = {
    {name = 'DiskType', is_array = false, struct = nil}, {name = 'SlotNumber', is_array = false, struct = nil},
    {name = 'InterfaceType', is_array = false, struct = nil},
    {name = 'FirmwareVersionLen', is_array = false, struct = nil},
    {name = 'FirmwareVersion', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'CapacityMB', is_array = false, struct = nil}, {name = 'ModelLen', is_array = false, struct = nil},
    {name = 'Model', is_array = false, struct = nil}, {name = 'SNLen', is_array = false, struct = nil},
    {name = 'SN', is_array = false, struct = nil}, {name = 'Reserve1', is_array = false, struct = nil},
    {name = 'MediaType', is_array = false, struct = nil},
    {name = 'NegotitatedspeedGbs', is_array = false, struct = nil},
    {name = 'CapableSpeedGbs', is_array = false, struct = nil},
    {name = 'ManufacturerLen', is_array = false, struct = nil}, {name = 'Manufacturer', is_array = false, struct = nil}
}

function TSetPCHDiskInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DiskType', self.DiskType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SlotNumber', self.SlotNumber, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'InterfaceType', self.InterfaceType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FirmwareVersionLen', self.FirmwareVersionLen, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FirmwareVersion', self.FirmwareVersion, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'CapacityMB', self.CapacityMB, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'ModelLen', self.ModelLen, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Model', self.Model, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SNLen', self.SNLen, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SN', self.SN, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve1', self.Reserve1, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'MediaType', self.MediaType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'NegotitatedspeedGbs', self.NegotitatedspeedGbs, 'uint64', false, errs, need_convert)
    validate.Optional(prefix .. 'CapableSpeedGbs', self.CapableSpeedGbs, 'uint64', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufacturerLen', self.ManufacturerLen, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Manufacturer', self.Manufacturer, 'string', false, errs, need_convert)

    TSetPCHDiskInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPCHDiskInfoReq.proto_property, errs, need_convert)
    return self
end

function TSetPCHDiskInfoReq:unpack(_)
    return self.DiskType, self.SlotNumber, self.InterfaceType, self.FirmwareVersionLen, self.FirmwareVersion,
        self.Reserve, self.CapacityMB, self.ModelLen, self.Model, self.SNLen, self.SN, self.Reserve1, self.MediaType,
        self.NegotitatedspeedGbs, self.CapableSpeedGbs, self.ManufacturerLen, self.Manufacturer
end

SetPCHDiskInfo.SetPCHDiskInfoReq = TSetPCHDiskInfoReq

---@class StorageIpmiCmds.SetPCHDiskInfoRsp
---@field CompletionCode integer
local TSetPCHDiskInfoRsp = {}
TSetPCHDiskInfoRsp.__index = TSetPCHDiskInfoRsp
TSetPCHDiskInfoRsp.group = {}

local function TSetPCHDiskInfoRsp_from_obj(obj)
    return setmetatable(obj, TSetPCHDiskInfoRsp)
end

function TSetPCHDiskInfoRsp.new(CompletionCode)
    return TSetPCHDiskInfoRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj StorageIpmiCmds.SetPCHDiskInfoRsp
function TSetPCHDiskInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetPCHDiskInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPCHDiskInfoRsp.group)
end

TSetPCHDiskInfoRsp.from_obj = TSetPCHDiskInfoRsp_from_obj

TSetPCHDiskInfoRsp.proto_property = {'CompletionCode'}

TSetPCHDiskInfoRsp.default = {0}

TSetPCHDiskInfoRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetPCHDiskInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetPCHDiskInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPCHDiskInfoRsp.proto_property, errs, need_convert)
    return self
end

function TSetPCHDiskInfoRsp:unpack(_)
    return self.CompletionCode
end

SetPCHDiskInfo.SetPCHDiskInfoRsp = TSetPCHDiskInfoRsp

return SetPCHDiskInfo
