--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetLogicalDriveCachecade = {}

---@class StorageIpmiCmds.SetLogicalDriveCachecadeReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ControllerId integer
---@field VolumeId integer
---@field Frame integer
---@field WritingOffset integer
---@field WritingLength integer
---@field Data string
local TSetLogicalDriveCachecadeReq = {}
TSetLogicalDriveCachecadeReq.__index = TSetLogicalDriveCachecadeReq
TSetLogicalDriveCachecadeReq.group = {}

local function TSetLogicalDriveCachecadeReq_from_obj(obj)
    return setmetatable(obj, TSetLogicalDriveCachecadeReq)
end

function TSetLogicalDriveCachecadeReq.new(ManufacturerId, Reserve, ControllerId, VolumeId, Frame, WritingOffset,
    WritingLength, Data)
    return TSetLogicalDriveCachecadeReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ControllerId = ControllerId,
        VolumeId = VolumeId,
        Frame = Frame,
        WritingOffset = WritingOffset,
        WritingLength = WritingLength,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.SetLogicalDriveCachecadeReq
function TSetLogicalDriveCachecadeReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ControllerId = obj.ControllerId
    self.VolumeId = obj.VolumeId
    self.Frame = obj.Frame
    self.WritingOffset = obj.WritingOffset
    self.WritingLength = obj.WritingLength
    self.Data = obj.Data
end

function TSetLogicalDriveCachecadeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLogicalDriveCachecadeReq.group)
end

TSetLogicalDriveCachecadeReq.from_obj = TSetLogicalDriveCachecadeReq_from_obj

TSetLogicalDriveCachecadeReq.proto_property = {
    'ManufacturerId', 'Reserve', 'ControllerId', 'VolumeId', 'Frame', 'WritingOffset', 'WritingLength', 'Data'
}

TSetLogicalDriveCachecadeReq.default = {0, 0, 0, 0, 0, 0, 0, ''}

TSetLogicalDriveCachecadeReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'VolumeId', is_array = false, struct = nil},
    {name = 'Frame', is_array = false, struct = nil}, {name = 'WritingOffset', is_array = false, struct = nil},
    {name = 'WritingLength', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetLogicalDriveCachecadeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'VolumeId', self.VolumeId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Frame', self.Frame, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingOffset', self.WritingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingLength', self.WritingLength, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetLogicalDriveCachecadeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLogicalDriveCachecadeReq.proto_property, errs, need_convert)
    return self
end

function TSetLogicalDriveCachecadeReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ControllerId, self.VolumeId, self.Frame, self.WritingOffset,
        self.WritingLength, self.Data
end

SetLogicalDriveCachecade.SetLogicalDriveCachecadeReq = TSetLogicalDriveCachecadeReq

---@class StorageIpmiCmds.SetLogicalDriveCachecadeRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TSetLogicalDriveCachecadeRsp = {}
TSetLogicalDriveCachecadeRsp.__index = TSetLogicalDriveCachecadeRsp
TSetLogicalDriveCachecadeRsp.group = {}

local function TSetLogicalDriveCachecadeRsp_from_obj(obj)
    return setmetatable(obj, TSetLogicalDriveCachecadeRsp)
end

function TSetLogicalDriveCachecadeRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TSetLogicalDriveCachecadeRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.SetLogicalDriveCachecadeRsp
function TSetLogicalDriveCachecadeRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TSetLogicalDriveCachecadeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLogicalDriveCachecadeRsp.group)
end

TSetLogicalDriveCachecadeRsp.from_obj = TSetLogicalDriveCachecadeRsp_from_obj

TSetLogicalDriveCachecadeRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TSetLogicalDriveCachecadeRsp.default = {0, 0, 0, ''}

TSetLogicalDriveCachecadeRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetLogicalDriveCachecadeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetLogicalDriveCachecadeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLogicalDriveCachecadeRsp.proto_property, errs, need_convert)
    return self
end

function TSetLogicalDriveCachecadeRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

SetLogicalDriveCachecade.SetLogicalDriveCachecadeRsp = TSetLogicalDriveCachecadeRsp

return SetLogicalDriveCachecade
