--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetLogicalDriveBGI = {}

---@class StorageIpmiCmds.SetLogicalDriveBGIReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ControllerId integer
---@field VolumeId integer
---@field Frame integer
---@field WritingOffset integer
---@field WritingLength integer
---@field Data string
local TSetLogicalDriveBGIReq = {}
TSetLogicalDriveBGIReq.__index = TSetLogicalDriveBGIReq
TSetLogicalDriveBGIReq.group = {}

local function TSetLogicalDriveBGIReq_from_obj(obj)
    return setmetatable(obj, TSetLogicalDriveBGIReq)
end

function TSetLogicalDriveBGIReq.new(ManufacturerId, Reserve, ControllerId, VolumeId, Frame, WritingOffset,
    WritingLength, Data)
    return TSetLogicalDriveBGIReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ControllerId = ControllerId,
        VolumeId = VolumeId,
        Frame = Frame,
        WritingOffset = WritingOffset,
        WritingLength = WritingLength,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.SetLogicalDriveBGIReq
function TSetLogicalDriveBGIReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ControllerId = obj.ControllerId
    self.VolumeId = obj.VolumeId
    self.Frame = obj.Frame
    self.WritingOffset = obj.WritingOffset
    self.WritingLength = obj.WritingLength
    self.Data = obj.Data
end

function TSetLogicalDriveBGIReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLogicalDriveBGIReq.group)
end

TSetLogicalDriveBGIReq.from_obj = TSetLogicalDriveBGIReq_from_obj

TSetLogicalDriveBGIReq.proto_property = {
    'ManufacturerId', 'Reserve', 'ControllerId', 'VolumeId', 'Frame', 'WritingOffset', 'WritingLength', 'Data'
}

TSetLogicalDriveBGIReq.default = {0, 0, 0, 0, 0, 0, 0, ''}

TSetLogicalDriveBGIReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'VolumeId', is_array = false, struct = nil},
    {name = 'Frame', is_array = false, struct = nil}, {name = 'WritingOffset', is_array = false, struct = nil},
    {name = 'WritingLength', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetLogicalDriveBGIReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'VolumeId', self.VolumeId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Frame', self.Frame, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingOffset', self.WritingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingLength', self.WritingLength, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetLogicalDriveBGIReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLogicalDriveBGIReq.proto_property, errs, need_convert)
    return self
end

function TSetLogicalDriveBGIReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ControllerId, self.VolumeId, self.Frame, self.WritingOffset,
        self.WritingLength, self.Data
end

SetLogicalDriveBGI.SetLogicalDriveBGIReq = TSetLogicalDriveBGIReq

---@class StorageIpmiCmds.SetLogicalDriveBGIRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TSetLogicalDriveBGIRsp = {}
TSetLogicalDriveBGIRsp.__index = TSetLogicalDriveBGIRsp
TSetLogicalDriveBGIRsp.group = {}

local function TSetLogicalDriveBGIRsp_from_obj(obj)
    return setmetatable(obj, TSetLogicalDriveBGIRsp)
end

function TSetLogicalDriveBGIRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TSetLogicalDriveBGIRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.SetLogicalDriveBGIRsp
function TSetLogicalDriveBGIRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TSetLogicalDriveBGIRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLogicalDriveBGIRsp.group)
end

TSetLogicalDriveBGIRsp.from_obj = TSetLogicalDriveBGIRsp_from_obj

TSetLogicalDriveBGIRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TSetLogicalDriveBGIRsp.default = {0, 0, 0, ''}

TSetLogicalDriveBGIRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetLogicalDriveBGIRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetLogicalDriveBGIRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLogicalDriveBGIRsp.proto_property, errs, need_convert)
    return self
end

function TSetLogicalDriveBGIRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

SetLogicalDriveBGI.SetLogicalDriveBGIRsp = TSetLogicalDriveBGIRsp

return SetLogicalDriveBGI
