--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetLogicDriveWp = {}

---@class StorageIpmiCmds.SetLogicDriveWpReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ControllerId integer
---@field VolumeId integer
---@field Frame integer
---@field WritingOffset integer
---@field WritingLength integer
---@field Data string
local TSetLogicDriveWpReq = {}
TSetLogicDriveWpReq.__index = TSetLogicDriveWpReq
TSetLogicDriveWpReq.group = {}

local function TSetLogicDriveWpReq_from_obj(obj)
    return setmetatable(obj, TSetLogicDriveWpReq)
end

function TSetLogicDriveWpReq.new(ManufacturerId, Reserve, ControllerId, VolumeId, Frame, WritingOffset, WritingLength,
    Data)
    return TSetLogicDriveWpReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ControllerId = ControllerId,
        VolumeId = VolumeId,
        Frame = Frame,
        WritingOffset = WritingOffset,
        WritingLength = WritingLength,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.SetLogicDriveWpReq
function TSetLogicDriveWpReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ControllerId = obj.ControllerId
    self.VolumeId = obj.VolumeId
    self.Frame = obj.Frame
    self.WritingOffset = obj.WritingOffset
    self.WritingLength = obj.WritingLength
    self.Data = obj.Data
end

function TSetLogicDriveWpReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLogicDriveWpReq.group)
end

TSetLogicDriveWpReq.from_obj = TSetLogicDriveWpReq_from_obj

TSetLogicDriveWpReq.proto_property = {
    'ManufacturerId', 'Reserve', 'ControllerId', 'VolumeId', 'Frame', 'WritingOffset', 'WritingLength', 'Data'
}

TSetLogicDriveWpReq.default = {0, 0, 0, 0, 0, 0, 0, ''}

TSetLogicDriveWpReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'VolumeId', is_array = false, struct = nil},
    {name = 'Frame', is_array = false, struct = nil}, {name = 'WritingOffset', is_array = false, struct = nil},
    {name = 'WritingLength', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetLogicDriveWpReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'VolumeId', self.VolumeId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Frame', self.Frame, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingOffset', self.WritingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingLength', self.WritingLength, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetLogicDriveWpReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLogicDriveWpReq.proto_property, errs, need_convert)
    return self
end

function TSetLogicDriveWpReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ControllerId, self.VolumeId, self.Frame, self.WritingOffset,
        self.WritingLength, self.Data
end

SetLogicDriveWp.SetLogicDriveWpReq = TSetLogicDriveWpReq

---@class StorageIpmiCmds.SetLogicDriveWpRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TSetLogicDriveWpRsp = {}
TSetLogicDriveWpRsp.__index = TSetLogicDriveWpRsp
TSetLogicDriveWpRsp.group = {}

local function TSetLogicDriveWpRsp_from_obj(obj)
    return setmetatable(obj, TSetLogicDriveWpRsp)
end

function TSetLogicDriveWpRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TSetLogicDriveWpRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.SetLogicDriveWpRsp
function TSetLogicDriveWpRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TSetLogicDriveWpRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLogicDriveWpRsp.group)
end

TSetLogicDriveWpRsp.from_obj = TSetLogicDriveWpRsp_from_obj

TSetLogicDriveWpRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TSetLogicDriveWpRsp.default = {0, 0, 0, ''}

TSetLogicDriveWpRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetLogicDriveWpRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetLogicDriveWpRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLogicDriveWpRsp.proto_property, errs, need_convert)
    return self
end

function TSetLogicDriveWpRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

SetLogicDriveWp.SetLogicDriveWpRsp = TSetLogicDriveWpRsp

return SetLogicDriveWp
