--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetLogicDriveRp = {}

---@class StorageIpmiCmds.SetLogicDriveRpReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ControllerId integer
---@field VolumeId integer
---@field Frame integer
---@field WritingOffset integer
---@field WritingLength integer
---@field Data string
local TSetLogicDriveRpReq = {}
TSetLogicDriveRpReq.__index = TSetLogicDriveRpReq
TSetLogicDriveRpReq.group = {}

local function TSetLogicDriveRpReq_from_obj(obj)
    return setmetatable(obj, TSetLogicDriveRpReq)
end

function TSetLogicDriveRpReq.new(ManufacturerId, Reserve, ControllerId, VolumeId, Frame, WritingOffset, WritingLength,
    Data)
    return TSetLogicDriveRpReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ControllerId = ControllerId,
        VolumeId = VolumeId,
        Frame = Frame,
        WritingOffset = WritingOffset,
        WritingLength = WritingLength,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.SetLogicDriveRpReq
function TSetLogicDriveRpReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ControllerId = obj.ControllerId
    self.VolumeId = obj.VolumeId
    self.Frame = obj.Frame
    self.WritingOffset = obj.WritingOffset
    self.WritingLength = obj.WritingLength
    self.Data = obj.Data
end

function TSetLogicDriveRpReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLogicDriveRpReq.group)
end

TSetLogicDriveRpReq.from_obj = TSetLogicDriveRpReq_from_obj

TSetLogicDriveRpReq.proto_property = {
    'ManufacturerId', 'Reserve', 'ControllerId', 'VolumeId', 'Frame', 'WritingOffset', 'WritingLength', 'Data'
}

TSetLogicDriveRpReq.default = {0, 0, 0, 0, 0, 0, 0, ''}

TSetLogicDriveRpReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'VolumeId', is_array = false, struct = nil},
    {name = 'Frame', is_array = false, struct = nil}, {name = 'WritingOffset', is_array = false, struct = nil},
    {name = 'WritingLength', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetLogicDriveRpReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'VolumeId', self.VolumeId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Frame', self.Frame, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingOffset', self.WritingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingLength', self.WritingLength, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetLogicDriveRpReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLogicDriveRpReq.proto_property, errs, need_convert)
    return self
end

function TSetLogicDriveRpReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ControllerId, self.VolumeId, self.Frame, self.WritingOffset,
        self.WritingLength, self.Data
end

SetLogicDriveRp.SetLogicDriveRpReq = TSetLogicDriveRpReq

---@class StorageIpmiCmds.SetLogicDriveRpRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TSetLogicDriveRpRsp = {}
TSetLogicDriveRpRsp.__index = TSetLogicDriveRpRsp
TSetLogicDriveRpRsp.group = {}

local function TSetLogicDriveRpRsp_from_obj(obj)
    return setmetatable(obj, TSetLogicDriveRpRsp)
end

function TSetLogicDriveRpRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TSetLogicDriveRpRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.SetLogicDriveRpRsp
function TSetLogicDriveRpRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TSetLogicDriveRpRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLogicDriveRpRsp.group)
end

TSetLogicDriveRpRsp.from_obj = TSetLogicDriveRpRsp_from_obj

TSetLogicDriveRpRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TSetLogicDriveRpRsp.default = {0, 0, 0, ''}

TSetLogicDriveRpRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetLogicDriveRpRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetLogicDriveRpRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLogicDriveRpRsp.proto_property, errs, need_convert)
    return self
end

function TSetLogicDriveRpRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

SetLogicDriveRp.SetLogicDriveRpRsp = TSetLogicDriveRpRsp

return SetLogicDriveRp
