--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetFaultIndicatorState = {}

---@class StorageIpmiCmds.SetFaultIndicatorStateReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ControllerId integer
---@field DriveId integer
---@field Frame integer
---@field WritingOffset integer
---@field WritingLength integer
---@field Data integer[]
local TSetFaultIndicatorStateReq = {}
TSetFaultIndicatorStateReq.__index = TSetFaultIndicatorStateReq
TSetFaultIndicatorStateReq.group = {}

local function TSetFaultIndicatorStateReq_from_obj(obj)
    return setmetatable(obj, TSetFaultIndicatorStateReq)
end

function TSetFaultIndicatorStateReq.new(ManufacturerId, Reserve, ControllerId, DriveId, Frame, WritingOffset,
    WritingLength, Data)
    return TSetFaultIndicatorStateReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ControllerId = ControllerId,
        DriveId = DriveId,
        Frame = Frame,
        WritingOffset = WritingOffset,
        WritingLength = WritingLength,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.SetFaultIndicatorStateReq
function TSetFaultIndicatorStateReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ControllerId = obj.ControllerId
    self.DriveId = obj.DriveId
    self.Frame = obj.Frame
    self.WritingOffset = obj.WritingOffset
    self.WritingLength = obj.WritingLength
    self.Data = obj.Data
end

function TSetFaultIndicatorStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFaultIndicatorStateReq.group)
end

TSetFaultIndicatorStateReq.from_obj = TSetFaultIndicatorStateReq_from_obj

TSetFaultIndicatorStateReq.proto_property = {
    'ManufacturerId', 'Reserve', 'ControllerId', 'DriveId', 'Frame', 'WritingOffset', 'WritingLength', 'Data'
}

TSetFaultIndicatorStateReq.default = {0, 0, 0, 0, 0, 0, 0, {}}

TSetFaultIndicatorStateReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'DriveId', is_array = false, struct = nil},
    {name = 'Frame', is_array = false, struct = nil}, {name = 'WritingOffset', is_array = false, struct = nil},
    {name = 'WritingLength', is_array = false, struct = nil}, {name = 'Data', is_array = true, struct = nil}
}

function TSetFaultIndicatorStateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DriveId', self.DriveId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Frame', self.Frame, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingOffset', self.WritingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingLength', self.WritingLength, 'uint8', false, errs, need_convert)
    validate.OptionalArray(prefix .. 'Data', self.Data, 'uint8', false, errs, need_convert)

    if self.Data ~= nil then
        validate.lens(prefix .. 'Data', self.Data, 1, 1, errs, need_convert)
    end

    TSetFaultIndicatorStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFaultIndicatorStateReq.proto_property, errs, need_convert)
    return self
end

function TSetFaultIndicatorStateReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ControllerId, self.DriveId, self.Frame, self.WritingOffset,
        self.WritingLength, self.Data
end

SetFaultIndicatorState.SetFaultIndicatorStateReq = TSetFaultIndicatorStateReq

---@class StorageIpmiCmds.SetFaultIndicatorStateRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
local TSetFaultIndicatorStateRsp = {}
TSetFaultIndicatorStateRsp.__index = TSetFaultIndicatorStateRsp
TSetFaultIndicatorStateRsp.group = {}

local function TSetFaultIndicatorStateRsp_from_obj(obj)
    return setmetatable(obj, TSetFaultIndicatorStateRsp)
end

function TSetFaultIndicatorStateRsp.new(CompletionCode, ManufactureId, Reserve)
    return TSetFaultIndicatorStateRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve
    })
end
---@param obj StorageIpmiCmds.SetFaultIndicatorStateRsp
function TSetFaultIndicatorStateRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
end

function TSetFaultIndicatorStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFaultIndicatorStateRsp.group)
end

TSetFaultIndicatorStateRsp.from_obj = TSetFaultIndicatorStateRsp_from_obj

TSetFaultIndicatorStateRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve'}

TSetFaultIndicatorStateRsp.default = {0, 0, 0}

TSetFaultIndicatorStateRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}
}

function TSetFaultIndicatorStateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint32', false, errs, need_convert)

    TSetFaultIndicatorStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFaultIndicatorStateRsp.proto_property, errs, need_convert)
    return self
end

function TSetFaultIndicatorStateRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve
end

SetFaultIndicatorState.SetFaultIndicatorStateRsp = TSetFaultIndicatorStateRsp

return SetFaultIndicatorState
