--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetControllerSmarterCopyback = {}

---@class StorageIpmiCmds.SetControllerSmarterCopybackReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ControllerId integer
---@field Frame integer
---@field WritingOffset integer
---@field WritingLength integer
---@field Data string
local TSetControllerSmarterCopybackReq = {}
TSetControllerSmarterCopybackReq.__index = TSetControllerSmarterCopybackReq
TSetControllerSmarterCopybackReq.group = {}

local function TSetControllerSmarterCopybackReq_from_obj(obj)
    return setmetatable(obj, TSetControllerSmarterCopybackReq)
end

function TSetControllerSmarterCopybackReq.new(ManufacturerId, Reserve, ControllerId, Frame, WritingOffset,
    WritingLength, Data)
    return TSetControllerSmarterCopybackReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ControllerId = ControllerId,
        Frame = Frame,
        WritingOffset = WritingOffset,
        WritingLength = WritingLength,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.SetControllerSmarterCopybackReq
function TSetControllerSmarterCopybackReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ControllerId = obj.ControllerId
    self.Frame = obj.Frame
    self.WritingOffset = obj.WritingOffset
    self.WritingLength = obj.WritingLength
    self.Data = obj.Data
end

function TSetControllerSmarterCopybackReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetControllerSmarterCopybackReq.group)
end

TSetControllerSmarterCopybackReq.from_obj = TSetControllerSmarterCopybackReq_from_obj

TSetControllerSmarterCopybackReq.proto_property = {
    'ManufacturerId', 'Reserve', 'ControllerId', 'Frame', 'WritingOffset', 'WritingLength', 'Data'
}

TSetControllerSmarterCopybackReq.default = {0, 0, 0, 0, 0, 0, ''}

TSetControllerSmarterCopybackReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'Frame', is_array = false, struct = nil},
    {name = 'WritingOffset', is_array = false, struct = nil}, {name = 'WritingLength', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TSetControllerSmarterCopybackReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Frame', self.Frame, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingOffset', self.WritingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingLength', self.WritingLength, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetControllerSmarterCopybackReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetControllerSmarterCopybackReq.proto_property, errs, need_convert)
    return self
end

function TSetControllerSmarterCopybackReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ControllerId, self.Frame, self.WritingOffset, self.WritingLength,
        self.Data
end

SetControllerSmarterCopyback.SetControllerSmarterCopybackReq = TSetControllerSmarterCopybackReq

---@class StorageIpmiCmds.SetControllerSmarterCopybackRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TSetControllerSmarterCopybackRsp = {}
TSetControllerSmarterCopybackRsp.__index = TSetControllerSmarterCopybackRsp
TSetControllerSmarterCopybackRsp.group = {}

local function TSetControllerSmarterCopybackRsp_from_obj(obj)
    return setmetatable(obj, TSetControllerSmarterCopybackRsp)
end

function TSetControllerSmarterCopybackRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TSetControllerSmarterCopybackRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.SetControllerSmarterCopybackRsp
function TSetControllerSmarterCopybackRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TSetControllerSmarterCopybackRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetControllerSmarterCopybackRsp.group)
end

TSetControllerSmarterCopybackRsp.from_obj = TSetControllerSmarterCopybackRsp_from_obj

TSetControllerSmarterCopybackRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TSetControllerSmarterCopybackRsp.default = {0, 0, 0, ''}

TSetControllerSmarterCopybackRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetControllerSmarterCopybackRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetControllerSmarterCopybackRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetControllerSmarterCopybackRsp.proto_property, errs, need_convert)
    return self
end

function TSetControllerSmarterCopybackRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

SetControllerSmarterCopyback.SetControllerSmarterCopybackRsp = TSetControllerSmarterCopybackRsp

return SetControllerSmarterCopyback
