--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetControllerCopyback = {}

---@class StorageIpmiCmds.SetControllerCopybackReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ControllerId integer
---@field Frame integer
---@field WritingOffset integer
---@field WritingLength integer
---@field Data string
local TSetControllerCopybackReq = {}
TSetControllerCopybackReq.__index = TSetControllerCopybackReq
TSetControllerCopybackReq.group = {}

local function TSetControllerCopybackReq_from_obj(obj)
    return setmetatable(obj, TSetControllerCopybackReq)
end

function TSetControllerCopybackReq.new(ManufacturerId, Reserve, ControllerId, Frame, WritingOffset, WritingLength, Data)
    return TSetControllerCopybackReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ControllerId = ControllerId,
        Frame = Frame,
        WritingOffset = WritingOffset,
        WritingLength = WritingLength,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.SetControllerCopybackReq
function TSetControllerCopybackReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ControllerId = obj.ControllerId
    self.Frame = obj.Frame
    self.WritingOffset = obj.WritingOffset
    self.WritingLength = obj.WritingLength
    self.Data = obj.Data
end

function TSetControllerCopybackReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetControllerCopybackReq.group)
end

TSetControllerCopybackReq.from_obj = TSetControllerCopybackReq_from_obj

TSetControllerCopybackReq.proto_property = {
    'ManufacturerId', 'Reserve', 'ControllerId', 'Frame', 'WritingOffset', 'WritingLength', 'Data'
}

TSetControllerCopybackReq.default = {0, 0, 0, 0, 0, 0, ''}

TSetControllerCopybackReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'Frame', is_array = false, struct = nil},
    {name = 'WritingOffset', is_array = false, struct = nil}, {name = 'WritingLength', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TSetControllerCopybackReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Frame', self.Frame, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingOffset', self.WritingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'WritingLength', self.WritingLength, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetControllerCopybackReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetControllerCopybackReq.proto_property, errs, need_convert)
    return self
end

function TSetControllerCopybackReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ControllerId, self.Frame, self.WritingOffset, self.WritingLength,
        self.Data
end

SetControllerCopyback.SetControllerCopybackReq = TSetControllerCopybackReq

---@class StorageIpmiCmds.SetControllerCopybackRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TSetControllerCopybackRsp = {}
TSetControllerCopybackRsp.__index = TSetControllerCopybackRsp
TSetControllerCopybackRsp.group = {}

local function TSetControllerCopybackRsp_from_obj(obj)
    return setmetatable(obj, TSetControllerCopybackRsp)
end

function TSetControllerCopybackRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TSetControllerCopybackRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.SetControllerCopybackRsp
function TSetControllerCopybackRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TSetControllerCopybackRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetControllerCopybackRsp.group)
end

TSetControllerCopybackRsp.from_obj = TSetControllerCopybackRsp_from_obj

TSetControllerCopybackRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TSetControllerCopybackRsp.default = {0, 0, 0, ''}

TSetControllerCopybackRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetControllerCopybackRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetControllerCopybackRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetControllerCopybackRsp.proto_property, errs, need_convert)
    return self
end

function TSetControllerCopybackRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

SetControllerCopyback.SetControllerCopybackRsp = TSetControllerCopybackRsp

return SetControllerCopyback
