--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetPhysicalDriveInfo = {}

---@class StorageIpmiCmds.GetPhysicalDriveInfoReq
---@field ManufacturerId integer
---@field Reserve integer
---@field PhysicalDriveID integer
---@field ReadingOffset integer
---@field ReadingLength integer
local TGetPhysicalDriveInfoReq = {}
TGetPhysicalDriveInfoReq.__index = TGetPhysicalDriveInfoReq
TGetPhysicalDriveInfoReq.group = {}

local function TGetPhysicalDriveInfoReq_from_obj(obj)
    return setmetatable(obj, TGetPhysicalDriveInfoReq)
end

function TGetPhysicalDriveInfoReq.new(ManufacturerId, Reserve, PhysicalDriveID, ReadingOffset, ReadingLength)
    return TGetPhysicalDriveInfoReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        PhysicalDriveID = PhysicalDriveID,
        ReadingOffset = ReadingOffset,
        ReadingLength = ReadingLength
    })
end
---@param obj StorageIpmiCmds.GetPhysicalDriveInfoReq
function TGetPhysicalDriveInfoReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.PhysicalDriveID = obj.PhysicalDriveID
    self.ReadingOffset = obj.ReadingOffset
    self.ReadingLength = obj.ReadingLength
end

function TGetPhysicalDriveInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPhysicalDriveInfoReq.group)
end

TGetPhysicalDriveInfoReq.from_obj = TGetPhysicalDriveInfoReq_from_obj

TGetPhysicalDriveInfoReq.proto_property = {
    'ManufacturerId', 'Reserve', 'PhysicalDriveID', 'ReadingOffset', 'ReadingLength'
}

TGetPhysicalDriveInfoReq.default = {0, 0, 0, 0, 0}

TGetPhysicalDriveInfoReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'PhysicalDriveID', is_array = false, struct = nil},
    {name = 'ReadingOffset', is_array = false, struct = nil}, {name = 'ReadingLength', is_array = false, struct = nil}
}

function TGetPhysicalDriveInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PhysicalDriveID', self.PhysicalDriveID, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingOffset', self.ReadingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingLength', self.ReadingLength, 'uint8', false, errs, need_convert)

    TGetPhysicalDriveInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPhysicalDriveInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetPhysicalDriveInfoReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.PhysicalDriveID, self.ReadingOffset, self.ReadingLength
end

GetPhysicalDriveInfo.GetPhysicalDriveInfoReq = TGetPhysicalDriveInfoReq

---@class StorageIpmiCmds.GetPhysicalDriveInfoRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TGetPhysicalDriveInfoRsp = {}
TGetPhysicalDriveInfoRsp.__index = TGetPhysicalDriveInfoRsp
TGetPhysicalDriveInfoRsp.group = {}

local function TGetPhysicalDriveInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetPhysicalDriveInfoRsp)
end

function TGetPhysicalDriveInfoRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TGetPhysicalDriveInfoRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.GetPhysicalDriveInfoRsp
function TGetPhysicalDriveInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TGetPhysicalDriveInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPhysicalDriveInfoRsp.group)
end

TGetPhysicalDriveInfoRsp.from_obj = TGetPhysicalDriveInfoRsp_from_obj

TGetPhysicalDriveInfoRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TGetPhysicalDriveInfoRsp.default = {0, 0, 0, ''}

TGetPhysicalDriveInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetPhysicalDriveInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetPhysicalDriveInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPhysicalDriveInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetPhysicalDriveInfoRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

GetPhysicalDriveInfo.GetPhysicalDriveInfoRsp = TGetPhysicalDriveInfoRsp

return GetPhysicalDriveInfo
