--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetLogicalDriveList = {}

---@class StorageIpmiCmds.GetLogicalDriveListReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ControllerId integer
---@field ReadingOffset integer
---@field ReadingLength integer
local TGetLogicalDriveListReq = {}
TGetLogicalDriveListReq.__index = TGetLogicalDriveListReq
TGetLogicalDriveListReq.group = {}

local function TGetLogicalDriveListReq_from_obj(obj)
    return setmetatable(obj, TGetLogicalDriveListReq)
end

function TGetLogicalDriveListReq.new(ManufacturerId, Reserve, ControllerId, ReadingOffset, ReadingLength)
    return TGetLogicalDriveListReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ControllerId = ControllerId,
        ReadingOffset = ReadingOffset,
        ReadingLength = ReadingLength
    })
end
---@param obj StorageIpmiCmds.GetLogicalDriveListReq
function TGetLogicalDriveListReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ControllerId = obj.ControllerId
    self.ReadingOffset = obj.ReadingOffset
    self.ReadingLength = obj.ReadingLength
end

function TGetLogicalDriveListReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetLogicalDriveListReq.group)
end

TGetLogicalDriveListReq.from_obj = TGetLogicalDriveListReq_from_obj

TGetLogicalDriveListReq.proto_property = {'ManufacturerId', 'Reserve', 'ControllerId', 'ReadingOffset', 'ReadingLength'}

TGetLogicalDriveListReq.default = {0, 0, 0, 0, 0}

TGetLogicalDriveListReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'ReadingOffset', is_array = false, struct = nil},
    {name = 'ReadingLength', is_array = false, struct = nil}
}

function TGetLogicalDriveListReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingOffset', self.ReadingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingLength', self.ReadingLength, 'uint8', false, errs, need_convert)

    TGetLogicalDriveListReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetLogicalDriveListReq.proto_property, errs, need_convert)
    return self
end

function TGetLogicalDriveListReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ControllerId, self.ReadingOffset, self.ReadingLength
end

GetLogicalDriveList.GetLogicalDriveListReq = TGetLogicalDriveListReq

---@class StorageIpmiCmds.GetLogicalDriveListRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TGetLogicalDriveListRsp = {}
TGetLogicalDriveListRsp.__index = TGetLogicalDriveListRsp
TGetLogicalDriveListRsp.group = {}

local function TGetLogicalDriveListRsp_from_obj(obj)
    return setmetatable(obj, TGetLogicalDriveListRsp)
end

function TGetLogicalDriveListRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TGetLogicalDriveListRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.GetLogicalDriveListRsp
function TGetLogicalDriveListRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TGetLogicalDriveListRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetLogicalDriveListRsp.group)
end

TGetLogicalDriveListRsp.from_obj = TGetLogicalDriveListRsp_from_obj

TGetLogicalDriveListRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TGetLogicalDriveListRsp.default = {0, 0, 0, ''}

TGetLogicalDriveListRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetLogicalDriveListRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetLogicalDriveListRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetLogicalDriveListRsp.proto_property, errs, need_convert)
    return self
end

function TGetLogicalDriveListRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

GetLogicalDriveList.GetLogicalDriveListRsp = TGetLogicalDriveListRsp

return GetLogicalDriveList
