--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDiskSilk = {}

---@class StorageIpmiCmds.GetDiskSilkReq
---@field ManufacturerId integer
---@field Type integer
---@field Length integer
---@field Data string
local TGetDiskSilkReq = {}
TGetDiskSilkReq.__index = TGetDiskSilkReq
TGetDiskSilkReq.group = {}

local function TGetDiskSilkReq_from_obj(obj)
    return setmetatable(obj, TGetDiskSilkReq)
end

function TGetDiskSilkReq.new(ManufacturerId, Type, Length, Data)
    return TGetDiskSilkReq_from_obj({ManufacturerId = ManufacturerId, Type = Type, Length = Length, Data = Data})
end
---@param obj StorageIpmiCmds.GetDiskSilkReq
function TGetDiskSilkReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Type = obj.Type
    self.Length = obj.Length
    self.Data = obj.Data
end

function TGetDiskSilkReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDiskSilkReq.group)
end

TGetDiskSilkReq.from_obj = TGetDiskSilkReq_from_obj

TGetDiskSilkReq.proto_property = {'ManufacturerId', 'Type', 'Length', 'Data'}

TGetDiskSilkReq.default = {0, 0, 0, ''}

TGetDiskSilkReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Type', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetDiskSilkReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Type', self.Type, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetDiskSilkReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDiskSilkReq.proto_property, errs, need_convert)
    return self
end

function TGetDiskSilkReq:unpack(_)
    return self.ManufacturerId, self.Type, self.Length, self.Data
end

GetDiskSilk.GetDiskSilkReq = TGetDiskSilkReq

---@class StorageIpmiCmds.GetDiskSilkRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Data string
local TGetDiskSilkRsp = {}
TGetDiskSilkRsp.__index = TGetDiskSilkRsp
TGetDiskSilkRsp.group = {}

local function TGetDiskSilkRsp_from_obj(obj)
    return setmetatable(obj, TGetDiskSilkRsp)
end

function TGetDiskSilkRsp.new(CompletionCode, ManufactureId, Data)
    return TGetDiskSilkRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId, Data = Data})
end
---@param obj StorageIpmiCmds.GetDiskSilkRsp
function TGetDiskSilkRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Data = obj.Data
end

function TGetDiskSilkRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDiskSilkRsp.group)
end

TGetDiskSilkRsp.from_obj = TGetDiskSilkRsp_from_obj

TGetDiskSilkRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Data'}

TGetDiskSilkRsp.default = {0, 0, ''}

TGetDiskSilkRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetDiskSilkRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetDiskSilkRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDiskSilkRsp.proto_property, errs, need_convert)
    return self
end

function TGetDiskSilkRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Data
end

GetDiskSilk.GetDiskSilkRsp = TGetDiskSilkRsp

return GetDiskSilk
