--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetControllerCapability = {}

---@class StorageIpmiCmds.GetControllerCapabilityReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ControllerId integer
---@field ReadingOffset integer
---@field ReadingLength integer
local TGetControllerCapabilityReq = {}
TGetControllerCapabilityReq.__index = TGetControllerCapabilityReq
TGetControllerCapabilityReq.group = {}

local function TGetControllerCapabilityReq_from_obj(obj)
    return setmetatable(obj, TGetControllerCapabilityReq)
end

function TGetControllerCapabilityReq.new(ManufacturerId, Reserve, ControllerId, ReadingOffset, ReadingLength)
    return TGetControllerCapabilityReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ControllerId = ControllerId,
        ReadingOffset = ReadingOffset,
        ReadingLength = ReadingLength
    })
end
---@param obj StorageIpmiCmds.GetControllerCapabilityReq
function TGetControllerCapabilityReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ControllerId = obj.ControllerId
    self.ReadingOffset = obj.ReadingOffset
    self.ReadingLength = obj.ReadingLength
end

function TGetControllerCapabilityReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetControllerCapabilityReq.group)
end

TGetControllerCapabilityReq.from_obj = TGetControllerCapabilityReq_from_obj

TGetControllerCapabilityReq.proto_property = {
    'ManufacturerId', 'Reserve', 'ControllerId', 'ReadingOffset', 'ReadingLength'
}

TGetControllerCapabilityReq.default = {0, 0, 0, 0, 0}

TGetControllerCapabilityReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'ReadingOffset', is_array = false, struct = nil},
    {name = 'ReadingLength', is_array = false, struct = nil}
}

function TGetControllerCapabilityReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingOffset', self.ReadingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingLength', self.ReadingLength, 'uint8', false, errs, need_convert)

    TGetControllerCapabilityReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetControllerCapabilityReq.proto_property, errs, need_convert)
    return self
end

function TGetControllerCapabilityReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ControllerId, self.ReadingOffset, self.ReadingLength
end

GetControllerCapability.GetControllerCapabilityReq = TGetControllerCapabilityReq

---@class StorageIpmiCmds.GetControllerCapabilityRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TGetControllerCapabilityRsp = {}
TGetControllerCapabilityRsp.__index = TGetControllerCapabilityRsp
TGetControllerCapabilityRsp.group = {}

local function TGetControllerCapabilityRsp_from_obj(obj)
    return setmetatable(obj, TGetControllerCapabilityRsp)
end

function TGetControllerCapabilityRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TGetControllerCapabilityRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.GetControllerCapabilityRsp
function TGetControllerCapabilityRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TGetControllerCapabilityRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetControllerCapabilityRsp.group)
end

TGetControllerCapabilityRsp.from_obj = TGetControllerCapabilityRsp_from_obj

TGetControllerCapabilityRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TGetControllerCapabilityRsp.default = {0, 0, 0, ''}

TGetControllerCapabilityRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetControllerCapabilityRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetControllerCapabilityRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetControllerCapabilityRsp.proto_property, errs, need_convert)
    return self
end

function TGetControllerCapabilityRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

GetControllerCapability.GetControllerCapabilityRsp = TGetControllerCapabilityRsp

return GetControllerCapability
