--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetCachecadeAssociatedLdsEx = {}

---@class StorageIpmiCmds.GetCachecadeAssociatedLdsExReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ControllerId integer
---@field CachecadeID integer
---@field ReadingOffset integer
---@field ReadingLength integer
local TGetCachecadeAssociatedLdsExReq = {}
TGetCachecadeAssociatedLdsExReq.__index = TGetCachecadeAssociatedLdsExReq
TGetCachecadeAssociatedLdsExReq.group = {}

local function TGetCachecadeAssociatedLdsExReq_from_obj(obj)
    return setmetatable(obj, TGetCachecadeAssociatedLdsExReq)
end

function TGetCachecadeAssociatedLdsExReq.new(ManufacturerId, Reserve, ControllerId, CachecadeID, ReadingOffset,
    ReadingLength)
    return TGetCachecadeAssociatedLdsExReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ControllerId = ControllerId,
        CachecadeID = CachecadeID,
        ReadingOffset = ReadingOffset,
        ReadingLength = ReadingLength
    })
end
---@param obj StorageIpmiCmds.GetCachecadeAssociatedLdsExReq
function TGetCachecadeAssociatedLdsExReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ControllerId = obj.ControllerId
    self.CachecadeID = obj.CachecadeID
    self.ReadingOffset = obj.ReadingOffset
    self.ReadingLength = obj.ReadingLength
end

function TGetCachecadeAssociatedLdsExReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCachecadeAssociatedLdsExReq.group)
end

TGetCachecadeAssociatedLdsExReq.from_obj = TGetCachecadeAssociatedLdsExReq_from_obj

TGetCachecadeAssociatedLdsExReq.proto_property = {
    'ManufacturerId', 'Reserve', 'ControllerId', 'CachecadeID', 'ReadingOffset', 'ReadingLength'
}

TGetCachecadeAssociatedLdsExReq.default = {0, 0, 0, 0, 0, 0}

TGetCachecadeAssociatedLdsExReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'CachecadeID', is_array = false, struct = nil},
    {name = 'ReadingOffset', is_array = false, struct = nil}, {name = 'ReadingLength', is_array = false, struct = nil}
}

function TGetCachecadeAssociatedLdsExReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'CachecadeID', self.CachecadeID, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingOffset', self.ReadingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingLength', self.ReadingLength, 'uint8', false, errs, need_convert)

    TGetCachecadeAssociatedLdsExReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCachecadeAssociatedLdsExReq.proto_property, errs, need_convert)
    return self
end

function TGetCachecadeAssociatedLdsExReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ControllerId, self.CachecadeID, self.ReadingOffset,
        self.ReadingLength
end

GetCachecadeAssociatedLdsEx.GetCachecadeAssociatedLdsExReq = TGetCachecadeAssociatedLdsExReq

---@class StorageIpmiCmds.GetCachecadeAssociatedLdsExRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TGetCachecadeAssociatedLdsExRsp = {}
TGetCachecadeAssociatedLdsExRsp.__index = TGetCachecadeAssociatedLdsExRsp
TGetCachecadeAssociatedLdsExRsp.group = {}

local function TGetCachecadeAssociatedLdsExRsp_from_obj(obj)
    return setmetatable(obj, TGetCachecadeAssociatedLdsExRsp)
end

function TGetCachecadeAssociatedLdsExRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TGetCachecadeAssociatedLdsExRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.GetCachecadeAssociatedLdsExRsp
function TGetCachecadeAssociatedLdsExRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TGetCachecadeAssociatedLdsExRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCachecadeAssociatedLdsExRsp.group)
end

TGetCachecadeAssociatedLdsExRsp.from_obj = TGetCachecadeAssociatedLdsExRsp_from_obj

TGetCachecadeAssociatedLdsExRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TGetCachecadeAssociatedLdsExRsp.default = {0, 0, 0, ''}

TGetCachecadeAssociatedLdsExRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetCachecadeAssociatedLdsExRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetCachecadeAssociatedLdsExRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCachecadeAssociatedLdsExRsp.proto_property, errs, need_convert)
    return self
end

function TGetCachecadeAssociatedLdsExRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

GetCachecadeAssociatedLdsEx.GetCachecadeAssociatedLdsExRsp = TGetCachecadeAssociatedLdsExRsp

return GetCachecadeAssociatedLdsEx
