--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetArrayList = {}

---@class StorageIpmiCmds.GetArrayListReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ControllerId integer
---@field ReadingOffset integer
---@field ReadingLength integer
local TGetArrayListReq = {}
TGetArrayListReq.__index = TGetArrayListReq
TGetArrayListReq.group = {}

local function TGetArrayListReq_from_obj(obj)
    return setmetatable(obj, TGetArrayListReq)
end

function TGetArrayListReq.new(ManufacturerId, Reserve, ControllerId, ReadingOffset, ReadingLength)
    return TGetArrayListReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ControllerId = ControllerId,
        ReadingOffset = ReadingOffset,
        ReadingLength = ReadingLength
    })
end
---@param obj StorageIpmiCmds.GetArrayListReq
function TGetArrayListReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ControllerId = obj.ControllerId
    self.ReadingOffset = obj.ReadingOffset
    self.ReadingLength = obj.ReadingLength
end

function TGetArrayListReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetArrayListReq.group)
end

TGetArrayListReq.from_obj = TGetArrayListReq_from_obj

TGetArrayListReq.proto_property = {'ManufacturerId', 'Reserve', 'ControllerId', 'ReadingOffset', 'ReadingLength'}

TGetArrayListReq.default = {0, 0, 0, 0, 0}

TGetArrayListReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'ReadingOffset', is_array = false, struct = nil},
    {name = 'ReadingLength', is_array = false, struct = nil}
}

function TGetArrayListReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingOffset', self.ReadingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingLength', self.ReadingLength, 'uint8', false, errs, need_convert)

    TGetArrayListReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetArrayListReq.proto_property, errs, need_convert)
    return self
end

function TGetArrayListReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ControllerId, self.ReadingOffset, self.ReadingLength
end

GetArrayList.GetArrayListReq = TGetArrayListReq

---@class StorageIpmiCmds.GetArrayListRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TGetArrayListRsp = {}
TGetArrayListRsp.__index = TGetArrayListRsp
TGetArrayListRsp.group = {}

local function TGetArrayListRsp_from_obj(obj)
    return setmetatable(obj, TGetArrayListRsp)
end

function TGetArrayListRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TGetArrayListRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.GetArrayListRsp
function TGetArrayListRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TGetArrayListRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetArrayListRsp.group)
end

TGetArrayListRsp.from_obj = TGetArrayListRsp_from_obj

TGetArrayListRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TGetArrayListRsp.default = {0, 0, 0, ''}

TGetArrayListRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetArrayListRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetArrayListRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetArrayListRsp.proto_property, errs, need_convert)
    return self
end

function TGetArrayListRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

GetArrayList.GetArrayListRsp = TGetArrayListRsp

return GetArrayList
