--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetArrayLdsEx = {}

---@class StorageIpmiCmds.GetArrayLdsExReq
---@field ManufacturerId integer
---@field Reserve integer
---@field ControllerId integer
---@field ArrayIDLow integer
---@field ArrayIDHigh integer
---@field ReadingOffset integer
---@field ReadingLength integer
local TGetArrayLdsExReq = {}
TGetArrayLdsExReq.__index = TGetArrayLdsExReq
TGetArrayLdsExReq.group = {}

local function TGetArrayLdsExReq_from_obj(obj)
    return setmetatable(obj, TGetArrayLdsExReq)
end

function TGetArrayLdsExReq.new(ManufacturerId, Reserve, ControllerId, ArrayIDLow, ArrayIDHigh, ReadingOffset,
    ReadingLength)
    return TGetArrayLdsExReq_from_obj({
        ManufacturerId = ManufacturerId,
        Reserve = Reserve,
        ControllerId = ControllerId,
        ArrayIDLow = ArrayIDLow,
        ArrayIDHigh = ArrayIDHigh,
        ReadingOffset = ReadingOffset,
        ReadingLength = ReadingLength
    })
end
---@param obj StorageIpmiCmds.GetArrayLdsExReq
function TGetArrayLdsExReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Reserve = obj.Reserve
    self.ControllerId = obj.ControllerId
    self.ArrayIDLow = obj.ArrayIDLow
    self.ArrayIDHigh = obj.ArrayIDHigh
    self.ReadingOffset = obj.ReadingOffset
    self.ReadingLength = obj.ReadingLength
end

function TGetArrayLdsExReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetArrayLdsExReq.group)
end

TGetArrayLdsExReq.from_obj = TGetArrayLdsExReq_from_obj

TGetArrayLdsExReq.proto_property = {
    'ManufacturerId', 'Reserve', 'ControllerId', 'ArrayIDLow', 'ArrayIDHigh', 'ReadingOffset', 'ReadingLength'
}

TGetArrayLdsExReq.default = {0, 0, 0, 0, 0, 0, 0}

TGetArrayLdsExReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Reserve', is_array = false, struct = nil},
    {name = 'ControllerId', is_array = false, struct = nil}, {name = 'ArrayIDLow', is_array = false, struct = nil},
    {name = 'ArrayIDHigh', is_array = false, struct = nil}, {name = 'ReadingOffset', is_array = false, struct = nil},
    {name = 'ReadingLength', is_array = false, struct = nil}
}

function TGetArrayLdsExReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ControllerId', self.ControllerId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ArrayIDLow', self.ArrayIDLow, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ArrayIDHigh', self.ArrayIDHigh, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingOffset', self.ReadingOffset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'ReadingLength', self.ReadingLength, 'uint8', false, errs, need_convert)

    TGetArrayLdsExReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetArrayLdsExReq.proto_property, errs, need_convert)
    return self
end

function TGetArrayLdsExReq:unpack(_)
    return self.ManufacturerId, self.Reserve, self.ControllerId, self.ArrayIDLow, self.ArrayIDHigh, self.ReadingOffset,
        self.ReadingLength
end

GetArrayLdsEx.GetArrayLdsExReq = TGetArrayLdsExReq

---@class StorageIpmiCmds.GetArrayLdsExRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Reserve integer
---@field Data string
local TGetArrayLdsExRsp = {}
TGetArrayLdsExRsp.__index = TGetArrayLdsExRsp
TGetArrayLdsExRsp.group = {}

local function TGetArrayLdsExRsp_from_obj(obj)
    return setmetatable(obj, TGetArrayLdsExRsp)
end

function TGetArrayLdsExRsp.new(CompletionCode, ManufactureId, Reserve, Data)
    return TGetArrayLdsExRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Reserve = Reserve,
        Data = Data
    })
end
---@param obj StorageIpmiCmds.GetArrayLdsExRsp
function TGetArrayLdsExRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Reserve = obj.Reserve
    self.Data = obj.Data
end

function TGetArrayLdsExRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetArrayLdsExRsp.group)
end

TGetArrayLdsExRsp.from_obj = TGetArrayLdsExRsp_from_obj

TGetArrayLdsExRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Reserve', 'Data'}

TGetArrayLdsExRsp.default = {0, 0, 0, ''}

TGetArrayLdsExRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Reserve', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TGetArrayLdsExRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserve', self.Reserve, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetArrayLdsExRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetArrayLdsExRsp.proto_property, errs, need_convert)
    return self
end

function TGetArrayLdsExRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Reserve, self.Data
end

GetArrayLdsEx.GetArrayLdsExRsp = TGetArrayLdsExRsp

return GetArrayLdsEx
