-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local Databases = require 'database'
local Col = require 'database.column'

local Properties = require 'storage.json_types.Properties'

---@class StorageConfigTable: Table
---@field StorageConfigReady FieldBase
---@field VolumesStateAbnormal FieldBase
---@field DiskPartitionUsagePercentageThreshold FieldBase
---@field PhyErrorEnabled FieldBase
---@field PhyErrorInterval FieldBase
---@field PhyErrorMaxRecord FieldBase
---@field PhyErrorThreshold FieldBase
---@field MaxPhyErrorLogFileRotationCount FieldBase
---@field PhyErrorSelUnlimitFlag FieldBase
---@field FileMockEnabled FieldBase
---@field ClassName FieldBase
---@field ObjectName FieldBase
---@field ObjectIdentifier FieldBase

---@class ControllerTable: Table
---@field Id FieldBase
---@field Type FieldBase
---@field TypeId FieldBase
---@field DeviceName FieldBase
---@field Position FieldBase
---@field TemperatureCelsius FieldBase
---@field TemperatureAbnormal FieldBase
---@field ControllerName FieldBase
---@field OOBSupport FieldBase
---@field FirmwareVersion FieldBase
---@field SupportedMode FieldBase
---@field MemorySizeMiB FieldBase
---@field DeviceInterface FieldBase
---@field SASAddr FieldBase
---@field SerialNumber FieldBase
---@field MaxStripSizeBytes FieldBase
---@field MinStripSizeBytes FieldBase
---@field NVDataVersion FieldBase
---@field MaintainPDFailHistrory FieldBase
---@field PCIeLinkWidth FieldBase
---@field UnconfiguredDriveWriteCachePolicy FieldBase
---@field HBADriveWriteCachePolicy FieldBase
---@field ConfiguredDriveWriteCachePolicy FieldBase
---@field SupportedRAIDTypes FieldBase
---@field SmarterCopyBackState FieldBase
---@field CopyBackState FieldBase
---@field BootDevices FieldBase
---@field HardwareRevision FieldBase
---@field HotSpareActivationMode FieldBase
---@field NoBatteryWriteCacheEnabled FieldBase
---@field ReadCachePercent FieldBase
---@field JBODState FieldBase
---@field CachePinnedState FieldBase
---@field DDREccCount FieldBase
---@field WorkMode FieldBase
---@field RefDrives FieldBase
---@field BOMNumber FieldBase
---@field CryptoEraseSupported FieldBase
---@field DriverName FieldBase
---@field DriverVersion FieldBase
---@field Model FieldBase
---@field ChipManufacturer FieldBase
---@field ConsistencyCheckState FieldBase
---@field PeriodOfHours FieldBase
---@field Rate FieldBase
---@field AutoRepairEnabled FieldBase
---@field RunningStatus FieldBase
---@field TotalVolumeCounts FieldBase
---@field CompletedVolumeCounts FieldBase
---@field DelayToStart FieldBase
---@field CreateVolumeSupported FieldBase
---@field SupportedReadPolicyList FieldBase
---@field DefaultReadPolicy FieldBase
---@field ReadPolicyWritable FieldBase
---@field SupportedWritePolicyList FieldBase
---@field DefaultWritePolicy FieldBase
---@field WritePolicyWritable FieldBase
---@field SupportedIOPolicyList FieldBase
---@field DefaultIOPolicy FieldBase
---@field IOPolicyWritable FieldBase
---@field SupportedAccessPolicyList FieldBase
---@field DefaultAccessPolicy FieldBase
---@field AccessPolicyWritable FieldBase
---@field SupportedDriveCachePolicyList FieldBase
---@field DefaultDriveCachePolicy FieldBase
---@field DriveCachePolicyWritable FieldBase
---@field FaultCode FieldBase
---@field CommunicationLoss FieldBase
---@field Health FieldBase
---@field FaultCodeByBios FieldBase
---@field BatteryPresence FieldBase
---@field BatteryFault FieldBase
---@field BatteryHealth FieldBase
---@field Media FieldBase
---@field Source FieldBase
---@field Description FieldBase
---@field Method FieldBase
---@field Result FieldBase
---@field Progress FieldBase
---@field RetirementState FieldBase
---@field AssetType FieldBase
---@field AssetName FieldBase
---@field InventorySerialNumber FieldBase
---@field InventoryFirmwareVersion FieldBase
---@field PCBVersion FieldBase
---@field Manufacturer FieldBase
---@field AssetTag FieldBase
---@field PartNumber FieldBase
---@field ManufactureDate FieldBase
---@field Slot FieldBase
---@field InventoryModel FieldBase
---@field UUID FieldBase
---@field ClassName FieldBase
---@field ObjectName FieldBase
---@field ObjectIdentifier FieldBase
---@field RefChip FieldBase
---@field SystemId FieldBase
---@field SocketId FieldBase
---@field Segment FieldBase
---@field DevBus FieldBase
---@field DevDevice FieldBase
---@field DevFunction FieldBase
---@field Eid FieldBase
---@field Phyaddr FieldBase
---@field CtrlOption1 FieldBase
---@field CtrlOption2 FieldBase
---@field CtrlOption3 FieldBase
---@field SlotId FieldBase

---@class DriveTable: Table
---@field NodeId FieldBase
---@field Id FieldBase
---@field SlotNumber FieldBase
---@field Name FieldBase
---@field Presence FieldBase
---@field LocateLed FieldBase
---@field FaultLed FieldBase
---@field EnclosureId FieldBase
---@field LocationIndicatorState FieldBase
---@field CapacityMiB FieldBase
---@field TemperatureCelsius FieldBase
---@field Model FieldBase
---@field Protocol FieldBase
---@field CapableSpeedGbs FieldBase
---@field NegotiatedSpeedGbs FieldBase
---@field MediaType FieldBase
---@field FirmwareStatus FieldBase
---@field SerialNumber FieldBase
---@field Manufacturer FieldBase
---@field PowerOnHours FieldBase
---@field Revision FieldBase
---@field RotationSpeedRPM FieldBase
---@field BlockSizeBytes FieldBase
---@field SASAddress1 FieldBase
---@field SASAddress2 FieldBase
---@field Location FieldBase
---@field DeviceName FieldBase
---@field PredictedMediaLifeLeftPercent FieldBase
---@field PredictedFailCount FieldBase
---@field MediaErrorCount FieldBase
---@field OtherErrorCount FieldBase
---@field PatrolState FieldBase
---@field PowerState FieldBase
---@field RebuildState FieldBase
---@field RebuildProgress FieldBase
---@field BootPriority FieldBase
---@field HotspareType FieldBase
---@field RefControllerId FieldBase
---@field RefVolumeList FieldBase
---@field RefDiskArrayId FieldBase
---@field ManufacturerId FieldBase
---@field PCIeLinkSpeed FieldBase
---@field ResourceId FieldBase
---@field Type FieldBase
---@field SocketId FieldBase
---@field SlotId FieldBase
---@field PortId FieldBase
---@field RootBDF FieldBase
---@field Missing FieldBase
---@field PredictiveFailure FieldBase
---@field InAFailedArray FieldBase
---@field CapacityError FieldBase
---@field FirmwareStatusError FieldBase
---@field Failure FieldBase
---@field Health FieldBase
---@field StripTemperatureCelsius FieldBase
---@field ElementsInGrownDefectList FieldBase
---@field ElementsInPrimaryDefectList FieldBase
---@field ManufacturedInWeekOfYear FieldBase
---@field BlocksSentToInitiator FieldBase
---@field BlocksReceivedFromInitiator FieldBase
---@field UntilNextInterSMARTTestMinutes FieldBase
---@field LastPrefailEventSeqNum FieldBase
---@field AssetType FieldBase
---@field AssetName FieldBase
---@field InventorySerialNumber FieldBase
---@field InventoryFirmwareVersion FieldBase
---@field PCBVersion FieldBase
---@field InventoryManufacturer FieldBase
---@field AssetTag FieldBase
---@field PartNumber FieldBase
---@field ManufactureDate FieldBase
---@field Slot FieldBase
---@field InventoryModel FieldBase
---@field UUID FieldBase
---@field EstimatedRemainingLifespanInsufficient FieldBase
---@field SLCSpareBlockPercentage FieldBase
---@field TLCSpareBlockPercentage FieldBase
---@field EstimatedRemainingLifespan FieldBase
---@field IODeteriorationHealthCode FieldBase
---@field LifeUsedPercentage FieldBase
---@field AvailableSpare FieldBase
---@field CriticalWarning FieldBase
---@field UsedPercentage FieldBase
---@field Status FieldBase
---@field ClassName FieldBase
---@field ObjectName FieldBase
---@field ObjectIdentifier FieldBase
---@field LocateReg FieldBase
---@field FaultReg FieldBase
---@field ActivationLed FieldBase
---@field PhysicalLocation FieldBase
---@field PassThrough FieldBase
---@field HddBackplaneStartSlot FieldBase
---@field RelativeSlot FieldBase
---@field LinkFault FieldBase
---@field SetLocateLed FieldBase
---@field SetFaultLed FieldBase

---@class DrivesTable: Table
---@field MaxTemperatureCelsius FieldBase
---@field LogAutoCollectEnable FieldBase
---@field LogAutoCollectInterval FieldBase
---@field ClassName FieldBase
---@field ObjectName FieldBase
---@field ObjectIdentifier FieldBase
---@field Id FieldBase

---@class NvmeTable: Table
---@field Slot FieldBase
---@field MediaType FieldBase
---@field Protocol FieldBase
---@field Revision FieldBase
---@field PredictedMediaLifeLeftPercent FieldBase
---@field VPDChip FieldBase
---@field SSDChip FieldBase
---@field RefComponent FieldBase
---@field TemperatureCelsius FieldBase
---@field Failure FieldBase
---@field PredictiveFailure FieldBase
---@field SerialNumber FieldBase

---@class VirtualVPDConnectTable: Table
---@field Slot FieldBase
---@field RefVPDChip FieldBase
---@field RefConnector FieldBase

---@class DriveInfoTableTable: Table
---@field Id FieldBase

---@class DrivesTableInfoTable: Table
---@field Id FieldBase
---@field TemperatureCelsius FieldBase
---@field IsAlerted FieldBase

---@class GlobalStorageConfigTableTable: Table
---@field Id FieldBase
---@field DiskPartitionUsagePercentageThreshold FieldBase

---@class StorageDBDatabase
---@field db DataBase
---@field select fun(db:DataBase, table: any, ...): SelectStatement
---@field update fun(db:DataBase, table: any, ...): UpdateStatement
---@field insert fun(db:DataBase, table: any, ...): InsertStatement
---@field StorageConfig StorageConfigTable
---@field Controller ControllerTable
---@field Drive DriveTable
---@field Drives DrivesTable
---@field Nvme NvmeTable
---@field VirtualVPDConnect VirtualVPDConnectTable
---@field DriveInfoTable DriveInfoTableTable
---@field DrivesTableInfo DrivesTableInfoTable
---@field GlobalStorageConfigTable GlobalStorageConfigTableTable
local StorageDBDatabase = {}
StorageDBDatabase.__index = StorageDBDatabase

function StorageDBDatabase.new(path, datas)
    local db = Databases(path)
    local obj = {db = db}

    obj.StorageConfig = db:Table('t_storage_config_table_info', {
        StorageConfigReady = Col.IntegerField():cid(1):null():max_length(8),
        VolumesStateAbnormal = Col.IntegerField():cid(2):null():max_length(8),
        DiskPartitionUsagePercentageThreshold = Col.IntegerField():cid(3):null():max_length(8):default(100),
        PhyErrorEnabled = Col.BooleandField():cid(4):primary_key():persistence_key('protect_power_off'):default(true),
        PhyErrorInterval = Col.IntegerField():cid(5):persistence_key('protect_power_off'):null():max_length(32):default(
            1800),
        PhyErrorMaxRecord = Col.IntegerField():cid(6):persistence_key('protect_power_off'):null():max_length(8):default(
            20),
        PhyErrorThreshold = Col.IntegerField():cid(7):persistence_key('protect_power_off'):null():max_length(32)
            :default(100),
        MaxPhyErrorLogFileRotationCount = Col.IntegerField():cid(8):persistence_key('protect_power_off'):null()
            :max_length(8):default(10),
        PhyErrorSelUnlimitFlag = Col.BooleandField():cid(9):persistence_key('protect_power_off'):null(),
        FileMockEnabled = Col.BooleandField():cid(10):persistence_key('protect_power_off'):null(),
        ClassName = Col.TextField():cid(11):null(),
        ObjectName = Col.TextField():cid(12):null(),
        ObjectIdentifier = Col.JsonField():cid(13):null()
    }):create_if_not_exist(datas and datas['t_storage_config_table_info'])
    obj.Controller = db:Table('t_controller_info', {
        Id = Col.IntegerField():cid(1):persistence_key('protect_reset_retain'):null():max_length(8):default(255),
        Type = Col.TextField():cid(2):null(),
        TypeId = Col.IntegerField():cid(3):null():max_length(8),
        DeviceName = Col.TextField():cid(4):primary_key(),
        Position = Col.TextField():cid(5):null(),
        TemperatureCelsius = Col.IntegerField():cid(6):null():max_length(16),
        TemperatureAbnormal = Col.IntegerField():cid(7):null():max_length(8),
        ControllerName = Col.TextField():cid(8):null(),
        OOBSupport = Col.IntegerField():cid(9):persistence_key('protect_power_off'):null():max_length(8),
        FirmwareVersion = Col.TextField():cid(10):null(),
        SupportedMode = Col.JsonField():cid(11):null(),
        MemorySizeMiB = Col.IntegerField():cid(12):null():max_length(16),
        DeviceInterface = Col.TextField():cid(13):null(),
        SASAddr = Col.TextField():cid(14):null(),
        SerialNumber = Col.TextField():cid(15):null(),
        MaxStripSizeBytes = Col.IntegerField():cid(16):null():max_length(32),
        MinStripSizeBytes = Col.IntegerField():cid(17):null():max_length(32),
        NVDataVersion = Col.TextField():cid(18):null(),
        MaintainPDFailHistrory = Col.IntegerField():cid(19):null():max_length(8),
        PCIeLinkWidth = Col.TextField():cid(20):null(),
        UnconfiguredDriveWriteCachePolicy = Col.TextField():cid(21):null(),
        HBADriveWriteCachePolicy = Col.TextField():cid(22):null(),
        ConfiguredDriveWriteCachePolicy = Col.TextField():cid(23):null(),
        SupportedRAIDTypes = Col.JsonField():cid(24):null(),
        SmarterCopyBackState = Col.IntegerField():cid(25):null():max_length(8),
        CopyBackState = Col.IntegerField():cid(26):null():max_length(8),
        BootDevices = Col.JsonField():cid(27):null(),
        HardwareRevision = Col.TextField():cid(28):null(),
        HotSpareActivationMode = Col.TextField():cid(29):null(),
        NoBatteryWriteCacheEnabled = Col.IntegerField():cid(30):null():max_length(8):default(255),
        ReadCachePercent = Col.IntegerField():cid(31):null():max_length(8):default(255),
        JBODState = Col.IntegerField():cid(32):null():max_length(8),
        CachePinnedState = Col.IntegerField():cid(33):null():max_length(8),
        DDREccCount = Col.IntegerField():cid(34):null():max_length(16),
        WorkMode = Col.TextField():cid(35):null(),
        RefDrives = Col.JsonField():cid(36):null(),
        BOMNumber = Col.TextField():cid(37):null(),
        CryptoEraseSupported = Col.BooleandField():cid(38):null(),
        DriverName = Col.TextField():cid(39):null(),
        DriverVersion = Col.TextField():cid(40):null(),
        Model = Col.TextField():cid(41):null(),
        ChipManufacturer = Col.TextField():cid(42):null(),
        ConsistencyCheckState = Col.IntegerField():cid(43):null():max_length(8),
        PeriodOfHours = Col.IntegerField():cid(44):null():max_length(16),
        Rate = Col.TextField():cid(45):null(),
        AutoRepairEnabled = Col.IntegerField():cid(46):null():max_length(8),
        RunningStatus = Col.TextField():cid(47):null(),
        TotalVolumeCounts = Col.IntegerField():cid(48):null():max_length(16),
        CompletedVolumeCounts = Col.IntegerField():cid(49):null():max_length(16),
        DelayToStart = Col.IntegerField():cid(50):null():max_length(32),
        CreateVolumeSupported = Col.BooleandField():cid(51):null(),
        SupportedReadPolicyList = Col.JsonField():cid(52):null(),
        DefaultReadPolicy = Col.TextField():cid(53):null(),
        ReadPolicyWritable = Col.BooleandField():cid(54):null(),
        SupportedWritePolicyList = Col.JsonField():cid(55):null(),
        DefaultWritePolicy = Col.TextField():cid(56):null(),
        WritePolicyWritable = Col.BooleandField():cid(57):null(),
        SupportedIOPolicyList = Col.JsonField():cid(58):null(),
        DefaultIOPolicy = Col.TextField():cid(59):null(),
        IOPolicyWritable = Col.BooleandField():cid(60):null(),
        SupportedAccessPolicyList = Col.JsonField():cid(61):null(),
        DefaultAccessPolicy = Col.TextField():cid(62):null(),
        AccessPolicyWritable = Col.BooleandField():cid(63):null(),
        SupportedDriveCachePolicyList = Col.JsonField():cid(64):null(),
        DefaultDriveCachePolicy = Col.TextField():cid(65):null(),
        DriveCachePolicyWritable = Col.BooleandField():cid(66):null(),
        FaultCode = Col.IntegerField():cid(67):null():max_length(16),
        CommunicationLoss = Col.IntegerField():cid(68):null():max_length(8),
        Health = Col.IntegerField():cid(69):null():max_length(8),
        FaultCodeByBios = Col.IntegerField():cid(70):persistence_key('protect_reset'):null():max_length(8),
        BatteryPresence = Col.IntegerField():cid(71):persistence_key('protect_reset'):null():max_length(8):default(255),
        BatteryFault = Col.IntegerField():cid(72):null():max_length(8),
        BatteryHealth = Col.IntegerField():cid(73):null():max_length(8),
        Media = Col.TextField():cid(74):null(),
        Source = Col.TextField():cid(75):null(),
        Description = Col.TextField():cid(76):null(),
        Method = Col.TextField():cid(77):null(),
        Result = Col.TextField():cid(78):null(),
        Progress = Col.IntegerField():cid(79):null():max_length(8),
        RetirementState = Col.TextField():cid(80):null():default('\'Idle\''),
        AssetType = Col.TextField():cid(81):null(),
        AssetName = Col.TextField():cid(82):null(),
        InventorySerialNumber = Col.TextField():cid(83):null(),
        InventoryFirmwareVersion = Col.TextField():cid(84):null(),
        PCBVersion = Col.TextField():cid(85):null(),
        Manufacturer = Col.TextField():cid(86):null(),
        AssetTag = Col.TextField():cid(87):null(),
        PartNumber = Col.TextField():cid(88):null(),
        ManufactureDate = Col.TextField():cid(89):null(),
        Slot = Col.TextField():cid(90):null(),
        InventoryModel = Col.TextField():cid(91):null(),
        UUID = Col.TextField():cid(92):null(),
        ClassName = Col.TextField():cid(93):null(),
        ObjectName = Col.TextField():cid(94):null(),
        ObjectIdentifier = Col.JsonField():cid(95):null(),
        RefChip = Col.JsonField():cid(96):null(),
        SystemId = Col.IntegerField():cid(97):null():max_length(8),
        SocketId = Col.IntegerField():cid(98):null():max_length(8),
        Segment = Col.IntegerField():cid(99):null():max_length(8),
        DevBus = Col.IntegerField():cid(100):null():max_length(8),
        DevDevice = Col.IntegerField():cid(101):null():max_length(8),
        DevFunction = Col.IntegerField():cid(102):null():max_length(8),
        Eid = Col.IntegerField():cid(103):null():max_length(8),
        Phyaddr = Col.IntegerField():cid(104):null():max_length(16),
        CtrlOption1 = Col.IntegerField():cid(105):null():max_length(32),
        CtrlOption2 = Col.IntegerField():cid(106):null():max_length(32),
        CtrlOption3 = Col.IntegerField():cid(107):null():max_length(32),
        SlotId = Col.IntegerField():cid(108):null():max_length(8)
    }):create_if_not_exist(datas and datas['t_controller_info'])
    obj.Drive = db:Table('t_storage_drive', {
        NodeId = Col.TextField():cid(1):null(),
        Id = Col.IntegerField():cid(2):primary_key():max_length(8),
        SlotNumber = Col.IntegerField():cid(3):persistence_key('protect_reset'):null():max_length(8):default(255),
        Name = Col.TextField():cid(4):null(),
        Presence = Col.IntegerField():cid(5):null():max_length(8):default(255),
        LocateLed = Col.IntegerField():cid(6):null():max_length(8),
        FaultLed = Col.IntegerField():cid(7):null():max_length(8),
        EnclosureId = Col.IntegerField():cid(8):persistence_key('protect_reset'):null():max_length(16):default(65535),
        LocationIndicatorState = Col.IntegerField():cid(9):null():max_length(8),
        CapacityMiB = Col.IntegerField():cid(10):persistence_key('protect_reset'):null():max_length(32):default(
            4294967295),
        TemperatureCelsius = Col.IntegerField():cid(11):null():max_length(16):default(255),
        Model = Col.TextField():cid(12):persistence_key('protect_reset'):null():default('\'N/A\''),
        Protocol = Col.IntegerField():cid(13):persistence_key('protect_reset'):null():max_length(8):default(255),
        CapableSpeedGbs = Col.IntegerField():cid(14):persistence_key('protect_reset'):null():max_length(8):default(255),
        NegotiatedSpeedGbs = Col.IntegerField():cid(15):persistence_key('protect_reset'):null():max_length(8):default(
            255),
        MediaType = Col.IntegerField():cid(16):persistence_key('protect_reset'):null():max_length(8):default(255),
        FirmwareStatus = Col.IntegerField():cid(17):null():max_length(8):default(255),
        SerialNumber = Col.TextField():cid(18):persistence_key('protect_reset'):null():default('\'N/A\''),
        Manufacturer = Col.TextField():cid(19):persistence_key('protect_reset'):null():default('\'N/A\''),
        PowerOnHours = Col.RealField():cid(20):null(),
        Revision = Col.TextField():cid(21):persistence_key('protect_reset'):null():default('\'N/A\''),
        RotationSpeedRPM = Col.IntegerField():cid(22):null():max_length(16),
        BlockSizeBytes = Col.IntegerField():cid(23):null():max_length(16),
        SASAddress1 = Col.TextField():cid(24):null(),
        SASAddress2 = Col.TextField():cid(25):null(),
        Location = Col.TextField():cid(26):null(),
        DeviceName = Col.TextField():cid(27):null():default('\'N/A\''),
        PredictedMediaLifeLeftPercent = Col.IntegerField():cid(28):null():max_length(8):default(255),
        PredictedFailCount = Col.IntegerField():cid(29):null():max_length(32),
        MediaErrorCount = Col.IntegerField():cid(30):null():max_length(32),
        OtherErrorCount = Col.IntegerField():cid(31):null():max_length(32),
        PatrolState = Col.IntegerField():cid(32):null():max_length(8),
        PowerState = Col.IntegerField():cid(33):null():max_length(8),
        RebuildState = Col.IntegerField():cid(34):null():max_length(8),
        RebuildProgress = Col.IntegerField():cid(35):null():max_length(8),
        BootPriority = Col.IntegerField():cid(36):null():max_length(8),
        HotspareType = Col.IntegerField():cid(37):null():max_length(8),
        RefControllerId = Col.IntegerField():cid(38):persistence_key('protect_reset'):null():max_length(8):default(255),
        RefVolumeList = Col.JsonField():cid(39):null(),
        RefDiskArrayId = Col.IntegerField():cid(40):null():max_length(16),
        ManufacturerId = Col.IntegerField():cid(41):null():max_length(32),
        PCIeLinkSpeed = Col.RealField():cid(42):null(),
        ResourceId = Col.IntegerField():cid(43):null():max_length(8),
        Type = Col.TextField():cid(44):null():default('\'N/A\''),
        SocketId = Col.IntegerField():cid(45):null():max_length(8),
        SlotId = Col.IntegerField():cid(46):null():max_length(8),
        PortId = Col.IntegerField():cid(47):null():max_length(8),
        RootBDF = Col.TextField():cid(48):null():default('\'N/A\''),
        Missing = Col.IntegerField():cid(49):null():max_length(16),
        PredictiveFailure = Col.IntegerField():cid(50):null():max_length(8),
        InAFailedArray = Col.IntegerField():cid(51):null():max_length(8),
        CapacityError = Col.BooleandField():cid(52):null(),
        FirmwareStatusError = Col.BooleandField():cid(53):null(),
        Failure = Col.BooleandField():cid(54):null(),
        Health = Col.IntegerField():cid(55):null():max_length(8),
        StripTemperatureCelsius = Col.IntegerField():cid(56):null():max_length(32),
        ElementsInGrownDefectList = Col.IntegerField():cid(57):null():max_length(32),
        ElementsInPrimaryDefectList = Col.IntegerField():cid(58):persistence_key('protect_reset'):null():max_length(32)
            :default(4294967295),
        ManufacturedInWeekOfYear = Col.TextField():cid(59):null(),
        BlocksSentToInitiator = Col.IntegerField():cid(60):null():max_length(32),
        BlocksReceivedFromInitiator = Col.IntegerField():cid(61):null():max_length(32),
        UntilNextInterSMARTTestMinutes = Col.IntegerField():cid(62):null():max_length(32),
        LastPrefailEventSeqNum = Col.IntegerField():cid(63):null():max_length(32),
        AssetType = Col.TextField():cid(64):null(),
        AssetName = Col.TextField():cid(65):null(),
        InventorySerialNumber = Col.TextField():cid(66):null(),
        InventoryFirmwareVersion = Col.TextField():cid(67):null(),
        PCBVersion = Col.TextField():cid(68):null(),
        InventoryManufacturer = Col.TextField():cid(69):null(),
        AssetTag = Col.TextField():cid(70):null(),
        PartNumber = Col.TextField():cid(71):null(),
        ManufactureDate = Col.TextField():cid(72):null(),
        Slot = Col.TextField():cid(73):null(),
        InventoryModel = Col.TextField():cid(74):null(),
        UUID = Col.TextField():cid(75):null(),
        EstimatedRemainingLifespanInsufficient = Col.IntegerField():cid(76):persistence_key('protect_reset'):null()
            :max_length(8),
        SLCSpareBlockPercentage = Col.IntegerField():cid(77):null():max_length(8):default(255),
        TLCSpareBlockPercentage = Col.IntegerField():cid(78):null():max_length(8):default(255),
        EstimatedRemainingLifespan = Col.IntegerField():cid(79):persistence_key('protect_power_off'):null():max_length(
            32):default(4294967295),
        IODeteriorationHealthCode = Col.IntegerField():cid(80):persistence_key('protect_power_off'):null()
            :max_length(16),
        LifeUsedPercentage = Col.IntegerField():cid(81):null():max_length(8),
        AvailableSpare = Col.IntegerField():cid(82):null():max_length(8),
        CriticalWarning = Col.IntegerField():cid(83):null():max_length(8),
        UsedPercentage = Col.IntegerField():cid(84):null():max_length(8),
        Status = Col.IntegerField():cid(85):null():max_length(8),
        ClassName = Col.TextField():cid(86):null(),
        ObjectName = Col.TextField():cid(87):null(),
        ObjectIdentifier = Col.JsonField():cid(88):null(),
        LocateReg = Col.IntegerField():cid(89):null():max_length(8),
        FaultReg = Col.IntegerField():cid(90):null():max_length(8),
        ActivationLed = Col.IntegerField():cid(91):null():max_length(8),
        PhysicalLocation = Col.TextField():cid(92):null(),
        PassThrough = Col.IntegerField():cid(93):null():max_length(8):default(255),
        HddBackplaneStartSlot = Col.IntegerField():cid(94):null():max_length(8):default(255),
        RelativeSlot = Col.IntegerField():cid(95):null():max_length(8),
        LinkFault = Col.BooleandField():cid(96):persistence_key('protect_reset'):null():default(false),
        SetLocateLed = Col.IntegerField():cid(97):null():max_length(8),
        SetFaultLed = Col.IntegerField():cid(98):null():max_length(8)
    }):create_if_not_exist(datas and datas['t_storage_drive'])
    obj.Drives = db:Table('t_drives_info', {
        MaxTemperatureCelsius = Col.IntegerField():cid(1):null():max_length(8),
        LogAutoCollectEnable = Col.BooleandField():cid(2):persistence_key('protect_power_off'):null():default(true),
        LogAutoCollectInterval = Col.IntegerField():cid(3):persistence_key('protect_power_off'):null():max_length(8)
            :default(24),
        ClassName = Col.TextField():cid(4):null(),
        ObjectName = Col.TextField():cid(5):null(),
        ObjectIdentifier = Col.JsonField():cid(6):null(),
        Id = Col.IntegerField():cid(7):primary_key():max_length(8)
    }):create_if_not_exist(datas and datas['t_drives_info'])
    obj.Nvme = db:Table('t_nvme_info', {
        Slot = Col.IntegerField():cid(1):primary_key():max_length(8),
        MediaType = Col.IntegerField():cid(2):null():max_length(8),
        Protocol = Col.IntegerField():cid(3):null():max_length(8),
        Revision = Col.TextField():cid(4):null(),
        PredictedMediaLifeLeftPercent = Col.IntegerField():cid(5):null():max_length(8),
        VPDChip = Col.JsonField():cid(6):null(),
        SSDChip = Col.JsonField():cid(7):null(),
        RefComponent = Col.JsonField():cid(8):null(),
        TemperatureCelsius = Col.IntegerField():cid(9):null():max_length(8),
        Failure = Col.IntegerField():cid(10):null():max_length(16),
        PredictiveFailure = Col.IntegerField():cid(11):null():max_length(16),
        SerialNumber = Col.TextField():cid(12):null()
    }):create_if_not_exist(datas and datas['t_nvme_info'])
    obj.VirtualVPDConnect = db:Table('t_vpd_connect', {
        Slot = Col.IntegerField():cid(1):primary_key():max_length(8),
        RefVPDChip = Col.JsonField():cid(2):null(),
        RefConnector = Col.JsonField():cid(3):null()
    }):create_if_not_exist(datas and datas['t_vpd_connect'])
    obj.DriveInfoTable = db:Table('t_drive_info',
        {Id = Col.TextField():cid(1):primary_key():persistence_key('protect_power_off')}):create_if_not_exist(datas and
                                                                                                                  datas['t_drive_info'])
    obj.DrivesTableInfo = db:Table('t_drives_table_info', {
        Id = Col.TextField():cid(1):primary_key():persistence_key('protect_power_off'),
        TemperatureCelsius = Col.IntegerField():cid(2):persistence_key('protect_power_off'):null():max_length(8),
        IsAlerted = Col.BooleandField():cid(3):persistence_key('protect_power_off'):null()
    }):create_if_not_exist(datas and datas['t_drives_table_info'])
    obj.GlobalStorageConfigTable = db:Table('t_storage_global_config_table', {
        Id = Col.TextField():cid(1):primary_key():persistence_key('protect_power_off')
            :default('\'GlobalStorageConfig\''),
        DiskPartitionUsagePercentageThreshold = Col.IntegerField():cid(2):persistence_key('protect_power_off'):null()
            :max_length(8):default(100)
    }):create_if_not_exist(datas and datas['t_storage_global_config_table'])

    obj.tables = db.tables
    return setmetatable(obj, StorageDBDatabase)
end

function StorageDBDatabase:select(table, ...)
    return self.db:select(table, ...)
end

function StorageDBDatabase:update(table, ...)
    return self.db:update(table, ...)
end

function StorageDBDatabase:insert(table, ...)
    return self.db:insert(table, ...)
end

function StorageDBDatabase:delete(table, ...)
    return self.db:delete(table, ...)
end

function StorageDBDatabase:exec(...)
    return self.db:exec(...)
end

return StorageDBDatabase.new
