-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MVirtualVPDConnect = {}

---@class MVirtualVPDConnect.RefConnector
---@field RefConnector integer[]
local TRefConnector = {}
TRefConnector.__index = TRefConnector
TRefConnector.group = {}

local function TRefConnector_from_obj(obj)
    return setmetatable(obj, TRefConnector)
end

function TRefConnector.new(RefConnector)
    return TRefConnector_from_obj({RefConnector = RefConnector})
end
---@param obj MVirtualVPDConnect.RefConnector
function TRefConnector:init_from_obj(obj)
    self.RefConnector = obj.RefConnector
end

function TRefConnector:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefConnector.group)
end

TRefConnector.from_obj = TRefConnector_from_obj

TRefConnector.proto_property = {'RefConnector'}

TRefConnector.default = {{}}

TRefConnector.struct = {{name = 'RefConnector', is_array = true, struct = nil}}

function TRefConnector:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefConnector', self.RefConnector, 'uint8', false, errs, need_convert)

    TRefConnector:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefConnector.proto_property, errs, need_convert)
    return self
end

function TRefConnector:unpack(_)
    return self.RefConnector
end

MVirtualVPDConnect.RefConnector = TRefConnector

---@class MVirtualVPDConnect.RefVPDChip
---@field RefVPDChip integer[]
local TRefVPDChip = {}
TRefVPDChip.__index = TRefVPDChip
TRefVPDChip.group = {}

local function TRefVPDChip_from_obj(obj)
    return setmetatable(obj, TRefVPDChip)
end

function TRefVPDChip.new(RefVPDChip)
    return TRefVPDChip_from_obj({RefVPDChip = RefVPDChip})
end
---@param obj MVirtualVPDConnect.RefVPDChip
function TRefVPDChip:init_from_obj(obj)
    self.RefVPDChip = obj.RefVPDChip
end

function TRefVPDChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefVPDChip.group)
end

TRefVPDChip.from_obj = TRefVPDChip_from_obj

TRefVPDChip.proto_property = {'RefVPDChip'}

TRefVPDChip.default = {{}}

TRefVPDChip.struct = {{name = 'RefVPDChip', is_array = true, struct = nil}}

function TRefVPDChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefVPDChip', self.RefVPDChip, 'uint8', false, errs, need_convert)

    TRefVPDChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefVPDChip.proto_property, errs, need_convert)
    return self
end

function TRefVPDChip:unpack(_)
    return self.RefVPDChip
end

MVirtualVPDConnect.RefVPDChip = TRefVPDChip

---@class MVirtualVPDConnect.Slot
---@field Slot integer
local TSlot = {}
TSlot.__index = TSlot
TSlot.group = {}

local function TSlot_from_obj(obj)
    return setmetatable(obj, TSlot)
end

function TSlot.new(Slot)
    return TSlot_from_obj({Slot = Slot})
end
---@param obj MVirtualVPDConnect.Slot
function TSlot:init_from_obj(obj)
    self.Slot = obj.Slot
end

function TSlot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlot.group)
end

TSlot.from_obj = TSlot_from_obj

TSlot.proto_property = {'Slot'}

TSlot.default = {0}

TSlot.struct = {{name = 'Slot', is_array = false, struct = nil}}

function TSlot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Slot', self.Slot, 'uint8', false, errs, need_convert)

    TSlot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlot.proto_property, errs, need_convert)
    return self
end

function TSlot:unpack(_)
    return self.Slot
end

MVirtualVPDConnect.Slot = TSlot

return MVirtualVPDConnect
