-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MNvme = {}

---@class MNvme.SerialNumber
---@field SerialNumber string
local TSerialNumber = {}
TSerialNumber.__index = TSerialNumber
TSerialNumber.group = {}

local function TSerialNumber_from_obj(obj)
    return setmetatable(obj, TSerialNumber)
end

function TSerialNumber.new(SerialNumber)
    return TSerialNumber_from_obj({SerialNumber = SerialNumber})
end
---@param obj MNvme.SerialNumber
function TSerialNumber:init_from_obj(obj)
    self.SerialNumber = obj.SerialNumber
end

function TSerialNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSerialNumber.group)
end

TSerialNumber.from_obj = TSerialNumber_from_obj

TSerialNumber.proto_property = {'SerialNumber'}

TSerialNumber.default = {''}

TSerialNumber.struct = {{name = 'SerialNumber', is_array = false, struct = nil}}

function TSerialNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SerialNumber', self.SerialNumber, 'string', false, errs, need_convert)

    TSerialNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSerialNumber.proto_property, errs, need_convert)
    return self
end

function TSerialNumber:unpack(_)
    return self.SerialNumber
end

MNvme.SerialNumber = TSerialNumber

---@class MNvme.PredictiveFailure
---@field PredictiveFailure integer
local TPredictiveFailure = {}
TPredictiveFailure.__index = TPredictiveFailure
TPredictiveFailure.group = {}

local function TPredictiveFailure_from_obj(obj)
    return setmetatable(obj, TPredictiveFailure)
end

function TPredictiveFailure.new(PredictiveFailure)
    return TPredictiveFailure_from_obj({PredictiveFailure = PredictiveFailure})
end
---@param obj MNvme.PredictiveFailure
function TPredictiveFailure:init_from_obj(obj)
    self.PredictiveFailure = obj.PredictiveFailure
end

function TPredictiveFailure:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPredictiveFailure.group)
end

TPredictiveFailure.from_obj = TPredictiveFailure_from_obj

TPredictiveFailure.proto_property = {'PredictiveFailure'}

TPredictiveFailure.default = {0}

TPredictiveFailure.struct = {{name = 'PredictiveFailure', is_array = false, struct = nil}}

function TPredictiveFailure:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PredictiveFailure', self.PredictiveFailure, 'uint16', false, errs, need_convert)

    TPredictiveFailure:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPredictiveFailure.proto_property, errs, need_convert)
    return self
end

function TPredictiveFailure:unpack(_)
    return self.PredictiveFailure
end

MNvme.PredictiveFailure = TPredictiveFailure

---@class MNvme.Failure
---@field Failure integer
local TFailure = {}
TFailure.__index = TFailure
TFailure.group = {}

local function TFailure_from_obj(obj)
    return setmetatable(obj, TFailure)
end

function TFailure.new(Failure)
    return TFailure_from_obj({Failure = Failure})
end
---@param obj MNvme.Failure
function TFailure:init_from_obj(obj)
    self.Failure = obj.Failure
end

function TFailure:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFailure.group)
end

TFailure.from_obj = TFailure_from_obj

TFailure.proto_property = {'Failure'}

TFailure.default = {0}

TFailure.struct = {{name = 'Failure', is_array = false, struct = nil}}

function TFailure:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Failure', self.Failure, 'uint16', false, errs, need_convert)

    TFailure:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFailure.proto_property, errs, need_convert)
    return self
end

function TFailure:unpack(_)
    return self.Failure
end

MNvme.Failure = TFailure

---@class MNvme.TemperatureCelsius
---@field TemperatureCelsius integer
local TTemperatureCelsius = {}
TTemperatureCelsius.__index = TTemperatureCelsius
TTemperatureCelsius.group = {}

local function TTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TTemperatureCelsius)
end

function TTemperatureCelsius.new(TemperatureCelsius)
    return TTemperatureCelsius_from_obj({TemperatureCelsius = TemperatureCelsius})
end
---@param obj MNvme.TemperatureCelsius
function TTemperatureCelsius:init_from_obj(obj)
    self.TemperatureCelsius = obj.TemperatureCelsius
end

function TTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTemperatureCelsius.group)
end

TTemperatureCelsius.from_obj = TTemperatureCelsius_from_obj

TTemperatureCelsius.proto_property = {'TemperatureCelsius'}

TTemperatureCelsius.default = {0}

TTemperatureCelsius.struct = {{name = 'TemperatureCelsius', is_array = false, struct = nil}}

function TTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TemperatureCelsius', self.TemperatureCelsius, 'uint8', false, errs, need_convert)

    TTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TTemperatureCelsius:unpack(_)
    return self.TemperatureCelsius
end

MNvme.TemperatureCelsius = TTemperatureCelsius

---@class MNvme.RefComponent
---@field RefComponent integer[]
local TRefComponent = {}
TRefComponent.__index = TRefComponent
TRefComponent.group = {}

local function TRefComponent_from_obj(obj)
    return setmetatable(obj, TRefComponent)
end

function TRefComponent.new(RefComponent)
    return TRefComponent_from_obj({RefComponent = RefComponent})
end
---@param obj MNvme.RefComponent
function TRefComponent:init_from_obj(obj)
    self.RefComponent = obj.RefComponent
end

function TRefComponent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefComponent.group)
end

TRefComponent.from_obj = TRefComponent_from_obj

TRefComponent.proto_property = {'RefComponent'}

TRefComponent.default = {{}}

TRefComponent.struct = {{name = 'RefComponent', is_array = true, struct = nil}}

function TRefComponent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefComponent', self.RefComponent, 'uint8', false, errs, need_convert)

    TRefComponent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefComponent.proto_property, errs, need_convert)
    return self
end

function TRefComponent:unpack(_)
    return self.RefComponent
end

MNvme.RefComponent = TRefComponent

---@class MNvme.SSDChip
---@field SSDChip integer[]
local TSSDChip = {}
TSSDChip.__index = TSSDChip
TSSDChip.group = {}

local function TSSDChip_from_obj(obj)
    return setmetatable(obj, TSSDChip)
end

function TSSDChip.new(SSDChip)
    return TSSDChip_from_obj({SSDChip = SSDChip})
end
---@param obj MNvme.SSDChip
function TSSDChip:init_from_obj(obj)
    self.SSDChip = obj.SSDChip
end

function TSSDChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSSDChip.group)
end

TSSDChip.from_obj = TSSDChip_from_obj

TSSDChip.proto_property = {'SSDChip'}

TSSDChip.default = {{}}

TSSDChip.struct = {{name = 'SSDChip', is_array = true, struct = nil}}

function TSSDChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'SSDChip', self.SSDChip, 'uint8', false, errs, need_convert)

    TSSDChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSSDChip.proto_property, errs, need_convert)
    return self
end

function TSSDChip:unpack(_)
    return self.SSDChip
end

MNvme.SSDChip = TSSDChip

---@class MNvme.VPDChip
---@field VPDChip integer[]
local TVPDChip = {}
TVPDChip.__index = TVPDChip
TVPDChip.group = {}

local function TVPDChip_from_obj(obj)
    return setmetatable(obj, TVPDChip)
end

function TVPDChip.new(VPDChip)
    return TVPDChip_from_obj({VPDChip = VPDChip})
end
---@param obj MNvme.VPDChip
function TVPDChip:init_from_obj(obj)
    self.VPDChip = obj.VPDChip
end

function TVPDChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVPDChip.group)
end

TVPDChip.from_obj = TVPDChip_from_obj

TVPDChip.proto_property = {'VPDChip'}

TVPDChip.default = {{}}

TVPDChip.struct = {{name = 'VPDChip', is_array = true, struct = nil}}

function TVPDChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'VPDChip', self.VPDChip, 'uint8', false, errs, need_convert)

    TVPDChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVPDChip.proto_property, errs, need_convert)
    return self
end

function TVPDChip:unpack(_)
    return self.VPDChip
end

MNvme.VPDChip = TVPDChip

---@class MNvme.PredictedMediaLifeLeftPercent
---@field PredictedMediaLifeLeftPercent integer
local TPredictedMediaLifeLeftPercent = {}
TPredictedMediaLifeLeftPercent.__index = TPredictedMediaLifeLeftPercent
TPredictedMediaLifeLeftPercent.group = {}

local function TPredictedMediaLifeLeftPercent_from_obj(obj)
    return setmetatable(obj, TPredictedMediaLifeLeftPercent)
end

function TPredictedMediaLifeLeftPercent.new(PredictedMediaLifeLeftPercent)
    return TPredictedMediaLifeLeftPercent_from_obj({PredictedMediaLifeLeftPercent = PredictedMediaLifeLeftPercent})
end
---@param obj MNvme.PredictedMediaLifeLeftPercent
function TPredictedMediaLifeLeftPercent:init_from_obj(obj)
    self.PredictedMediaLifeLeftPercent = obj.PredictedMediaLifeLeftPercent
end

function TPredictedMediaLifeLeftPercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPredictedMediaLifeLeftPercent.group)
end

TPredictedMediaLifeLeftPercent.from_obj = TPredictedMediaLifeLeftPercent_from_obj

TPredictedMediaLifeLeftPercent.proto_property = {'PredictedMediaLifeLeftPercent'}

TPredictedMediaLifeLeftPercent.default = {0}

TPredictedMediaLifeLeftPercent.struct = {{name = 'PredictedMediaLifeLeftPercent', is_array = false, struct = nil}}

function TPredictedMediaLifeLeftPercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PredictedMediaLifeLeftPercent', self.PredictedMediaLifeLeftPercent, 'uint8', false,
        errs, need_convert)

    TPredictedMediaLifeLeftPercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPredictedMediaLifeLeftPercent.proto_property, errs, need_convert)
    return self
end

function TPredictedMediaLifeLeftPercent:unpack(_)
    return self.PredictedMediaLifeLeftPercent
end

MNvme.PredictedMediaLifeLeftPercent = TPredictedMediaLifeLeftPercent

---@class MNvme.Revision
---@field Revision string
local TRevision = {}
TRevision.__index = TRevision
TRevision.group = {}

local function TRevision_from_obj(obj)
    return setmetatable(obj, TRevision)
end

function TRevision.new(Revision)
    return TRevision_from_obj({Revision = Revision})
end
---@param obj MNvme.Revision
function TRevision:init_from_obj(obj)
    self.Revision = obj.Revision
end

function TRevision:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRevision.group)
end

TRevision.from_obj = TRevision_from_obj

TRevision.proto_property = {'Revision'}

TRevision.default = {''}

TRevision.struct = {{name = 'Revision', is_array = false, struct = nil}}

function TRevision:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Revision', self.Revision, 'string', false, errs, need_convert)

    TRevision:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRevision.proto_property, errs, need_convert)
    return self
end

function TRevision:unpack(_)
    return self.Revision
end

MNvme.Revision = TRevision

---@class MNvme.Protocol
---@field Protocol integer
local TProtocol = {}
TProtocol.__index = TProtocol
TProtocol.group = {}

local function TProtocol_from_obj(obj)
    return setmetatable(obj, TProtocol)
end

function TProtocol.new(Protocol)
    return TProtocol_from_obj({Protocol = Protocol})
end
---@param obj MNvme.Protocol
function TProtocol:init_from_obj(obj)
    self.Protocol = obj.Protocol
end

function TProtocol:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProtocol.group)
end

TProtocol.from_obj = TProtocol_from_obj

TProtocol.proto_property = {'Protocol'}

TProtocol.default = {0}

TProtocol.struct = {{name = 'Protocol', is_array = false, struct = nil}}

function TProtocol:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Protocol', self.Protocol, 'uint8', false, errs, need_convert)

    TProtocol:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProtocol.proto_property, errs, need_convert)
    return self
end

function TProtocol:unpack(_)
    return self.Protocol
end

MNvme.Protocol = TProtocol

---@class MNvme.MediaType
---@field MediaType integer
local TMediaType = {}
TMediaType.__index = TMediaType
TMediaType.group = {}

local function TMediaType_from_obj(obj)
    return setmetatable(obj, TMediaType)
end

function TMediaType.new(MediaType)
    return TMediaType_from_obj({MediaType = MediaType})
end
---@param obj MNvme.MediaType
function TMediaType:init_from_obj(obj)
    self.MediaType = obj.MediaType
end

function TMediaType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMediaType.group)
end

TMediaType.from_obj = TMediaType_from_obj

TMediaType.proto_property = {'MediaType'}

TMediaType.default = {0}

TMediaType.struct = {{name = 'MediaType', is_array = false, struct = nil}}

function TMediaType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MediaType', self.MediaType, 'uint8', false, errs, need_convert)

    TMediaType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMediaType.proto_property, errs, need_convert)
    return self
end

function TMediaType:unpack(_)
    return self.MediaType
end

MNvme.MediaType = TMediaType

---@class MNvme.Slot
---@field Slot integer
local TSlot = {}
TSlot.__index = TSlot
TSlot.group = {}

local function TSlot_from_obj(obj)
    return setmetatable(obj, TSlot)
end

function TSlot.new(Slot)
    return TSlot_from_obj({Slot = Slot})
end
---@param obj MNvme.Slot
function TSlot:init_from_obj(obj)
    self.Slot = obj.Slot
end

function TSlot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlot.group)
end

TSlot.from_obj = TSlot_from_obj

TSlot.proto_property = {'Slot'}

TSlot.default = {0}

TSlot.struct = {{name = 'Slot', is_array = false, struct = nil}}

function TSlot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Slot', self.Slot, 'uint8', false, errs, need_convert)

    TSlot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlot.proto_property, errs, need_convert)
    return self
end

function TSlot:unpack(_)
    return self.Slot
end

MNvme.Slot = TSlot

return MNvme
