-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MGlobalStorageConfigTable = {}

---@class MGlobalStorageConfigTable.DiskPartitionUsagePercentageThreshold
---@field DiskPartitionUsagePercentageThreshold integer
local TDiskPartitionUsagePercentageThreshold = {}
TDiskPartitionUsagePercentageThreshold.__index = TDiskPartitionUsagePercentageThreshold
TDiskPartitionUsagePercentageThreshold.group = {}

local function TDiskPartitionUsagePercentageThreshold_from_obj(obj)
    return setmetatable(obj, TDiskPartitionUsagePercentageThreshold)
end

function TDiskPartitionUsagePercentageThreshold.new(DiskPartitionUsagePercentageThreshold)
    return TDiskPartitionUsagePercentageThreshold_from_obj({
        DiskPartitionUsagePercentageThreshold = DiskPartitionUsagePercentageThreshold or 100
    })
end
---@param obj MGlobalStorageConfigTable.DiskPartitionUsagePercentageThreshold
function TDiskPartitionUsagePercentageThreshold:init_from_obj(obj)
    self.DiskPartitionUsagePercentageThreshold = obj.DiskPartitionUsagePercentageThreshold or 100
end

function TDiskPartitionUsagePercentageThreshold:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDiskPartitionUsagePercentageThreshold.group)
end

TDiskPartitionUsagePercentageThreshold.from_obj = TDiskPartitionUsagePercentageThreshold_from_obj

TDiskPartitionUsagePercentageThreshold.proto_property = {'DiskPartitionUsagePercentageThreshold'}

TDiskPartitionUsagePercentageThreshold.default = {0}

TDiskPartitionUsagePercentageThreshold.struct = {
    {name = 'DiskPartitionUsagePercentageThreshold', is_array = false, struct = nil}
}

function TDiskPartitionUsagePercentageThreshold:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DiskPartitionUsagePercentageThreshold', self.DiskPartitionUsagePercentageThreshold,
        'uint8', false, errs, need_convert)

    TDiskPartitionUsagePercentageThreshold:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDiskPartitionUsagePercentageThreshold.proto_property, errs, need_convert)
    return self
end

function TDiskPartitionUsagePercentageThreshold:unpack(_)
    return self.DiskPartitionUsagePercentageThreshold
end

MGlobalStorageConfigTable.DiskPartitionUsagePercentageThreshold = TDiskPartitionUsagePercentageThreshold

---@class MGlobalStorageConfigTable.Id
---@field Id string
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id or [=[GlobalStorageConfig]=]})
end
---@param obj MGlobalStorageConfigTable.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id or [=[GlobalStorageConfig]=]
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {''}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MGlobalStorageConfigTable.Id = TId

return MGlobalStorageConfigTable
