-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MDrivesTableInfo = {}

---@class MDrivesTableInfo.IsAlerted
---@field IsAlerted boolean
local TIsAlerted = {}
TIsAlerted.__index = TIsAlerted
TIsAlerted.group = {}

local function TIsAlerted_from_obj(obj)
    return setmetatable(obj, TIsAlerted)
end

function TIsAlerted.new(IsAlerted)
    return TIsAlerted_from_obj({IsAlerted = IsAlerted})
end
---@param obj MDrivesTableInfo.IsAlerted
function TIsAlerted:init_from_obj(obj)
    self.IsAlerted = obj.IsAlerted
end

function TIsAlerted:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIsAlerted.group)
end

TIsAlerted.from_obj = TIsAlerted_from_obj

TIsAlerted.proto_property = {'IsAlerted'}

TIsAlerted.default = {false}

TIsAlerted.struct = {{name = 'IsAlerted', is_array = false, struct = nil}}

function TIsAlerted:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IsAlerted', self.IsAlerted, 'bool', false, errs, need_convert)

    TIsAlerted:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIsAlerted.proto_property, errs, need_convert)
    return self
end

function TIsAlerted:unpack(_)
    return self.IsAlerted
end

MDrivesTableInfo.IsAlerted = TIsAlerted

---@class MDrivesTableInfo.TemperatureCelsius
---@field TemperatureCelsius integer
local TTemperatureCelsius = {}
TTemperatureCelsius.__index = TTemperatureCelsius
TTemperatureCelsius.group = {}

local function TTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TTemperatureCelsius)
end

function TTemperatureCelsius.new(TemperatureCelsius)
    return TTemperatureCelsius_from_obj({TemperatureCelsius = TemperatureCelsius})
end
---@param obj MDrivesTableInfo.TemperatureCelsius
function TTemperatureCelsius:init_from_obj(obj)
    self.TemperatureCelsius = obj.TemperatureCelsius
end

function TTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTemperatureCelsius.group)
end

TTemperatureCelsius.from_obj = TTemperatureCelsius_from_obj

TTemperatureCelsius.proto_property = {'TemperatureCelsius'}

TTemperatureCelsius.default = {0}

TTemperatureCelsius.struct = {{name = 'TemperatureCelsius', is_array = false, struct = nil}}

function TTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TemperatureCelsius', self.TemperatureCelsius, 'uint8', false, errs, need_convert)

    TTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TTemperatureCelsius:unpack(_)
    return self.TemperatureCelsius
end

MDrivesTableInfo.TemperatureCelsius = TTemperatureCelsius

---@class MDrivesTableInfo.Id
---@field Id string
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MDrivesTableInfo.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {''}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MDrivesTableInfo.Id = TId

return MDrivesTableInfo
