-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MDiskArray = {}

---@class MDiskArray.RefPDEnclosures
---@field RefPDEnclosures integer[]
local TRefPDEnclosures = {}
TRefPDEnclosures.__index = TRefPDEnclosures
TRefPDEnclosures.group = {}

local function TRefPDEnclosures_from_obj(obj)
    return setmetatable(obj, TRefPDEnclosures)
end

function TRefPDEnclosures.new(RefPDEnclosures)
    return TRefPDEnclosures_from_obj({RefPDEnclosures = RefPDEnclosures})
end
---@param obj MDiskArray.RefPDEnclosures
function TRefPDEnclosures:init_from_obj(obj)
    self.RefPDEnclosures = obj.RefPDEnclosures
end

function TRefPDEnclosures:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefPDEnclosures.group)
end

TRefPDEnclosures.from_obj = TRefPDEnclosures_from_obj

TRefPDEnclosures.proto_property = {'RefPDEnclosures'}

TRefPDEnclosures.default = {{}}

TRefPDEnclosures.struct = {{name = 'RefPDEnclosures', is_array = true, struct = nil}}

function TRefPDEnclosures:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefPDEnclosures', self.RefPDEnclosures, 'uint16', true, errs, need_convert)

    TRefPDEnclosures:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefPDEnclosures.proto_property, errs, need_convert)
    return self
end

function TRefPDEnclosures:unpack(_)
    return self.RefPDEnclosures
end

MDiskArray.RefPDEnclosures = TRefPDEnclosures

---@class MDiskArray.RefPDSlots
---@field RefPDSlots integer[]
local TRefPDSlots = {}
TRefPDSlots.__index = TRefPDSlots
TRefPDSlots.group = {}

local function TRefPDSlots_from_obj(obj)
    return setmetatable(obj, TRefPDSlots)
end

function TRefPDSlots.new(RefPDSlots)
    return TRefPDSlots_from_obj({RefPDSlots = RefPDSlots})
end
---@param obj MDiskArray.RefPDSlots
function TRefPDSlots:init_from_obj(obj)
    self.RefPDSlots = obj.RefPDSlots
end

function TRefPDSlots:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefPDSlots.group)
end

TRefPDSlots.from_obj = TRefPDSlots_from_obj

TRefPDSlots.proto_property = {'RefPDSlots'}

TRefPDSlots.default = {{}}

TRefPDSlots.struct = {{name = 'RefPDSlots', is_array = true, struct = nil}}

function TRefPDSlots:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefPDSlots', self.RefPDSlots, 'uint8', true, errs, need_convert)

    TRefPDSlots:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefPDSlots.proto_property, errs, need_convert)
    return self
end

function TRefPDSlots:unpack(_)
    return self.RefPDSlots
end

MDiskArray.RefPDSlots = TRefPDSlots

return MDiskArray
