-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: test the external RPC interfaces of sensor.
local mdb = require 'mc.mdb'
local log = require 'mc.logging'
local skynet = require 'skynet'
local ctx = require 'mc.context'

require 'sensor.json_types.Entity'
require 'sensor.json_types.ThresholdSensorDisplay'

local entity_interface = {}
entity_interface.__index = entity_interface

function entity_interface.test_entity(bus)
    local path = '/bmc/kepler/Systems/1/Entities/Entity_MainBoard_0101'
    local intf = 'bmc.kepler.Systems.Entity'
    local mobj = mdb.get_object(bus, path, intf)
    assert(mobj['Id'] == 7, 'actual: ' .. mobj['Id'])
    assert(mobj['Instance'] == 96, 'actual: ' .. mobj['Instance'])
    assert(mobj['PowerState'] == 1, 'actual: ' .. mobj['PowerState'])
end

function entity_interface.test_entity_power(bus)
    log:info('== test sensor entity power start ...')
    local path = '/bmc/kepler/Systems/1/ThresholdSensors/ThresholdSensor_InletTemp_0101'
    local intf = 'bmc.kepler.Systems.ThresholdSensorDisplay'
    local mobj = mdb.get_object(bus, path, intf)
    assert(mobj.Status == 'Enabled', 'actual: ' .. mobj.Status)
    local sensors_path = '/bmc/kepler/Chassis/1/Sensors'
    local sensors_intf = 'bmc.kepler.Chassis.Sensors'
    local obj = mdb.get_object(bus, sensors_path, sensors_intf)
    local rsp = obj:GetSensorList_PACKED(ctx.new())
    local o = rsp.SensorList[1]
    assert(o.SensorName == 'Inlet Temp', 'actual: ' .. o.SensorName)
    assert(o.SensorReading == '35.000', 'actual: ' .. o.SensorReading)
    assert(o.SensorStatus == 'ok', 'actual: ' .. o.SensorStatus)

    -- Entity 掉电测试
    skynet.call('sensor', 'lua', 'power_ctrl', 7, 96, 1, 0)
    skynet.sleep(10)
    mobj = mdb.get_object(bus, path, intf)
    assert(mobj.Status == 'Disabled', 'actual: ' .. mobj.Status)
    rsp = obj:GetSensorList_PACKED(ctx.new())
    o = rsp.SensorList[1]
    assert(o.SensorName == 'Inlet Temp', 'actual: ' .. o.SensorName)
    assert(o.SensorReading == 'na', 'actual: ' .. o.SensorReading)
    assert(o.SensorStatus == 'na', 'actual: ' .. o.SensorStatus)

    -- Entity 上电测试
    skynet.call('sensor', 'lua', 'power_ctrl', 7, 96, 1, 1)
    skynet.sleep(10)
    mobj = mdb.get_object(bus, path, intf)
    assert(mobj.Status == 'Enabled', 'actual: ' .. mobj.Status)
    rsp = obj:GetSensorList_PACKED(ctx.new())
    o = rsp.SensorList[1]
    assert(o.SensorName == 'Inlet Temp', 'actual: ' .. o.SensorName)
    assert(o.SensorReading == '35.000', 'actual: ' .. o.SensorReading)
    assert(o.SensorStatus == 'ok', 'actual: ' .. o.SensorStatus)
end

function entity_interface.test_entry(bus)
    log:info('================ test entity interface start ================')

    entity_interface.test_entity(bus)
    entity_interface.test_entity_power(bus)

    log:info('================ test entity interface complete ================')
end

return entity_interface