--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetSensorThreshold = {}

---@class SensorIpmiCmds.SetSensorThresholdReq
---@field Number integer
---@field LNCFlag integer
---@field LCRFlag integer
---@field LNRFlag integer
---@field UNCFlag integer
---@field UCRFlag integer
---@field UNRFlag integer
---@field Reserved integer
---@field LNCValue integer
---@field LCRValue integer
---@field LNRValue integer
---@field UNCValue integer
---@field UCRValue integer
---@field UNRValue integer
local TSetSensorThresholdReq = {}
TSetSensorThresholdReq.__index = TSetSensorThresholdReq
TSetSensorThresholdReq.group = {}

local function TSetSensorThresholdReq_from_obj(obj)
    return setmetatable(obj, TSetSensorThresholdReq)
end

function TSetSensorThresholdReq.new(Number, LNCFlag, LCRFlag, LNRFlag, UNCFlag, UCRFlag, UNRFlag, Reserved, LNCValue,
    LCRValue, LNRValue, UNCValue, UCRValue, UNRValue)
    return TSetSensorThresholdReq_from_obj({
        Number = Number,
        LNCFlag = LNCFlag,
        LCRFlag = LCRFlag,
        LNRFlag = LNRFlag,
        UNCFlag = UNCFlag,
        UCRFlag = UCRFlag,
        UNRFlag = UNRFlag,
        Reserved = Reserved,
        LNCValue = LNCValue,
        LCRValue = LCRValue,
        LNRValue = LNRValue,
        UNCValue = UNCValue,
        UCRValue = UCRValue,
        UNRValue = UNRValue
    })
end
---@param obj SensorIpmiCmds.SetSensorThresholdReq
function TSetSensorThresholdReq:init_from_obj(obj)
    self.Number = obj.Number
    self.LNCFlag = obj.LNCFlag
    self.LCRFlag = obj.LCRFlag
    self.LNRFlag = obj.LNRFlag
    self.UNCFlag = obj.UNCFlag
    self.UCRFlag = obj.UCRFlag
    self.UNRFlag = obj.UNRFlag
    self.Reserved = obj.Reserved
    self.LNCValue = obj.LNCValue
    self.LCRValue = obj.LCRValue
    self.LNRValue = obj.LNRValue
    self.UNCValue = obj.UNCValue
    self.UCRValue = obj.UCRValue
    self.UNRValue = obj.UNRValue
end

function TSetSensorThresholdReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSensorThresholdReq.group)
end

TSetSensorThresholdReq.from_obj = TSetSensorThresholdReq_from_obj

TSetSensorThresholdReq.proto_property = {
    'Number', 'LNCFlag', 'LCRFlag', 'LNRFlag', 'UNCFlag', 'UCRFlag', 'UNRFlag', 'Reserved', 'LNCValue', 'LCRValue',
    'LNRValue', 'UNCValue', 'UCRValue', 'UNRValue'
}

TSetSensorThresholdReq.default = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}

TSetSensorThresholdReq.struct = {
    {name = 'Number', is_array = false, struct = nil}, {name = 'LNCFlag', is_array = false, struct = nil},
    {name = 'LCRFlag', is_array = false, struct = nil}, {name = 'LNRFlag', is_array = false, struct = nil},
    {name = 'UNCFlag', is_array = false, struct = nil}, {name = 'UCRFlag', is_array = false, struct = nil},
    {name = 'UNRFlag', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'LNCValue', is_array = false, struct = nil}, {name = 'LCRValue', is_array = false, struct = nil},
    {name = 'LNRValue', is_array = false, struct = nil}, {name = 'UNCValue', is_array = false, struct = nil},
    {name = 'UCRValue', is_array = false, struct = nil}, {name = 'UNRValue', is_array = false, struct = nil}
}

function TSetSensorThresholdReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Number', self.Number, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LNCFlag', self.LNCFlag, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LCRFlag', self.LCRFlag, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LNRFlag', self.LNRFlag, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'UNCFlag', self.UNCFlag, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'UCRFlag', self.UCRFlag, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'UNRFlag', self.UNRFlag, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LNCValue', self.LNCValue, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LCRValue', self.LCRValue, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LNRValue', self.LNRValue, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'UNCValue', self.UNCValue, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'UCRValue', self.UCRValue, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'UNRValue', self.UNRValue, 'uint8', false, errs, need_convert)

    TSetSensorThresholdReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSensorThresholdReq.proto_property, errs, need_convert)
    return self
end

function TSetSensorThresholdReq:unpack(_)
    return self.Number, self.LNCFlag, self.LCRFlag, self.LNRFlag, self.UNCFlag, self.UCRFlag, self.UNRFlag,
        self.Reserved, self.LNCValue, self.LCRValue, self.LNRValue, self.UNCValue, self.UCRValue, self.UNRValue
end

SetSensorThreshold.SetSensorThresholdReq = TSetSensorThresholdReq

---@class SensorIpmiCmds.SetSensorThresholdRsp
---@field CompletionCode integer
local TSetSensorThresholdRsp = {}
TSetSensorThresholdRsp.__index = TSetSensorThresholdRsp
TSetSensorThresholdRsp.group = {}

local function TSetSensorThresholdRsp_from_obj(obj)
    return setmetatable(obj, TSetSensorThresholdRsp)
end

function TSetSensorThresholdRsp.new(CompletionCode)
    return TSetSensorThresholdRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj SensorIpmiCmds.SetSensorThresholdRsp
function TSetSensorThresholdRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetSensorThresholdRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSensorThresholdRsp.group)
end

TSetSensorThresholdRsp.from_obj = TSetSensorThresholdRsp_from_obj

TSetSensorThresholdRsp.proto_property = {'CompletionCode'}

TSetSensorThresholdRsp.default = {0}

TSetSensorThresholdRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetSensorThresholdRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetSensorThresholdRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSensorThresholdRsp.proto_property, errs, need_convert)
    return self
end

function TSetSensorThresholdRsp:unpack(_)
    return self.CompletionCode
end

SetSensorThreshold.SetSensorThresholdRsp = TSetSensorThresholdRsp

return SetSensorThreshold
