--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetSensorHysteresis = {}

---@class SensorIpmiCmds.SetSensorHysteresisReq
---@field Number integer
---@field Reserved integer
---@field PHysteresis integer
---@field NHysteresis integer
local TSetSensorHysteresisReq = {}
TSetSensorHysteresisReq.__index = TSetSensorHysteresisReq
TSetSensorHysteresisReq.group = {}

local function TSetSensorHysteresisReq_from_obj(obj)
    return setmetatable(obj, TSetSensorHysteresisReq)
end

function TSetSensorHysteresisReq.new(Number, Reserved, PHysteresis, NHysteresis)
    return TSetSensorHysteresisReq_from_obj({
        Number = Number,
        Reserved = Reserved,
        PHysteresis = PHysteresis,
        NHysteresis = NHysteresis
    })
end
---@param obj SensorIpmiCmds.SetSensorHysteresisReq
function TSetSensorHysteresisReq:init_from_obj(obj)
    self.Number = obj.Number
    self.Reserved = obj.Reserved
    self.PHysteresis = obj.PHysteresis
    self.NHysteresis = obj.NHysteresis
end

function TSetSensorHysteresisReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSensorHysteresisReq.group)
end

TSetSensorHysteresisReq.from_obj = TSetSensorHysteresisReq_from_obj

TSetSensorHysteresisReq.proto_property = {'Number', 'Reserved', 'PHysteresis', 'NHysteresis'}

TSetSensorHysteresisReq.default = {0, 0, 0, 0}

TSetSensorHysteresisReq.struct = {
    {name = 'Number', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'PHysteresis', is_array = false, struct = nil}, {name = 'NHysteresis', is_array = false, struct = nil}
}

function TSetSensorHysteresisReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Number', self.Number, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PHysteresis', self.PHysteresis, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'NHysteresis', self.NHysteresis, 'uint8', false, errs, need_convert)

    TSetSensorHysteresisReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSensorHysteresisReq.proto_property, errs, need_convert)
    return self
end

function TSetSensorHysteresisReq:unpack(_)
    return self.Number, self.Reserved, self.PHysteresis, self.NHysteresis
end

SetSensorHysteresis.SetSensorHysteresisReq = TSetSensorHysteresisReq

---@class SensorIpmiCmds.SetSensorHysteresisRsp
---@field CompletionCode integer
local TSetSensorHysteresisRsp = {}
TSetSensorHysteresisRsp.__index = TSetSensorHysteresisRsp
TSetSensorHysteresisRsp.group = {}

local function TSetSensorHysteresisRsp_from_obj(obj)
    return setmetatable(obj, TSetSensorHysteresisRsp)
end

function TSetSensorHysteresisRsp.new(CompletionCode)
    return TSetSensorHysteresisRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj SensorIpmiCmds.SetSensorHysteresisRsp
function TSetSensorHysteresisRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetSensorHysteresisRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSensorHysteresisRsp.group)
end

TSetSensorHysteresisRsp.from_obj = TSetSensorHysteresisRsp_from_obj

TSetSensorHysteresisRsp.proto_property = {'CompletionCode'}

TSetSensorHysteresisRsp.default = {0}

TSetSensorHysteresisRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetSensorHysteresisRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetSensorHysteresisRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSensorHysteresisRsp.proto_property, errs, need_convert)
    return self
end

function TSetSensorHysteresisRsp:unpack(_)
    return self.CompletionCode
end

SetSensorHysteresis.SetSensorHysteresisRsp = TSetSensorHysteresisRsp

return SetSensorHysteresis
