--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetSensorEventEnable = {}

---@class SensorIpmiCmds.SetSensorEventEnableReq
---@field Datas string
local TSetSensorEventEnableReq = {}
TSetSensorEventEnableReq.__index = TSetSensorEventEnableReq
TSetSensorEventEnableReq.group = {}

local function TSetSensorEventEnableReq_from_obj(obj)
    return setmetatable(obj, TSetSensorEventEnableReq)
end

function TSetSensorEventEnableReq.new(Datas)
    return TSetSensorEventEnableReq_from_obj({Datas = Datas})
end
---@param obj SensorIpmiCmds.SetSensorEventEnableReq
function TSetSensorEventEnableReq:init_from_obj(obj)
    self.Datas = obj.Datas
end

function TSetSensorEventEnableReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSensorEventEnableReq.group)
end

TSetSensorEventEnableReq.from_obj = TSetSensorEventEnableReq_from_obj

TSetSensorEventEnableReq.proto_property = {'Datas'}

TSetSensorEventEnableReq.default = {''}

TSetSensorEventEnableReq.struct = {{name = 'Datas', is_array = false, struct = nil}}

function TSetSensorEventEnableReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Datas', self.Datas, 'string', false, errs, need_convert)

    TSetSensorEventEnableReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSensorEventEnableReq.proto_property, errs, need_convert)
    return self
end

function TSetSensorEventEnableReq:unpack(_)
    return self.Datas
end

SetSensorEventEnable.SetSensorEventEnableReq = TSetSensorEventEnableReq

---@class SensorIpmiCmds.SetSensorEventEnableRsp
---@field CompletionCode integer
local TSetSensorEventEnableRsp = {}
TSetSensorEventEnableRsp.__index = TSetSensorEventEnableRsp
TSetSensorEventEnableRsp.group = {}

local function TSetSensorEventEnableRsp_from_obj(obj)
    return setmetatable(obj, TSetSensorEventEnableRsp)
end

function TSetSensorEventEnableRsp.new(CompletionCode)
    return TSetSensorEventEnableRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj SensorIpmiCmds.SetSensorEventEnableRsp
function TSetSensorEventEnableRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetSensorEventEnableRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSensorEventEnableRsp.group)
end

TSetSensorEventEnableRsp.from_obj = TSetSensorEventEnableRsp_from_obj

TSetSensorEventEnableRsp.proto_property = {'CompletionCode'}

TSetSensorEventEnableRsp.default = {0}

TSetSensorEventEnableRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetSensorEventEnableRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetSensorEventEnableRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSensorEventEnableRsp.proto_property, errs, need_convert)
    return self
end

function TSetSensorEventEnableRsp:unpack(_)
    return self.CompletionCode
end

SetSensorEventEnable.SetSensorEventEnableRsp = TSetSensorEventEnableRsp

return SetSensorEventEnable
