--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetPEFPostponeTimer = {}

---@class SensorIpmiCmds.SetPEFPostponeTimerReq
---@field Timeout integer
local TSetPEFPostponeTimerReq = {}
TSetPEFPostponeTimerReq.__index = TSetPEFPostponeTimerReq
TSetPEFPostponeTimerReq.group = {}

local function TSetPEFPostponeTimerReq_from_obj(obj)
    return setmetatable(obj, TSetPEFPostponeTimerReq)
end

function TSetPEFPostponeTimerReq.new(Timeout)
    return TSetPEFPostponeTimerReq_from_obj({Timeout = Timeout})
end
---@param obj SensorIpmiCmds.SetPEFPostponeTimerReq
function TSetPEFPostponeTimerReq:init_from_obj(obj)
    self.Timeout = obj.Timeout
end

function TSetPEFPostponeTimerReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPEFPostponeTimerReq.group)
end

TSetPEFPostponeTimerReq.from_obj = TSetPEFPostponeTimerReq_from_obj

TSetPEFPostponeTimerReq.proto_property = {'Timeout'}

TSetPEFPostponeTimerReq.default = {0}

TSetPEFPostponeTimerReq.struct = {{name = 'Timeout', is_array = false, struct = nil}}

function TSetPEFPostponeTimerReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Timeout', self.Timeout, 'uint8', false, errs, need_convert)

    TSetPEFPostponeTimerReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPEFPostponeTimerReq.proto_property, errs, need_convert)
    return self
end

function TSetPEFPostponeTimerReq:unpack(_)
    return self.Timeout
end

SetPEFPostponeTimer.SetPEFPostponeTimerReq = TSetPEFPostponeTimerReq

---@class SensorIpmiCmds.SetPEFPostponeTimerRsp
---@field CompletionCode integer
---@field Timeout integer
local TSetPEFPostponeTimerRsp = {}
TSetPEFPostponeTimerRsp.__index = TSetPEFPostponeTimerRsp
TSetPEFPostponeTimerRsp.group = {}

local function TSetPEFPostponeTimerRsp_from_obj(obj)
    return setmetatable(obj, TSetPEFPostponeTimerRsp)
end

function TSetPEFPostponeTimerRsp.new(CompletionCode, Timeout)
    return TSetPEFPostponeTimerRsp_from_obj({CompletionCode = CompletionCode, Timeout = Timeout})
end
---@param obj SensorIpmiCmds.SetPEFPostponeTimerRsp
function TSetPEFPostponeTimerRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Timeout = obj.Timeout
end

function TSetPEFPostponeTimerRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPEFPostponeTimerRsp.group)
end

TSetPEFPostponeTimerRsp.from_obj = TSetPEFPostponeTimerRsp_from_obj

TSetPEFPostponeTimerRsp.proto_property = {'CompletionCode', 'Timeout'}

TSetPEFPostponeTimerRsp.default = {0, 0}

TSetPEFPostponeTimerRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Timeout', is_array = false, struct = nil}
}

function TSetPEFPostponeTimerRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Timeout', self.Timeout, 'uint8', false, errs, need_convert)

    TSetPEFPostponeTimerRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPEFPostponeTimerRsp.proto_property, errs, need_convert)
    return self
end

function TSetPEFPostponeTimerRsp:unpack(_)
    return self.CompletionCode, self.Timeout
end

SetPEFPostponeTimer.SetPEFPostponeTimerRsp = TSetPEFPostponeTimerRsp

return SetPEFPostponeTimer
