--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetBIOSEventData = {}

---@class SensorIpmiCmds.SetBIOSEventDataReq
---@field ManuId integer
---@field EventDir integer
---@field DeviceStatus integer
---@field Datas string
local TSetBIOSEventDataReq = {}
TSetBIOSEventDataReq.__index = TSetBIOSEventDataReq
TSetBIOSEventDataReq.group = {}

local function TSetBIOSEventDataReq_from_obj(obj)
    return setmetatable(obj, TSetBIOSEventDataReq)
end

function TSetBIOSEventDataReq.new(ManuId, EventDir, DeviceStatus, Datas)
    return TSetBIOSEventDataReq_from_obj({
        ManuId = ManuId,
        EventDir = EventDir,
        DeviceStatus = DeviceStatus,
        Datas = Datas
    })
end
---@param obj SensorIpmiCmds.SetBIOSEventDataReq
function TSetBIOSEventDataReq:init_from_obj(obj)
    self.ManuId = obj.ManuId
    self.EventDir = obj.EventDir
    self.DeviceStatus = obj.DeviceStatus
    self.Datas = obj.Datas
end

function TSetBIOSEventDataReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBIOSEventDataReq.group)
end

TSetBIOSEventDataReq.from_obj = TSetBIOSEventDataReq_from_obj

TSetBIOSEventDataReq.proto_property = {'ManuId', 'EventDir', 'DeviceStatus', 'Datas'}

TSetBIOSEventDataReq.default = {0, 0, 0, ''}

TSetBIOSEventDataReq.struct = {
    {name = 'ManuId', is_array = false, struct = nil}, {name = 'EventDir', is_array = false, struct = nil},
    {name = 'DeviceStatus', is_array = false, struct = nil}, {name = 'Datas', is_array = false, struct = nil}
}

function TSetBIOSEventDataReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManuId', self.ManuId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EventDir', self.EventDir, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceStatus', self.DeviceStatus, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Datas', self.Datas, 'string', false, errs, need_convert)

    TSetBIOSEventDataReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBIOSEventDataReq.proto_property, errs, need_convert)
    return self
end

function TSetBIOSEventDataReq:unpack(_)
    return self.ManuId, self.EventDir, self.DeviceStatus, self.Datas
end

SetBIOSEventData.SetBIOSEventDataReq = TSetBIOSEventDataReq

---@class SensorIpmiCmds.SetBIOSEventDataRsp
---@field CompletionCode integer
---@field ManuId integer
local TSetBIOSEventDataRsp = {}
TSetBIOSEventDataRsp.__index = TSetBIOSEventDataRsp
TSetBIOSEventDataRsp.group = {}

local function TSetBIOSEventDataRsp_from_obj(obj)
    return setmetatable(obj, TSetBIOSEventDataRsp)
end

function TSetBIOSEventDataRsp.new(CompletionCode, ManuId)
    return TSetBIOSEventDataRsp_from_obj({CompletionCode = CompletionCode, ManuId = ManuId})
end
---@param obj SensorIpmiCmds.SetBIOSEventDataRsp
function TSetBIOSEventDataRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManuId = obj.ManuId
end

function TSetBIOSEventDataRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBIOSEventDataRsp.group)
end

TSetBIOSEventDataRsp.from_obj = TSetBIOSEventDataRsp_from_obj

TSetBIOSEventDataRsp.proto_property = {'CompletionCode', 'ManuId'}

TSetBIOSEventDataRsp.default = {0, 0}

TSetBIOSEventDataRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManuId', is_array = false, struct = nil}
}

function TSetBIOSEventDataRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManuId', self.ManuId, 'uint32', false, errs, need_convert)

    TSetBIOSEventDataRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBIOSEventDataRsp.proto_property, errs, need_convert)
    return self
end

function TSetBIOSEventDataRsp:unpack(_)
    return self.CompletionCode, self.ManuId
end

SetBIOSEventData.SetBIOSEventDataRsp = TSetBIOSEventDataRsp

return SetBIOSEventData
