--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local ReportSensorEvent = {}

---@class SensorIpmiCmds.ReportSensorEventReq
---@field Datas string
local TReportSensorEventReq = {}
TReportSensorEventReq.__index = TReportSensorEventReq
TReportSensorEventReq.group = {}

local function TReportSensorEventReq_from_obj(obj)
    return setmetatable(obj, TReportSensorEventReq)
end

function TReportSensorEventReq.new(Datas)
    return TReportSensorEventReq_from_obj({Datas = Datas})
end
---@param obj SensorIpmiCmds.ReportSensorEventReq
function TReportSensorEventReq:init_from_obj(obj)
    self.Datas = obj.Datas
end

function TReportSensorEventReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReportSensorEventReq.group)
end

TReportSensorEventReq.from_obj = TReportSensorEventReq_from_obj

TReportSensorEventReq.proto_property = {'Datas'}

TReportSensorEventReq.default = {''}

TReportSensorEventReq.struct = {{name = 'Datas', is_array = false, struct = nil}}

function TReportSensorEventReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Datas', self.Datas, 'string', false, errs, need_convert)

    TReportSensorEventReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReportSensorEventReq.proto_property, errs, need_convert)
    return self
end

function TReportSensorEventReq:unpack(_)
    return self.Datas
end

ReportSensorEvent.ReportSensorEventReq = TReportSensorEventReq

---@class SensorIpmiCmds.ReportSensorEventRsp
---@field CompletionCode integer
local TReportSensorEventRsp = {}
TReportSensorEventRsp.__index = TReportSensorEventRsp
TReportSensorEventRsp.group = {}

local function TReportSensorEventRsp_from_obj(obj)
    return setmetatable(obj, TReportSensorEventRsp)
end

function TReportSensorEventRsp.new(CompletionCode)
    return TReportSensorEventRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj SensorIpmiCmds.ReportSensorEventRsp
function TReportSensorEventRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TReportSensorEventRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReportSensorEventRsp.group)
end

TReportSensorEventRsp.from_obj = TReportSensorEventRsp_from_obj

TReportSensorEventRsp.proto_property = {'CompletionCode'}

TReportSensorEventRsp.default = {0}

TReportSensorEventRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TReportSensorEventRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TReportSensorEventRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReportSensorEventRsp.proto_property, errs, need_convert)
    return self
end

function TReportSensorEventRsp:unpack(_)
    return self.CompletionCode
end

ReportSensorEvent.ReportSensorEventRsp = TReportSensorEventRsp

return ReportSensorEvent
