--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local RearmSensorEvent = {}

---@class SensorIpmiCmds.RearmSensorEventReq
---@field Number integer
---@field Reserved integer
---@field RearmAll integer
---@field RearmAssert integer
---@field RearmDeassert integer
local TRearmSensorEventReq = {}
TRearmSensorEventReq.__index = TRearmSensorEventReq
TRearmSensorEventReq.group = {}

local function TRearmSensorEventReq_from_obj(obj)
    return setmetatable(obj, TRearmSensorEventReq)
end

function TRearmSensorEventReq.new(Number, Reserved, RearmAll, RearmAssert, RearmDeassert)
    return TRearmSensorEventReq_from_obj({
        Number = Number,
        Reserved = Reserved,
        RearmAll = RearmAll,
        RearmAssert = RearmAssert,
        RearmDeassert = RearmDeassert
    })
end
---@param obj SensorIpmiCmds.RearmSensorEventReq
function TRearmSensorEventReq:init_from_obj(obj)
    self.Number = obj.Number
    self.Reserved = obj.Reserved
    self.RearmAll = obj.RearmAll
    self.RearmAssert = obj.RearmAssert
    self.RearmDeassert = obj.RearmDeassert
end

function TRearmSensorEventReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRearmSensorEventReq.group)
end

TRearmSensorEventReq.from_obj = TRearmSensorEventReq_from_obj

TRearmSensorEventReq.proto_property = {'Number', 'Reserved', 'RearmAll', 'RearmAssert', 'RearmDeassert'}

TRearmSensorEventReq.default = {0, 0, 0, 0, 0}

TRearmSensorEventReq.struct = {
    {name = 'Number', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'RearmAll', is_array = false, struct = nil}, {name = 'RearmAssert', is_array = false, struct = nil},
    {name = 'RearmDeassert', is_array = false, struct = nil}
}

function TRearmSensorEventReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Number', self.Number, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RearmAll', self.RearmAll, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RearmAssert', self.RearmAssert, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'RearmDeassert', self.RearmDeassert, 'uint16', false, errs, need_convert)

    TRearmSensorEventReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRearmSensorEventReq.proto_property, errs, need_convert)
    return self
end

function TRearmSensorEventReq:unpack(_)
    return self.Number, self.Reserved, self.RearmAll, self.RearmAssert, self.RearmDeassert
end

RearmSensorEvent.RearmSensorEventReq = TRearmSensorEventReq

---@class SensorIpmiCmds.RearmSensorEventRsp
---@field CompletionCode integer
local TRearmSensorEventRsp = {}
TRearmSensorEventRsp.__index = TRearmSensorEventRsp
TRearmSensorEventRsp.group = {}

local function TRearmSensorEventRsp_from_obj(obj)
    return setmetatable(obj, TRearmSensorEventRsp)
end

function TRearmSensorEventRsp.new(CompletionCode)
    return TRearmSensorEventRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj SensorIpmiCmds.RearmSensorEventRsp
function TRearmSensorEventRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TRearmSensorEventRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRearmSensorEventRsp.group)
end

TRearmSensorEventRsp.from_obj = TRearmSensorEventRsp_from_obj

TRearmSensorEventRsp.proto_property = {'CompletionCode'}

TRearmSensorEventRsp.default = {0}

TRearmSensorEventRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TRearmSensorEventRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TRearmSensorEventRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRearmSensorEventRsp.proto_property, errs, need_convert)
    return self
end

function TRearmSensorEventRsp:unpack(_)
    return self.CompletionCode
end

RearmSensorEvent.RearmSensorEventRsp = TRearmSensorEventRsp

return RearmSensorEvent
