--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local OEMGetSystemSel = {}

---@class SensorIpmiCmds.OEMGetSystemSelReq
---@field ManuId integer
---@field RecordId integer
local TOEMGetSystemSelReq = {}
TOEMGetSystemSelReq.__index = TOEMGetSystemSelReq
TOEMGetSystemSelReq.group = {}

local function TOEMGetSystemSelReq_from_obj(obj)
    return setmetatable(obj, TOEMGetSystemSelReq)
end

function TOEMGetSystemSelReq.new(ManuId, RecordId)
    return TOEMGetSystemSelReq_from_obj({ManuId = ManuId, RecordId = RecordId})
end
---@param obj SensorIpmiCmds.OEMGetSystemSelReq
function TOEMGetSystemSelReq:init_from_obj(obj)
    self.ManuId = obj.ManuId
    self.RecordId = obj.RecordId
end

function TOEMGetSystemSelReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOEMGetSystemSelReq.group)
end

TOEMGetSystemSelReq.from_obj = TOEMGetSystemSelReq_from_obj

TOEMGetSystemSelReq.proto_property = {'ManuId', 'RecordId'}

TOEMGetSystemSelReq.default = {0, 0}

TOEMGetSystemSelReq.struct = {
    {name = 'ManuId', is_array = false, struct = nil}, {name = 'RecordId', is_array = false, struct = nil}
}

function TOEMGetSystemSelReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManuId', self.ManuId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordId', self.RecordId, 'uint16', false, errs, need_convert)

    TOEMGetSystemSelReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOEMGetSystemSelReq.proto_property, errs, need_convert)
    return self
end

function TOEMGetSystemSelReq:unpack(_)
    return self.ManuId, self.RecordId
end

OEMGetSystemSel.OEMGetSystemSelReq = TOEMGetSystemSelReq

---@class SensorIpmiCmds.OEMGetSystemSelRsp
---@field CompletionCode integer
---@field ManuId integer
---@field RecordId integer
---@field Datas string
local TOEMGetSystemSelRsp = {}
TOEMGetSystemSelRsp.__index = TOEMGetSystemSelRsp
TOEMGetSystemSelRsp.group = {}

local function TOEMGetSystemSelRsp_from_obj(obj)
    return setmetatable(obj, TOEMGetSystemSelRsp)
end

function TOEMGetSystemSelRsp.new(CompletionCode, ManuId, RecordId, Datas)
    return TOEMGetSystemSelRsp_from_obj({
        CompletionCode = CompletionCode,
        ManuId = ManuId,
        RecordId = RecordId,
        Datas = Datas
    })
end
---@param obj SensorIpmiCmds.OEMGetSystemSelRsp
function TOEMGetSystemSelRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManuId = obj.ManuId
    self.RecordId = obj.RecordId
    self.Datas = obj.Datas
end

function TOEMGetSystemSelRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOEMGetSystemSelRsp.group)
end

TOEMGetSystemSelRsp.from_obj = TOEMGetSystemSelRsp_from_obj

TOEMGetSystemSelRsp.proto_property = {'CompletionCode', 'ManuId', 'RecordId', 'Datas'}

TOEMGetSystemSelRsp.default = {0, 0, 0, ''}

TOEMGetSystemSelRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManuId', is_array = false, struct = nil},
    {name = 'RecordId', is_array = false, struct = nil}, {name = 'Datas', is_array = false, struct = nil}
}

function TOEMGetSystemSelRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManuId', self.ManuId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'RecordId', self.RecordId, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Datas', self.Datas, 'string', false, errs, need_convert)

    TOEMGetSystemSelRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOEMGetSystemSelRsp.proto_property, errs, need_convert)
    return self
end

function TOEMGetSystemSelRsp:unpack(_)
    return self.CompletionCode, self.ManuId, self.RecordId, self.Datas
end

OEMGetSystemSel.OEMGetSystemSelRsp = TOEMGetSystemSelRsp

return OEMGetSystemSel
