--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetSensorType = {}

---@class SensorIpmiCmds.GetSensorTypeReq
---@field Number integer
local TGetSensorTypeReq = {}
TGetSensorTypeReq.__index = TGetSensorTypeReq
TGetSensorTypeReq.group = {}

local function TGetSensorTypeReq_from_obj(obj)
    return setmetatable(obj, TGetSensorTypeReq)
end

function TGetSensorTypeReq.new(Number)
    return TGetSensorTypeReq_from_obj({Number = Number})
end
---@param obj SensorIpmiCmds.GetSensorTypeReq
function TGetSensorTypeReq:init_from_obj(obj)
    self.Number = obj.Number
end

function TGetSensorTypeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSensorTypeReq.group)
end

TGetSensorTypeReq.from_obj = TGetSensorTypeReq_from_obj

TGetSensorTypeReq.proto_property = {'Number'}

TGetSensorTypeReq.default = {0}

TGetSensorTypeReq.struct = {{name = 'Number', is_array = false, struct = nil}}

function TGetSensorTypeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Number', self.Number, 'uint8', false, errs, need_convert)

    TGetSensorTypeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSensorTypeReq.proto_property, errs, need_convert)
    return self
end

function TGetSensorTypeReq:unpack(_)
    return self.Number
end

GetSensorType.GetSensorTypeReq = TGetSensorTypeReq

---@class SensorIpmiCmds.GetSensorTypeRsp
---@field CompletionCode integer
---@field Type integer
---@field TypeCode integer
---@field Reserved integer
local TGetSensorTypeRsp = {}
TGetSensorTypeRsp.__index = TGetSensorTypeRsp
TGetSensorTypeRsp.group = {}

local function TGetSensorTypeRsp_from_obj(obj)
    return setmetatable(obj, TGetSensorTypeRsp)
end

function TGetSensorTypeRsp.new(CompletionCode, Type, TypeCode, Reserved)
    return TGetSensorTypeRsp_from_obj({
        CompletionCode = CompletionCode,
        Type = Type,
        TypeCode = TypeCode,
        Reserved = Reserved
    })
end
---@param obj SensorIpmiCmds.GetSensorTypeRsp
function TGetSensorTypeRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Type = obj.Type
    self.TypeCode = obj.TypeCode
    self.Reserved = obj.Reserved
end

function TGetSensorTypeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSensorTypeRsp.group)
end

TGetSensorTypeRsp.from_obj = TGetSensorTypeRsp_from_obj

TGetSensorTypeRsp.proto_property = {'CompletionCode', 'Type', 'TypeCode', 'Reserved'}

TGetSensorTypeRsp.default = {0, 0, 0, 0}

TGetSensorTypeRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Type', is_array = false, struct = nil},
    {name = 'TypeCode', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil}
}

function TGetSensorTypeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Type', self.Type, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'TypeCode', self.TypeCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)

    TGetSensorTypeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSensorTypeRsp.proto_property, errs, need_convert)
    return self
end

function TGetSensorTypeRsp:unpack(_)
    return self.CompletionCode, self.Type, self.TypeCode, self.Reserved
end

GetSensorType.GetSensorTypeRsp = TGetSensorTypeRsp

return GetSensorType
